/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.builtins.Function;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import java.util.Collection;
import java.util.Collections;
import org.mindswap.pellet.Literal;

public class FunctionBuiltIn
implements BuiltIn {
    private Function function;

    public FunctionBuiltIn(Function function) {
        this.function = function;
    }

    @Override
    public BindingHelper createHelper(BuiltInAtom builtInAtom) {
        return new FunctionHelper(builtInAtom);
    }

    private class FunctionHelper
    implements BindingHelper {
        private BuiltInAtom atom;
        private AtomDObject head;
        private Literal value;
        private boolean used;

        public FunctionHelper(BuiltInAtom builtInAtom) {
            this.atom = builtInAtom;
        }

        @Override
        public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> collection) {
            AtomDObject atomDObject = null;
            for (AtomDObject atomDObject2 : this.atom.getAllArguments()) {
                if (!(atomDObject == null ? !VariableUtils.isVariable(atomDObject = atomDObject2) : atomDObject.equals(atomDObject2))) continue;
                return Collections.emptySet();
            }
            if (atomDObject == null) {
                return Collections.emptySet();
            }
            return Collections.singleton((AtomVariable)((Object)atomDObject));
        }

        @Override
        public Collection<? extends AtomVariable> getPrerequisiteVars(Collection<AtomVariable> collection) {
            Collection<AtomVariable> collection2 = VariableUtils.getVars(this.atom);
            collection2.removeAll(this.getBindableVars(collection));
            return collection2;
        }

        @Override
        public void rebind(VariableBinding variableBinding) {
            this.used = false;
            this.head = null;
            this.value = null;
            Literal literal = null;
            if (this.atom.getAllArguments().size() == 0) {
                return;
            }
            Literal[] literalArray = new Literal[this.atom.getAllArguments().size() - 1];
            int n = 0;
            for (AtomDObject atomDObject : this.atom.getAllArguments()) {
                Literal literal2 = variableBinding.get(atomDObject);
                if (n == 0) {
                    if (literal2 != null) {
                        literal = literal2;
                    }
                    this.head = atomDObject;
                    ++n;
                    continue;
                }
                literalArray[n - 1] = literal2;
                ++n;
            }
            this.value = FunctionBuiltIn.this.function.apply(variableBinding.getABox(), literal, literalArray);
        }

        @Override
        public boolean selectNextBinding() {
            if (this.value != null && !this.used) {
                this.used = true;
                return true;
            }
            return false;
        }

        @Override
        public void setCurrentBinding(VariableBinding variableBinding) {
            variableBinding.set(this.head, this.value);
        }
    }
}

