/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomObject;
import com.clarkparsia.pellet.rules.model.AtomObjectVisitor;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.rules.rete.Compiler;
import com.clarkparsia.pellet.rules.rete.TermTuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;

public class RulesToReteTranslator {
    private static Logger log = ABox.log;
    private ABox abox;

    public RulesToReteTranslator(ABox aBox) {
        this.abox = aBox;
    }

    public TermTuple translateAtom(RuleAtom ruleAtom, DependencySet dependencySet) {
        AtomTranslator atomTranslator = new AtomTranslator(dependencySet);
        ruleAtom.accept(atomTranslator);
        return atomTranslator.getResult();
    }

    public Pair<ATermAppl, DependencySet> translateAtomObject(AtomObject atomObject) {
        AtomObjectTranslator atomObjectTranslator = new AtomObjectTranslator();
        atomObject.accept(atomObjectTranslator);
        return new Pair<ATermAppl, DependencySet>(atomObjectTranslator.getResult(), atomObjectTranslator.getDependency());
    }

    public List<TermTuple> translateAtoms(Collection<? extends RuleAtom> collection, DependencySet dependencySet) {
        ArrayList<TermTuple> arrayList = new ArrayList<TermTuple>(collection.size());
        for (RuleAtom ruleAtom : collection) {
            TermTuple termTuple = this.translateAtom(ruleAtom, dependencySet);
            if (termTuple == null) {
                return null;
            }
            arrayList.add(termTuple);
        }
        return arrayList;
    }

    public com.clarkparsia.pellet.rules.rete.Rule translateRule(Rule rule) {
        com.clarkparsia.pellet.rules.rete.Rule rule2;
        DependencySet dependencySet = DependencySet.INDEPENDENT;
        List<TermTuple> list = this.translateAtoms(rule.getHead(), dependencySet);
        List<TermTuple> list2 = this.translateAtoms(rule.getBody(), dependencySet);
        if (list == null || list2 == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Not translating rule " + rule + " to rete format.");
            }
            rule2 = null;
        } else {
            rule2 = new com.clarkparsia.pellet.rules.rete.Rule(list2, list);
        }
        return rule2;
    }

    private class AtomTranslator
    implements RuleAtomVisitor {
        private DependencySet ds = null;
        private TermTuple result = null;

        public AtomTranslator(DependencySet dependencySet) {
            this.ds = dependencySet;
        }

        public TermTuple getResult() {
            return this.result;
        }

        @Override
        public void visit(BuiltInAtom builtInAtom) {
            log.fine("Not translating built-in " + builtInAtom + " to rete triple.");
        }

        @Override
        public void visit(ClassAtom classAtom) {
            Pair<ATermAppl, DependencySet> pair = RulesToReteTranslator.this.translateAtomObject((AtomObject)classAtom.getArgument());
            DependencySet dependencySet = this.ds;
            if (pair.second != DependencySet.INDEPENDENT) {
                dependencySet = this.ds.union((DependencySet)pair.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            this.result = new TermTuple(dependencySet, Compiler.TYPE, (ATermAppl)pair.first, (ATermAppl)classAtom.getPredicate());
        }

        @Override
        public void visit(DataRangeAtom dataRangeAtom) {
            log.fine("Not translating data range atom " + dataRangeAtom + " to rete triple.");
        }

        @Override
        public void visit(DatavaluedPropertyAtom datavaluedPropertyAtom) {
            Pair<ATermAppl, DependencySet> pair = RulesToReteTranslator.this.translateAtomObject((AtomObject)datavaluedPropertyAtom.getArgument1());
            Pair<ATermAppl, DependencySet> pair2 = RulesToReteTranslator.this.translateAtomObject((AtomObject)datavaluedPropertyAtom.getArgument2());
            DependencySet dependencySet = this.ds;
            if (pair.second != DependencySet.INDEPENDENT) {
                dependencySet = this.ds.union((DependencySet)pair.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            if (pair2.second != DependencySet.INDEPENDENT) {
                dependencySet = this.ds.union((DependencySet)pair2.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            this.result = new TermTuple(dependencySet, (ATermAppl)datavaluedPropertyAtom.getPredicate(), (ATermAppl)pair.first, (ATermAppl)pair2.first);
        }

        @Override
        public void visit(DifferentIndividualsAtom differentIndividualsAtom) {
            Pair<ATermAppl, DependencySet> pair = RulesToReteTranslator.this.translateAtomObject((AtomObject)differentIndividualsAtom.getArgument1());
            Pair<ATermAppl, DependencySet> pair2 = RulesToReteTranslator.this.translateAtomObject((AtomObject)differentIndividualsAtom.getArgument2());
            DependencySet dependencySet = this.ds;
            if (pair.second != DependencySet.INDEPENDENT) {
                dependencySet = this.ds.union((DependencySet)pair.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            if (pair2.second != DependencySet.INDEPENDENT) {
                dependencySet = this.ds.union((DependencySet)pair2.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            this.result = new TermTuple(dependencySet, Compiler.DIFF_FROM, (ATermAppl)pair.first, (ATermAppl)pair2.first);
        }

        @Override
        public void visit(IndividualPropertyAtom individualPropertyAtom) {
            Pair<ATermAppl, DependencySet> pair = RulesToReteTranslator.this.translateAtomObject((AtomObject)individualPropertyAtom.getArgument1());
            Pair<ATermAppl, DependencySet> pair2 = RulesToReteTranslator.this.translateAtomObject((AtomObject)individualPropertyAtom.getArgument2());
            DependencySet dependencySet = this.ds;
            if (pair.second != DependencySet.INDEPENDENT) {
                dependencySet = this.ds.union((DependencySet)pair.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            if (pair2.second != DependencySet.INDEPENDENT) {
                dependencySet = this.ds.union((DependencySet)pair2.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            this.result = new TermTuple(dependencySet, (ATermAppl)individualPropertyAtom.getPredicate(), (ATermAppl)pair.first, (ATermAppl)pair2.first);
        }

        @Override
        public void visit(SameIndividualAtom sameIndividualAtom) {
            Pair<ATermAppl, DependencySet> pair = RulesToReteTranslator.this.translateAtomObject((AtomObject)sameIndividualAtom.getArgument1());
            Pair<ATermAppl, DependencySet> pair2 = RulesToReteTranslator.this.translateAtomObject((AtomObject)sameIndividualAtom.getArgument2());
            DependencySet dependencySet = this.ds;
            if (pair.second != DependencySet.INDEPENDENT) {
                dependencySet = this.ds.union((DependencySet)pair.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            if (pair2.second != DependencySet.INDEPENDENT) {
                dependencySet = this.ds.union((DependencySet)pair2.second, RulesToReteTranslator.this.abox.doExplanation());
            }
            this.result = new TermTuple(dependencySet, Compiler.SAME_AS, (ATermAppl)pair.first, (ATermAppl)pair2.first);
        }
    }

    private class AtomObjectTranslator
    implements AtomObjectVisitor {
        private DependencySet dependency = DependencySet.INDEPENDENT;
        private ATermAppl result = null;

        private AtomObjectTranslator() {
        }

        public DependencySet getDependency() {
            return this.dependency;
        }

        public ATermAppl getResult() {
            return this.result;
        }

        @Override
        public void visit(AtomDConstant atomDConstant) {
            ATermAppl aTermAppl;
            ATermAppl aTermAppl2 = atomDConstant.getValue();
            try {
                aTermAppl = RulesToReteTranslator.this.abox.getKB().getDatatypeReasoner().getCanonicalRepresentation(aTermAppl2);
            }
            catch (InvalidLiteralException invalidLiteralException) {
                String string = String.format("Invalid literal (%s) in SWRL data constant: %s", aTermAppl2, invalidLiteralException.getMessage());
                if (PelletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                    log.fine(string);
                    aTermAppl = aTermAppl2;
                }
                log.severe(string);
                throw new InternalReasonerException(string, invalidLiteralException);
            }
            catch (UnrecognizedDatatypeException unrecognizedDatatypeException) {
                String string = String.format("Unrecognized datatype in literal appearing (%s) in SWRL data constant: %s", aTermAppl2, unrecognizedDatatypeException.getMessage());
                log.severe(string);
                throw new InternalReasonerException(string, unrecognizedDatatypeException);
            }
            this.result = aTermAppl;
        }

        @Override
        public void visit(AtomDVariable atomDVariable) {
            this.result = ATermUtils.makeVar(atomDVariable.getName());
        }

        @Override
        public void visit(AtomIConstant atomIConstant) {
            RulesToReteTranslator.this.abox.copyOnWrite();
            Individual individual = RulesToReteTranslator.this.abox.getIndividual((ATerm)atomIConstant.getValue());
            if (individual.isMerged()) {
                this.dependency = individual.getMergeDependency(true);
                individual = individual.getSame();
            }
            this.result = individual.getName();
        }

        @Override
        public void visit(AtomIVariable atomIVariable) {
            this.result = ATermUtils.makeVar(atomIVariable.getName());
        }
    }
}

