/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.el.RuleBasedELClassifier;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.builtins.NotEqual;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MultiValueMap;

public class JenaBasedELClassifier
extends RuleBasedELClassifier
implements TaxonomyBuilder {
    private static final String PREDICATE_PREFIX = "tag:clarkparsia.com,2008:pellet:el:predicate:";
    private static final Node PRED_SUB = Node.createURI((String)"tag:clarkparsia.com,2008:pellet:el:predicate:subclassOf");
    private static final Builtin NOT_EQUAL = new NotEqual();
    private final Node TOP;
    private final Node BOTTOM;
    private NameStore m_Names = new NameStore();
    private VariableStore m_Variables = new VariableStore();
    private Set<Rule> m_Rules = CollectionUtils.makeSet();
    private Graph m_Facts = GraphFactory.createDefaultGraph();

    public JenaBasedELClassifier() {
        this.TOP = this.m_Names.get(ATermUtils.TOP);
        this.BOTTOM = this.m_Names.get(ATermUtils.BOTTOM);
        this.makeRuleAxioms();
    }

    protected void addClasses(Collection<ATermAppl> collection) {
        for (ATermAppl aTermAppl : collection) {
            Node node = this.m_Names.get(aTermAppl);
            this.m_Facts.add(Triple.create((Node)node, (Node)PRED_SUB, (Node)node));
            this.m_Facts.add(Triple.create((Node)node, (Node)PRED_SUB, (Node)this.TOP));
        }
    }

    @Override
    protected MultiValueMap<ATermAppl, ATermAppl> run(Collection<ATermAppl> collection) {
        this.addClasses(collection);
        this.addClasses(this.m_Names.getAllAnons());
        GenericRuleReasoner genericRuleReasoner = new GenericRuleReasoner(new ArrayList<Rule>(this.m_Rules));
        InfGraph infGraph = genericRuleReasoner.bind(this.m_Facts);
        infGraph.prepare();
        MultiValueMap<ATermAppl, ATermAppl> multiValueMap = this.getSubsumptions((Graph)infGraph);
        for (ATermAppl aTermAppl : collection) {
            multiValueMap.add(ATermUtils.BOTTOM, aTermAppl);
        }
        return multiValueMap;
    }

    protected MultiValueMap<ATermAppl, ATermAppl> getSubsumptions(Graph graph) {
        MultiValueMap<ATermAppl, ATermAppl> multiValueMap = new MultiValueMap<ATermAppl, ATermAppl>();
        ExtendedIterator extendedIterator = graph.find(Node.ANY, PRED_SUB, Node.ANY);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            Node node = triple.getSubject();
            Node node2 = triple.getObject();
            if (NameStore.isAnon(node) || NameStore.isAnon(node2)) continue;
            multiValueMap.add(this.toATermAppl(node), this.toATermAppl(node2));
        }
        extendedIterator.close();
        return multiValueMap;
    }

    private ATermAppl toATermAppl(Node node) {
        if (this.TOP.hasURI(node.getURI())) {
            return ATermUtils.TOP;
        }
        if (this.BOTTOM.hasURI(node.getURI())) {
            return ATermUtils.BOTTOM;
        }
        return ATermUtils.makeTermAppl(node.getURI());
    }

    @Override
    protected void addSubclassRule(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.addSubclassRule(aTermAppl, aTermAppl2, new FreeVariableStore());
    }

    @Override
    protected void addRoleDomainRule(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        List list = CollectionUtils.makeList();
        List<ClauseEntry> list2 = CollectionUtils.makeList();
        FreeVariableStore freeVariableStore = new FreeVariableStore();
        Node node = freeVariableStore.next();
        Node node2 = freeVariableStore.next();
        list.add(this.makeSubOfSomeTriple(node, aTermAppl, node2));
        this.translateSuper(list2, aTermAppl2, freeVariableStore, node);
        this.m_Rules.add(new Rule(list2, list));
    }

    @Override
    protected void addRoleRangeRule(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        List list = CollectionUtils.makeList();
        List<ClauseEntry> list2 = CollectionUtils.makeList();
        FreeVariableStore freeVariableStore = new FreeVariableStore();
        Node node = freeVariableStore.next();
        Node node2 = freeVariableStore.next();
        list.add(this.makeSubOfSomeTriple(node, aTermAppl, node2));
        ATermAppl aTermAppl3 = ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)aTermAppl2);
        this.translateSuper(list2, aTermAppl3, freeVariableStore, node);
        this.m_Rules.add(new Rule(list2, list));
    }

    @Override
    protected void addRoleChainRule(ATerm[] aTermArray, ATermAppl aTermAppl) {
        if (aTermArray.length < 1) {
            return;
        }
        List list = CollectionUtils.makeList();
        FreeVariableStore freeVariableStore = new FreeVariableStore();
        Node[] nodeArray = new Node[aTermArray.length + 1];
        nodeArray[0] = freeVariableStore.next();
        for (int i = 0; i < aTermArray.length; ++i) {
            nodeArray[i + 1] = freeVariableStore.next();
            list.add(this.makeSubOfSomeTriple(nodeArray[i], (ATermAppl)aTermArray[i], nodeArray[i + 1]));
        }
        TriplePattern triplePattern = this.makeSubOfSomeTriple(nodeArray[0], aTermAppl, nodeArray[nodeArray.length - 1]);
        this.m_Rules.add(new Rule(Collections.singletonList(triplePattern), list));
    }

    @Override
    protected void addRoleHierarchyRule(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.addRoleChainRule(new ATerm[]{aTermAppl}, aTermAppl2);
    }

    private void makeRuleAxioms() {
        this.makeBottomAxiom();
    }

    private void makeBottomAxiom() {
        FreeVariableStore freeVariableStore = new FreeVariableStore();
        Node node = freeVariableStore.next();
        Node node2 = freeVariableStore.next();
        Node node3 = freeVariableStore.next();
        List list = CollectionUtils.makeList();
        list.add(this.makeSubOfSomeTriple(node, node2, node3));
        list.add(this.makePropertyAssertionFunctor(node2));
        list.add(this.makeSubclassTriple(node3, this.BOTTOM));
        TriplePattern triplePattern = this.makeSubclassTriple(node, this.BOTTOM);
        this.m_Rules.add(new Rule(Collections.singletonList(triplePattern), list));
    }

    private void addSubclassRule(ATermAppl aTermAppl, ATermAppl aTermAppl2, FreeVariableStore freeVariableStore) {
        List<ClauseEntry> list = CollectionUtils.makeList();
        List<ClauseEntry> list2 = CollectionUtils.makeList();
        Node node = freeVariableStore.next();
        this.translateSub(list, aTermAppl, freeVariableStore, node);
        this.translateSuper(list2, aTermAppl2, freeVariableStore, node);
        this.m_Rules.add(new Rule(list2, list));
    }

    private void translateSub(List<ClauseEntry> list, ATermAppl aTermAppl, FreeVariableStore freeVariableStore, Node node) {
        AFun aFun = aTermAppl.getAFun();
        if (ATermUtils.isPrimitive(aTermAppl) || ATermUtils.isBottom(aTermAppl)) {
            list.add((ClauseEntry)this.makeSubclassTriple(node, this.m_Names.get(aTermAppl)));
        } else if (aFun.equals(ATermUtils.ANDFUN)) {
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            while (!aTermList.isEmpty()) {
                ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
                this.translateSub(list, aTermAppl2, freeVariableStore, node);
                aTermList = aTermList.getNext();
            }
        } else if (aFun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(0);
            ATermAppl aTermAppl4 = (ATermAppl)aTermAppl.getArgument(1);
            Node node2 = freeVariableStore.next();
            list.add((ClauseEntry)this.makeSubOfSomeTriple(node, aTermAppl3, node2));
            this.translateSub(list, aTermAppl4, freeVariableStore, node2);
        } else assert (false);
    }

    private void translateSuper(List<ClauseEntry> list, ATermAppl aTermAppl, FreeVariableStore freeVariableStore, Node node) {
        AFun aFun = aTermAppl.getAFun();
        if (ATermUtils.isPrimitive(aTermAppl) || ATermUtils.isBottom(aTermAppl)) {
            list.add((ClauseEntry)this.makeSubclassTriple(node, this.m_Names.get(aTermAppl)));
        } else if (aFun.equals(ATermUtils.ANDFUN)) {
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            while (!aTermList.isEmpty()) {
                ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
                this.translateSuper(list, aTermAppl2, freeVariableStore, node);
                aTermList = aTermList.getNext();
            }
        } else if (aFun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(0);
            ATermAppl aTermAppl4 = (ATermAppl)aTermAppl.getArgument(1);
            if (!ATermUtils.isPrimitive(aTermAppl4) && !ATermUtils.isBottom(aTermAppl4)) {
                ATermAppl aTermAppl5 = this.m_Names.getNextAnon();
                this.translateSuperSome(aTermAppl5, aTermAppl4);
                aTermAppl4 = aTermAppl5;
            }
            list.add((ClauseEntry)this.makeSubOfSomeTriple(node, aTermAppl3, this.m_Names.get(aTermAppl4)));
        } else assert (false);
    }

    private void translateSuperSome(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        AFun aFun = aTermAppl2.getAFun();
        if (ATermUtils.isPrimitive(aTermAppl2) || ATermUtils.isBottom(aTermAppl2)) {
            this.m_Facts.add(this.makeSubclassFact(aTermAppl, aTermAppl2));
        } else if (aFun.equals(ATermUtils.ANDFUN)) {
            ATermList aTermList = (ATermList)aTermAppl2.getArgument(0);
            while (!aTermList.isEmpty()) {
                ATermAppl aTermAppl3 = (ATermAppl)aTermList.getFirst();
                this.translateSuperSome(aTermAppl, aTermAppl3);
                aTermList = aTermList.getNext();
            }
        } else if (aFun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl aTermAppl4 = (ATermAppl)aTermAppl2.getArgument(0);
            ATermAppl aTermAppl5 = (ATermAppl)aTermAppl2.getArgument(1);
            if (!ATermUtils.isPrimitive(aTermAppl5) && !ATermUtils.isBottom(aTermAppl5)) {
                ATermAppl aTermAppl6 = this.m_Names.getNextAnon();
                this.translateSuperSome(aTermAppl6, aTermAppl5);
                aTermAppl5 = aTermAppl6;
            }
            this.m_Facts.add(this.makeSubOfSomeFact(aTermAppl, aTermAppl4, aTermAppl5));
        } else assert (false);
    }

    private Triple makeSubclassFact(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return this.makeSubclassFact(this.m_Names.get(aTermAppl), this.m_Names.get(aTermAppl2));
    }

    private Triple makeSubclassFact(Node node, Node node2) {
        return Triple.create((Node)node, (Node)PRED_SUB, (Node)node2);
    }

    private Triple makeSubOfSomeFact(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        return Triple.create((Node)this.m_Names.get(aTermAppl), (Node)this.m_Names.get(aTermAppl2), (Node)this.m_Names.get(aTermAppl3));
    }

    private TriplePattern makeSubclassTriple(Node node, Node node2) {
        return new TriplePattern(node, PRED_SUB, node2);
    }

    private TriplePattern makeSubOfSomeTriple(Node node, ATermAppl aTermAppl, Node node2) {
        return this.makeSubOfSomeTriple(node, this.m_Names.get(aTermAppl), node2);
    }

    private TriplePattern makeSubOfSomeTriple(Node node, Node node2, Node node3) {
        return new TriplePattern(node, node2, node3);
    }

    private Functor makePropertyAssertionFunctor(Node node) {
        Functor functor = new Functor("isNotSubClass", new Node[]{node, PRED_SUB});
        functor.setImplementor(NOT_EQUAL);
        return functor;
    }

    class FreeVariableStore {
        private int m_Next = 0;

        FreeVariableStore() {
        }

        public Node next() {
            return JenaBasedELClassifier.this.m_Variables.get(this.m_Next++);
        }
    }

    static class VariableStore {
        private static final String PREFIX = "x";
        private List<Node> m_Variables = CollectionUtils.makeList();

        VariableStore() {
        }

        public Node get(int n) {
            for (int i = this.m_Variables.size(); i <= n; ++i) {
                this.m_Variables.add((Node)new Node_RuleVariable(PREFIX + i, i));
            }
            return this.m_Variables.get(n);
        }
    }

    static class NameStore {
        private static final String ANON = "tag:clarkparsia.com,2008:pellet:el:anon:";
        private static final int FIRST_ANON = 0;
        private Map<ATermAppl, Node> m_Constants = CollectionUtils.makeMap();
        private int m_NextAnon = 0;

        NameStore() {
        }

        public Node get(ATermAppl aTermAppl) {
            Node node = this.m_Constants.get(aTermAppl);
            if (node == null) {
                node = aTermAppl == ATermUtils.BOTTOM ? Node.createURI((String)"_BOTTOM_") : Node.createURI((String)aTermAppl.getName());
                this.m_Constants.put(aTermAppl, node);
            }
            return node;
        }

        public ATermAppl getNextAnon() {
            return NameStore.makeAnon(this.m_NextAnon++);
        }

        public Set<ATermAppl> getAllAnons() {
            Set<ATermAppl> set = CollectionUtils.makeSet();
            for (int i = 0; i < this.m_NextAnon; ++i) {
                set.add(NameStore.makeAnon(i));
            }
            return set;
        }

        public static boolean isAnon(Node node) {
            return node.getURI().startsWith(ANON);
        }

        private static ATermAppl makeAnon(int n) {
            return ATermUtils.makeTermAppl(ANON + n);
        }
    }
}

