/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.text;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.text.RDFPlainLiteral;
import com.clarkparsia.pellet.datatypes.types.text.RestrictedTextDatatype;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDToken
extends AbstractBaseDatatype<ATermAppl> {
    private static final XSDToken instance;
    private static final RDFPlainLiteral RDF_PLAIN_LITERAL;
    private final RestrictedDatatype<ATermAppl> dataRange = new RestrictedTextDatatype((Datatype<ATermAppl>)this, "([^\\s])(\\s([^\\s])|([^\\s]))*");

    public static XSDToken getInstance() {
        return instance;
    }

    private XSDToken() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#token"));
    }

    @Override
    public RestrictedDatatype<ATermAppl> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        return this.getValue(aTermAppl);
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return RDF_PLAIN_LITERAL;
    }

    @Override
    public ATermAppl getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        String string = this.getLexicalForm(aTermAppl);
        return RDF_PLAIN_LITERAL.getCanonicalRepresentation(ATermUtils.makePlainLiteral(string));
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    static {
        RDF_PLAIN_LITERAL = RDFPlainLiteral.getInstance();
        instance = new XSDToken();
        RestrictedTextDatatype.addPermittedDatatype(instance.getName());
    }
}

