/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import java.math.BigInteger;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDNonPositiveInteger
extends AbstractDerivedIntegerType {
    private static final XSDNonPositiveInteger instance = new XSDNonPositiveInteger();

    public static XSDNonPositiveInteger getInstance() {
        return instance;
    }

    private XSDNonPositiveInteger() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#nonPositiveInteger"), null, 0);
    }

    @Override
    protected Number fromLexicalForm(String string) throws InvalidLiteralException {
        try {
            BigInteger bigInteger = DatatypeConverter.parseInteger(string);
            if (BigInteger.ZERO.compareTo(bigInteger) < 0) {
                throw new InvalidLiteralException(this.getName(), string);
            }
            return bigInteger;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
    }
}

