/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import com.clarkparsia.pellet.datatypes.types.real.Rational;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import pellet.DatatypeConverter;

public class OWLRealUtils {
    private static Logger log = Logger.getLogger(OWLRealUtils.class.getCanonicalName());

    public static boolean acceptable(Class<? extends Number> clazz) {
        return Type.get(clazz) != null;
    }

    public static BigDecimal bigDecimal(Number number) {
        Type type = Type.get(number.getClass());
        if (type == null) {
            String string = String.format("Unexpected number type %s passed to bigDecimal method.", number.getClass().getCanonicalName());
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        BigDecimal bigDecimal = (BigDecimal)OWLRealUtils.convertFromTo(number, type, Type.BIG_DECIMAL);
        return bigDecimal;
    }

    public static BigInteger bigInteger(Number number) {
        Type type = Type.get(number.getClass());
        if (type == null) {
            String string = String.format("Unexpected number type %s passed to bigInteger method.", number.getClass().getCanonicalName());
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        if (Type.BIG_INTEGER.equals((Object)type)) {
            return (BigInteger)number;
        }
        BigInteger bigInteger = (BigInteger)OWLRealUtils.convertFromTo(number, type, Type.BIG_INTEGER);
        return bigInteger;
    }

    public static int compare(Number number, Number number2) {
        int n;
        Type type = Type.get(number.getClass());
        if (type == null) {
            throw new IllegalArgumentException();
        }
        Type type2 = Type.get(number2.getClass());
        if (type2 == null) {
            throw new IllegalArgumentException();
        }
        if (type == type2) {
            return ((Comparable)((Object)number)).compareTo(number2);
        }
        int n2 = OWLRealUtils.signum(number);
        if (n2 == (n = OWLRealUtils.signum(number2))) {
            Type type3 = Type.compareType(type, type2);
            Comparable comparable = type == type3 ? (Comparable)((Object)number) : (Comparable)((Object)OWLRealUtils.convertFromTo(number, type, type3));
            Number number3 = type2 == type3 ? (Number)number2 : (Number)OWLRealUtils.convertFromTo(number2, type2, type3);
            return comparable.compareTo(number3);
        }
        return n2 > n ? 1 : -1;
    }

    private static Number convertFromTo(Number number, Type type, Type type2) {
        if (Type.BIG_DECIMAL.equals((Object)type) && type2.isIntegerOnly()) {
            type = Type.BIG_INTEGER;
            number = ((BigDecimal)number).toBigIntegerExact();
        }
        switch (type2) {
            case BYTE: {
                if (!type.equals((Object)Type.BYTE)) {
                    throw new IllegalArgumentException();
                }
                return number;
            }
            case SHORT: {
                switch (type) {
                    case BYTE: {
                        return number.shortValue();
                    }
                    case SHORT: {
                        return number;
                    }
                }
                throw new IllegalArgumentException();
            }
            case INTEGER: {
                switch (type) {
                    case BYTE: 
                    case SHORT: {
                        return number.intValue();
                    }
                    case INTEGER: {
                        return number;
                    }
                }
                throw new IllegalArgumentException();
            }
            case LONG: {
                switch (type) {
                    case BYTE: 
                    case SHORT: 
                    case INTEGER: {
                        return number.longValue();
                    }
                    case LONG: {
                        return number;
                    }
                }
                throw new IllegalArgumentException();
            }
            case BIG_INTEGER: {
                switch (type) {
                    case BYTE: 
                    case SHORT: 
                    case INTEGER: 
                    case LONG: {
                        return BigInteger.valueOf(number.longValue());
                    }
                    case BIG_INTEGER: {
                        return number;
                    }
                    case BIG_DECIMAL: {
                        try {
                            return ((BigDecimal)number).toBigIntegerExact();
                        }
                        catch (ArithmeticException arithmeticException) {
                            throw new IllegalArgumentException(arithmeticException);
                        }
                    }
                    case RATIONAL: {
                        Rational rational = (Rational)number;
                        if (OWLRealUtils.compare(1, rational.getDenominator()) != 0) {
                            rational = Rational.simplify(rational);
                            if (OWLRealUtils.compare(1, rational.getDenominator()) != 0) {
                                throw new IllegalArgumentException();
                            }
                        }
                        return OWLRealUtils.bigInteger(rational.getNumerator());
                    }
                }
                throw new IllegalArgumentException();
            }
            case BIG_DECIMAL: {
                switch (type) {
                    case BYTE: 
                    case SHORT: 
                    case INTEGER: 
                    case LONG: {
                        return BigDecimal.valueOf(number.longValue());
                    }
                    case BIG_INTEGER: {
                        return new BigDecimal((BigInteger)number);
                    }
                    case BIG_DECIMAL: {
                        return number;
                    }
                }
            }
            case RATIONAL: {
                switch (type) {
                    case BYTE: 
                    case SHORT: 
                    case INTEGER: 
                    case LONG: 
                    case BIG_INTEGER: {
                        return new Rational(number, 1);
                    }
                    case BIG_DECIMAL: {
                        BigDecimal bigDecimal = (BigDecimal)number;
                        BigInteger bigInteger = bigDecimal.unscaledValue();
                        int n = bigDecimal.scale();
                        BigInteger bigInteger2 = BigInteger.TEN.pow(n);
                        return new Rational(bigInteger, bigInteger2);
                    }
                    case RATIONAL: {
                        return number;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public static Number getCanonicalObject(Number number) {
        Type type = Type.get(number.getClass());
        if (type == null) {
            String string = String.format("Unexpected number type %s passed to integerIncrement method.", number.getClass().getCanonicalName());
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        if (OWLRealUtils.isInteger(number)) {
            return OWLRealUtils.shrinkBigInteger(OWLRealUtils.bigInteger(number));
        }
        if (Type.RATIONAL.equals((Object)type)) {
            Rational rational = (Rational)number;
            if (rational.isQuotientExact()) {
                return OWLRealUtils.getCanonicalObject(rational.getQuotient());
            }
            return Rational.simplify(rational);
        }
        if (Type.BIG_DECIMAL.equals((Object)type)) {
            BigDecimal bigDecimal = (BigDecimal)number;
            int n = 0;
            BigInteger bigInteger = bigDecimal.unscaledValue();
            BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(BigInteger.TEN);
            while (BigInteger.ZERO.equals(bigIntegerArray[1])) {
                bigInteger = bigIntegerArray[0];
                --n;
                bigIntegerArray = bigInteger.divideAndRemainder(BigInteger.TEN);
            }
            return n == 0 ? bigDecimal : bigDecimal.setScale(bigDecimal.scale() + n);
        }
        throw new IllegalStateException();
    }

    public static Number integerDecrement(Number number) {
        Type type = Type.get(number.getClass());
        if (type == null) {
            String string = String.format("Unexpected number type %s passed to integerIncrement method.", number.getClass().getCanonicalName());
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        if (!type.isIntegerOnly()) {
            return OWLRealUtils.shrinkBigInteger(OWLRealUtils.bigInteger(number).subtract(BigInteger.ONE));
        }
        switch (type) {
            case BYTE: {
                byte by = number.byteValue();
                return by > -128 ? (short)Byte.valueOf((byte)(by - 1)).byteValue() : Short.valueOf((short)(by - 1));
            }
            case SHORT: {
                short s = number.shortValue();
                return s > Short.MIN_VALUE ? (int)Short.valueOf((short)(s - 1)).shortValue() : Integer.valueOf(s - 1);
            }
            case INTEGER: {
                int n = number.intValue();
                return n > Integer.MIN_VALUE ? (long)Integer.valueOf(n - 1).intValue() : Long.valueOf((long)n - 1L);
            }
            case LONG: {
                long l = number.longValue();
                return l > Long.MIN_VALUE ? Long.valueOf(l - 1L) : BigInteger.valueOf(l).subtract(BigInteger.ONE);
            }
            case BIG_INTEGER: {
                BigInteger bigInteger = (BigInteger)number;
                return bigInteger.subtract(BigInteger.ONE);
            }
        }
        throw new IllegalStateException();
    }

    public static Number integerDifference(Number number, Number number2) {
        Type type = Type.get(number.getClass());
        Type type2 = Type.get(number2.getClass());
        if (type == null || type2 == null) {
            String string = String.format("Unexpected number type %s,%s passed to integerDifference method.", number.getClass().getCanonicalName(), number2.getClass().getCanonicalName());
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        BigInteger bigInteger = OWLRealUtils.bigInteger(number);
        BigInteger bigInteger2 = OWLRealUtils.bigInteger(number2);
        return OWLRealUtils.shrinkBigInteger(bigInteger.subtract(bigInteger2));
    }

    public static Number integerIncrement(Number number) {
        Type type = Type.get(number.getClass());
        if (type == null) {
            String string = String.format("Unexpected number type %s passed to integerIncrement method.", number.getClass().getCanonicalName());
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        if (!type.isIntegerOnly()) {
            return OWLRealUtils.shrinkBigInteger(OWLRealUtils.bigInteger(number).add(BigInteger.ONE));
        }
        switch (type) {
            case BYTE: {
                byte by = number.byteValue();
                return by < 127 ? (short)Byte.valueOf((byte)(by + 1)).byteValue() : Short.valueOf((short)(by + 1));
            }
            case SHORT: {
                short s = number.shortValue();
                return s < Short.MAX_VALUE ? (int)Short.valueOf((short)(s + 1)).shortValue() : Integer.valueOf(s + 1);
            }
            case INTEGER: {
                int n = number.intValue();
                return n < Integer.MAX_VALUE ? (long)Integer.valueOf(n + 1).intValue() : Long.valueOf((long)n + 1L);
            }
            case LONG: {
                long l = number.longValue();
                return l < Long.MAX_VALUE ? Long.valueOf(l + 1L) : BigInteger.valueOf(l).add(BigInteger.ONE);
            }
            case BIG_INTEGER: {
                BigInteger bigInteger = (BigInteger)number;
                return bigInteger.add(BigInteger.ONE);
            }
        }
        throw new IllegalStateException();
    }

    public static Number integerSum(Number number, Number number2) {
        Type type = Type.get(number.getClass());
        Type type2 = Type.get(number2.getClass());
        if (type == null || type2 == null) {
            String string = String.format("Unexpected number type %s,%s passed to integerSum method.", number.getClass().getCanonicalName(), number2.getClass().getCanonicalName());
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        BigInteger bigInteger = OWLRealUtils.bigInteger(number);
        BigInteger bigInteger2 = OWLRealUtils.bigInteger(number2);
        return OWLRealUtils.shrinkBigInteger(bigInteger.add(bigInteger2));
    }

    public static boolean isDecimal(Number number) {
        Type type = Type.get(number.getClass());
        if (type == null) {
            String string = String.format("Unexpected number type %s passed to isInteger method.", number.getClass().getCanonicalName());
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        if (type.isIntegerOnly()) {
            return true;
        }
        if (type.equals((Object)Type.BIG_DECIMAL)) {
            return true;
        }
        if (type.equals((Object)Type.RATIONAL)) {
            Rational rational = (Rational)number;
            return rational.isQuotientExact();
        }
        throw new IllegalStateException();
    }

    public static boolean isInteger(Number number) {
        Type type = Type.get(number.getClass());
        if (type == null) {
            String string = String.format("Unexpected number type %s passed to isInteger method.", number.getClass().getCanonicalName());
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        if (type.isIntegerOnly()) {
            return true;
        }
        if (type.equals((Object)Type.BIG_DECIMAL)) {
            BigDecimal bigDecimal = (BigDecimal)number;
            return BigInteger.ZERO.equals(bigDecimal.unscaledValue()) || bigDecimal.stripTrailingZeros().scale() <= 0;
        }
        if (type.equals((Object)Type.RATIONAL)) {
            Rational rational = (Rational)number;
            if (OWLRealUtils.compare(1, rational.getDenominator()) == 0) {
                return true;
            }
            return OWLRealUtils.compare(1, Rational.simplify(rational).getDenominator()) == 0;
        }
        return false;
    }

    public static boolean isRational(Number number) {
        Type type = Type.get(number.getClass());
        if (type == null) {
            String string = String.format("Unexpected number type %s passed to isInteger method.", number.getClass().getCanonicalName());
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        if (type.isIntegerOnly()) {
            return true;
        }
        if (type.equals((Object)Type.BIG_DECIMAL)) {
            return true;
        }
        if (type.equals((Object)Type.RATIONAL)) {
            return true;
        }
        throw new IllegalStateException();
    }

    public static String print(Number number) {
        Type type = Type.get(number.getClass());
        if (type == null) {
            String string = String.format("Unexpected number type %s passed to print method.", number.getClass().getCanonicalName());
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        switch (type) {
            case BYTE: {
                return DatatypeConverter.printByte(number.byteValue());
            }
            case SHORT: {
                return DatatypeConverter.printShort(number.shortValue());
            }
            case INTEGER: {
                return DatatypeConverter.printInt(number.intValue());
            }
            case LONG: {
                return DatatypeConverter.printLong(number.longValue());
            }
            case BIG_INTEGER: {
                return DatatypeConverter.printInteger((BigInteger)number);
            }
            case BIG_DECIMAL: {
                return DatatypeConverter.printDecimal((BigDecimal)number);
            }
            case RATIONAL: {
                return ((Rational)number).toString();
            }
        }
        throw new IllegalStateException();
    }

    public static Number roundCeiling(Number number) {
        Type type = Type.get(number.getClass());
        if (type == null) {
            String string = String.format("Unexpected number type %s passed to roundDown method.", number.getClass().getCanonicalName());
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        if (type.isIntegerOnly()) {
            return number;
        }
        if (Type.BIG_DECIMAL.equals((Object)type)) {
            BigDecimal bigDecimal = (BigDecimal)number;
            BigDecimal[] bigDecimalArray = bigDecimal.divideAndRemainder(BigDecimal.ONE);
            if (bigDecimalArray[1].equals(BigDecimal.ZERO) || bigDecimal.signum() == -1) {
                return OWLRealUtils.shrinkBigInteger(bigDecimalArray[0].toBigIntegerExact());
            }
            return OWLRealUtils.shrinkBigInteger(bigDecimalArray[0].toBigIntegerExact().add(BigInteger.ONE));
        }
        if (Type.RATIONAL.equals((Object)type)) {
            Rational rational = (Rational)number;
            return OWLRealUtils.roundCeiling(rational.getQuotient());
        }
        throw new IllegalStateException();
    }

    public static Number roundDown(Number number) {
        Type type = Type.get(number.getClass());
        if (type == null) {
            String string = String.format("Unexpected number type %s passed to roundDown method.", number.getClass().getCanonicalName());
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        if (type.isIntegerOnly()) {
            return number;
        }
        if (Type.BIG_DECIMAL.equals((Object)type)) {
            BigDecimal bigDecimal = (BigDecimal)number;
            return OWLRealUtils.shrinkBigInteger(bigDecimal.divideToIntegralValue(BigDecimal.ONE).toBigIntegerExact());
        }
        if (Type.RATIONAL.equals((Object)type)) {
            Rational rational = (Rational)number;
            return OWLRealUtils.roundDown(rational.getQuotient());
        }
        throw new IllegalStateException();
    }

    public static Number roundFloor(Number number) {
        Type type = Type.get(number.getClass());
        if (type == null) {
            String string = String.format("Unexpected number type %s passed to roundDown method.", number.getClass().getCanonicalName());
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        if (type.isIntegerOnly()) {
            return number;
        }
        if (Type.BIG_DECIMAL.equals((Object)type)) {
            BigDecimal bigDecimal = (BigDecimal)number;
            BigDecimal[] bigDecimalArray = bigDecimal.divideAndRemainder(BigDecimal.ONE);
            if (bigDecimalArray[1].equals(BigDecimal.ZERO) || bigDecimal.signum() == 1) {
                return OWLRealUtils.shrinkBigInteger(bigDecimalArray[0].toBigIntegerExact());
            }
            return OWLRealUtils.shrinkBigInteger(bigDecimalArray[0].toBigIntegerExact().subtract(BigInteger.ONE));
        }
        if (Type.RATIONAL.equals((Object)type)) {
            Rational rational = (Rational)number;
            return OWLRealUtils.roundFloor(rational.getQuotient());
        }
        throw new IllegalStateException();
    }

    private static Number shrinkBigInteger(BigInteger bigInteger) {
        int n = bigInteger.signum();
        if (n == 0) {
            return (byte)0;
        }
        if (n < 0) {
            if (bigInteger.compareTo(BigInteger.valueOf(-128L)) > 0) {
                return bigInteger.byteValue();
            }
            if (bigInteger.compareTo(BigInteger.valueOf(-32768L)) > 0) {
                return bigInteger.shortValue();
            }
            if (bigInteger.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) > 0) {
                return bigInteger.intValue();
            }
            if (bigInteger.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) > 0) {
                return bigInteger.longValue();
            }
            return bigInteger;
        }
        if (bigInteger.compareTo(BigInteger.valueOf(127L)) < 0) {
            return bigInteger.byteValue();
        }
        if (bigInteger.compareTo(BigInteger.valueOf(32767L)) < 0) {
            return bigInteger.shortValue();
        }
        if (bigInteger.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) < 0) {
            return bigInteger.intValue();
        }
        if (bigInteger.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) < 0) {
            return bigInteger.longValue();
        }
        return bigInteger;
    }

    public static int signum(Number number) {
        Type type = Type.get(number.getClass());
        if (type == null) {
            String string = String.format("Unexpected number type %s passed to signum method.", number.getClass().getCanonicalName());
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        switch (type) {
            case BIG_DECIMAL: {
                return ((BigDecimal)number).signum();
            }
            case BIG_INTEGER: {
                return ((BigInteger)number).signum();
            }
            case RATIONAL: {
                return ((Rational)number).signum();
            }
            case LONG: {
                return Long.signum(number.longValue());
            }
            case BYTE: 
            case SHORT: 
            case INTEGER: {
                return Integer.signum(number.intValue());
            }
        }
        throw new IllegalArgumentException();
    }

    public static Number sum(Number number, Number number2) {
        if (OWLRealUtils.isInteger(number) && OWLRealUtils.isInteger(number2)) {
            return OWLRealUtils.integerSum(number, number2);
        }
        Type type = Type.get(number.getClass());
        Type type2 = Type.get(number2.getClass());
        if (type == null || type2 == null) {
            String string = String.format("Unexpected number type %s,%s passed to integerSum method.", number.getClass().getCanonicalName(), number2.getClass().getCanonicalName());
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        if (EnumSet.of(type, type2).contains((Object)Type.RATIONAL)) {
            String string = String.format("Addition for rational numbers is not supported", new Object[0]);
            log.warning(string);
            throw new IllegalArgumentException(string);
        }
        BigDecimal bigDecimal = (BigDecimal)OWLRealUtils.convertFromTo(number, type, Type.BIG_DECIMAL);
        BigDecimal bigDecimal2 = (BigDecimal)OWLRealUtils.convertFromTo(number2, type2, Type.BIG_DECIMAL);
        return OWLRealUtils.getCanonicalObject(bigDecimal.add(bigDecimal2));
    }

    private static enum Type {
        BIG_DECIMAL(5, BigDecimal.class, false),
        BIG_INTEGER(4, BigInteger.class, true),
        BYTE(0, Byte.class, true),
        INTEGER(2, Integer.class, true),
        LONG(3, Long.class, true),
        RATIONAL(6, Rational.class, false),
        SHORT(1, Short.class, true);

        private static Map<Class<?>, Type> map;
        private final Class<? extends Number> cls;
        private final int index;
        private final boolean integerOnly;

        public static Type compareType(Type type, Type type2) {
            return type.index > type2.index ? type : type2;
        }

        public static Type get(Class<? extends Number> clazz) {
            return map.get(clazz);
        }

        private Type(int n2, Class<? extends Number> clazz, boolean bl) {
            this.index = n2;
            this.cls = clazz;
            this.integerOnly = bl;
        }

        public boolean isIntegerOnly() {
            return this.integerOnly;
        }

        static {
            map = new HashMap();
            for (Type type : Type.values()) {
                map.put(type.cls, type);
            }
        }
    }
}

