/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;

public class OWL2ProfileReport
extends OWLProfileReport {
    private final Set<OWLObjectPropertyExpression> nonSimpleRoles;
    private final Set<OWLObjectPropertyExpression> simpleRoles;

    public OWL2ProfileReport(OWLProfile profile, Set<OWLProfileViolation> disallowedConstructs, Set<OWLObjectPropertyExpression> nonSimpleRoles, Set<OWLObjectPropertyExpression> simpleRoles) {
        super(profile, disallowedConstructs);
        this.nonSimpleRoles = new TreeSet<OWLObjectPropertyExpression>(nonSimpleRoles);
        this.simpleRoles = new TreeSet<OWLObjectPropertyExpression>(simpleRoles);
    }

    public Set<OWLObjectPropertyExpression> getNonSimpleRoles() {
        return this.nonSimpleRoles;
    }

    public Set<OWLObjectPropertyExpression> getSimpleRoles() {
        return this.simpleRoles;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\n[Simple properties]\n");
        for (OWLObjectPropertyExpression prop : this.simpleRoles) {
            sb.append("\t");
            sb.append(prop);
            sb.append("\n");
        }
        sb.append("\n[Non-simple properties]\n");
        for (OWLObjectPropertyExpression prop : this.nonSimpleRoles) {
            sb.append("\t");
            sb.append(prop);
            sb.append("\n");
        }
        return sb.toString();
    }
}

