/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.pellet.owlapiv3.LimitedMapIRIMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.utils.FileUtils;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.profiles.OWL2DLProfile;
import org.semanticweb.owlapi.profiles.OWL2ELProfile;
import org.semanticweb.owlapi.profiles.OWL2Profile;
import org.semanticweb.owlapi.profiles.OWL2QLProfile;
import org.semanticweb.owlapi.profiles.OWL2RLProfile;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.util.DLExpressivityChecker;
import org.semanticweb.owlapi.util.NonMappingOntologyIRIMapper;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public class PelletInfo
extends PelletCmdApp {
    private final List<OWLProfile> profiles = Arrays.asList(new OWL2ELProfile(), new OWL2QLProfile(), new OWL2RLProfile(), new OWL2DLProfile(), new OWL2Profile());

    @Override
    public String getAppCmd() {
        return "pellet info " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    @Override
    public String getAppId() {
        return "PelletInfo: Display information and statistics about 1 or more ontologies";
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions pelletCmdOptions = new PelletCmdOptions();
        PelletCmdOption pelletCmdOption = new PelletCmdOption("help");
        pelletCmdOption.setShortOption("h");
        pelletCmdOption.setDescription("Print this message");
        pelletCmdOption.setDefaultValue(false);
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.NONE);
        pelletCmdOptions.add(pelletCmdOption);
        PelletCmdOption pelletCmdOption2 = new PelletCmdOption("verbose");
        pelletCmdOption2.setShortOption("v");
        pelletCmdOption2.setDescription("More verbose output");
        pelletCmdOption2.setDefaultValue(false);
        pelletCmdOption2.setIsMandatory(false);
        pelletCmdOption2.setArg(PelletCmdOptionArg.NONE);
        pelletCmdOptions.add(pelletCmdOption2);
        PelletCmdOption pelletCmdOption3 = new PelletCmdOption("config");
        pelletCmdOption3.setShortOption("C");
        pelletCmdOption3.setDescription("Use the selected configuration file");
        pelletCmdOption3.setIsMandatory(false);
        pelletCmdOption3.setType("configuration file");
        pelletCmdOption3.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption3);
        PelletCmdOption pelletCmdOption4 = new PelletCmdOption("merge");
        pelletCmdOption4.setShortOption("m");
        pelletCmdOption4.setDescription("Merge the ontologies");
        pelletCmdOption4.setDefaultValue(false);
        pelletCmdOption4.setIsMandatory(false);
        pelletCmdOption4.setArg(PelletCmdOptionArg.NONE);
        pelletCmdOptions.add(pelletCmdOption4);
        pelletCmdOptions.add(this.getIgnoreImportsOption());
        return pelletCmdOptions;
    }

    @Override
    public void run() {
        try {
            OWLOntologyManager oWLOntologyManager = OWLManager.createOWLOntologyManager();
            Collection<String> collection = FileUtils.getFileURIs(this.getInputFiles());
            LimitedMapIRIMapper limitedMapIRIMapper = new LimitedMapIRIMapper();
            OWLOntology oWLOntology = oWLOntologyManager.createOntology();
            oWLOntologyManager.clearIRIMappers();
            if (this.options.getOption("ignore-imports").getValueAsBoolean()) {
                oWLOntologyManager.addIRIMapper((OWLOntologyIRIMapper)limitedMapIRIMapper);
                oWLOntologyManager.setSilentMissingImportsHandling(true);
            } else {
                oWLOntologyManager.addIRIMapper((OWLOntologyIRIMapper)new NonMappingOntologyIRIMapper());
                oWLOntologyManager.setSilentMissingImportsHandling(false);
            }
            if (collection.size() > 1) {
                for (String string : collection) {
                    this.addFile(string, oWLOntologyManager, limitedMapIRIMapper, oWLOntology);
                }
            } else {
                this.addSingleFile(collection.iterator().next(), oWLOntologyManager, limitedMapIRIMapper);
            }
            oWLOntologyManager.removeOntology(oWLOntology);
            if (this.options.getOption("merge").getValueAsBoolean()) {
                oWLOntologyManager = this.mergeOntologiesInNewManager(oWLOntologyManager);
            }
            this.printStats(oWLOntologyManager);
        }
        catch (Exception exception) {
            throw new PelletCmdException(exception);
        }
    }

    private void addFile(String string, OWLOntologyManager oWLOntologyManager, LimitedMapIRIMapper limitedMapIRIMapper, OWLOntology oWLOntology) {
        block2: {
            try {
                IRI iRI = IRI.create((String)string);
                limitedMapIRIMapper.addAllowedIRI(iRI);
                OWLImportsDeclaration oWLImportsDeclaration = oWLOntologyManager.getOWLDataFactory().getOWLImportsDeclaration(iRI);
                oWLOntologyManager.applyChange((OWLOntologyChange)new AddImport(oWLOntology, oWLImportsDeclaration));
                oWLOntologyManager.makeLoadImportRequest(oWLImportsDeclaration);
            }
            catch (Exception exception) {
                if (!this.verbose) break block2;
                System.err.println(exception.getLocalizedMessage());
            }
        }
    }

    private void addSingleFile(String string, OWLOntologyManager oWLOntologyManager, LimitedMapIRIMapper limitedMapIRIMapper) {
        block2: {
            try {
                IRI iRI = IRI.create((String)string);
                limitedMapIRIMapper.addAllowedIRI(iRI);
                oWLOntologyManager.loadOntologyFromOntologyDocument(iRI);
            }
            catch (Exception exception) {
                if (!this.verbose) break block2;
                System.err.println(exception.getLocalizedMessage());
            }
        }
    }

    private OWLOntologyManager mergeOntologiesInNewManager(OWLOntologyManager oWLOntologyManager) throws OWLOntologyCreationException {
        OWLOntologyManager oWLOntologyManager2 = OWLManager.createOWLOntologyManager();
        OWLOntology oWLOntology = oWLOntologyManager2.createOntology();
        ArrayList<AddAxiom> arrayList = new ArrayList<AddAxiom>();
        for (OWLOntology oWLOntology2 : oWLOntologyManager.getOntologies()) {
            for (OWLAxiom oWLAxiom : oWLOntology2.getAxioms()) {
                arrayList.add(new AddAxiom(oWLOntology, oWLAxiom));
            }
        }
        oWLOntologyManager2.applyChanges(arrayList);
        return oWLOntologyManager2;
    }

    private void printStats(OWLOntologyManager oWLOntologyManager) {
        for (OWLOntology oWLOntology : oWLOntologyManager.getOntologies()) {
            String string = oWLOntologyManager.getOntologyDocumentIRI(oWLOntology) != null ? oWLOntologyManager.getOntologyDocumentIRI(oWLOntology).toString() : "ontology";
            String string2 = oWLOntology.getOntologyID().getOntologyIRI() != null ? oWLOntology.getOntologyID().getOntologyIRI().toQuotedString() : "";
            this.output("Information about " + string + " (" + string2 + ")");
            if (this.verbose) {
                this.printOntologyHeader(oWLOntology);
            }
            DLExpressivityChecker dLExpressivityChecker = new DLExpressivityChecker(Collections.singleton(oWLOntology));
            this.output("OWL Profile = " + this.getProfile(oWLOntology));
            this.output("DL Expressivity = " + dLExpressivityChecker.getDescriptionLogicName());
            this.output("Axioms = " + oWLOntology.getAxiomCount());
            this.output("Logical Axioms = " + oWLOntology.getLogicalAxiomCount());
            this.output("GCI Axioms = " + oWLOntology.getGeneralClassAxioms().size());
            this.output("Individuals = " + oWLOntology.getIndividualsInSignature().size());
            this.output("Classes = " + oWLOntology.getClassesInSignature().size());
            this.output("Object Properties = " + oWLOntology.getObjectPropertiesInSignature().size());
            this.output("Data Properties = " + oWLOntology.getDataPropertiesInSignature().size());
            this.output("Annotation Properties = " + oWLOntology.getAnnotationPropertiesInSignature().size());
            Set set = oWLOntology.getImportsDeclarations();
            if (set.size() > 0) {
                this.output("Direct Imports:");
                int n = 1;
                for (OWLImportsDeclaration oWLImportsDeclaration : set) {
                    this.output(n + ": " + oWLImportsDeclaration.getIRI().toString());
                }
                ++n;
            }
            this.output("");
        }
    }

    private String getProfile(OWLOntology oWLOntology) {
        for (OWLProfile oWLProfile : this.profiles) {
            if (!oWLProfile.checkOntology(oWLOntology).isInProfile()) continue;
            return oWLProfile.getName();
        }
        return "Unknown Profile";
    }

    private void printOntologyHeader(OWLOntology oWLOntology) {
        for (OWLAnnotation oWLAnnotation : oWLOntology.getAnnotations()) {
            IRI iRI = oWLAnnotation.getProperty().getIRI();
            OWLAnnotationValue oWLAnnotationValue = oWLAnnotation.getValue();
            if (iRI.equals((Object)OWLRDFVocabulary.OWL_VERSION_INFO.getIRI())) {
                this.verbose("Version Info = " + this.getString(oWLAnnotationValue));
                continue;
            }
            if (iRI.equals((Object)OWLRDFVocabulary.OWL_PRIOR_VERSION.getIRI())) {
                this.verbose("Prior Version Info = " + this.getString(oWLAnnotationValue));
                continue;
            }
            if (iRI.equals((Object)OWLRDFVocabulary.OWL_BACKWARD_COMPATIBLE_WITH.getIRI())) {
                this.verbose("Backward Compatible With = " + this.getString(oWLAnnotationValue));
                continue;
            }
            if (!iRI.equals((Object)OWLRDFVocabulary.OWL_INCOMPATIBLE_WITH.getIRI())) continue;
            this.verbose("Incompatible With = " + this.getString(oWLAnnotationValue));
        }
    }

    private String getString(OWLAnnotationValue oWLAnnotationValue) {
        if (oWLAnnotationValue instanceof OWLLiteral) {
            return ((OWLLiteral)oWLAnnotationValue).getLiteral();
        }
        return oWLAnnotationValue.toString();
    }
}

