/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena.graph.converter;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.graph.converter.ConceptConverter;
import org.mindswap.pellet.jena.graph.converter.TripleAdder;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.jena.vocabulary.SWRL;
import org.mindswap.pellet.utils.ATermUtils;

public class AxiomConverter {
    private KnowledgeBase kb;
    private ConceptConverter converter;
    private Graph graph;

    public AxiomConverter(KnowledgeBase knowledgeBase, Graph graph) {
        this.kb = knowledgeBase;
        this.graph = graph;
        this.converter = new ConceptConverter(this.graph);
    }

    public void convert(ATermAppl aTermAppl) {
        if (aTermAppl.getAFun().equals(ATermUtils.EQCLASSFUN)) {
            this.convertBinary(aTermAppl, OWL.equivalentClass);
        } else if (aTermAppl.getAFun().equals(ATermUtils.SUBFUN)) {
            this.convertBinary(aTermAppl, RDFS.subClassOf);
        } else if (aTermAppl.getAFun().equals(ATermUtils.DISJOINTFUN)) {
            this.convertBinary(aTermAppl, OWL.disjointWith);
        } else if (aTermAppl.getAFun().equals(ATermUtils.DISJOINTSFUN)) {
            this.convertNary(aTermAppl, OWL2.AllDisjointClasses, OWL2.members);
        } else if (aTermAppl.getAFun().equals(ATermUtils.EQPROPFUN)) {
            this.convertBinary(aTermAppl, OWL.equivalentProperty);
        } else if (aTermAppl.getAFun().equals(ATermUtils.SUBPROPFUN)) {
            if (aTermAppl.getArgument(0) instanceof ATermList) {
                Node node = this.converter.convert(aTermAppl.getArgument(1));
                Node node2 = this.converter.convert(aTermAppl.getArgument(0));
                TripleAdder.add(this.graph, node, (Resource)OWL2.propertyChainAxiom, node2);
            } else {
                this.convertBinary(aTermAppl, RDFS.subPropertyOf);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.DISJOINTPROPFUN)) {
            this.convertBinary(aTermAppl, OWL2.propertyDisjointWith);
        } else if (aTermAppl.getAFun().equals(ATermUtils.DISJOINTPROPSFUN)) {
            this.convertNary(aTermAppl, OWL2.AllDisjointProperties, OWL2.members);
        } else if (aTermAppl.getAFun().equals(ATermUtils.DOMAINFUN)) {
            this.convertBinary(aTermAppl, RDFS.domain);
        } else if (aTermAppl.getAFun().equals(ATermUtils.RANGEFUN)) {
            this.convertBinary(aTermAppl, RDFS.range);
        } else if (aTermAppl.getAFun().equals(ATermUtils.INVPROPFUN)) {
            this.convertBinary(aTermAppl, OWL.inverseOf);
        } else if (aTermAppl.getAFun().equals(ATermUtils.TRANSITIVEFUN)) {
            this.convertUnary(aTermAppl, OWL.TransitiveProperty);
        } else if (aTermAppl.getAFun().equals(ATermUtils.FUNCTIONALFUN)) {
            this.convertUnary(aTermAppl, OWL.FunctionalProperty);
        } else if (aTermAppl.getAFun().equals(ATermUtils.INVFUNCTIONALFUN)) {
            this.convertUnary(aTermAppl, OWL.InverseFunctionalProperty);
        } else if (aTermAppl.getAFun().equals(ATermUtils.SYMMETRICFUN)) {
            this.convertUnary(aTermAppl, OWL.SymmetricProperty);
        } else if (aTermAppl.getAFun().equals(ATermUtils.ASYMMETRICFUN)) {
            this.convertUnary(aTermAppl, OWL2.AsymmetricProperty);
        } else if (aTermAppl.getAFun().equals(ATermUtils.REFLEXIVEFUN)) {
            this.convertUnary(aTermAppl, OWL2.ReflexiveProperty);
        } else if (aTermAppl.getAFun().equals(ATermUtils.IRREFLEXIVEFUN)) {
            this.convertUnary(aTermAppl, OWL2.IrreflexiveProperty);
        } else if (aTermAppl.getAFun().equals(ATermUtils.TYPEFUN)) {
            this.convertBinary(aTermAppl, RDF.type);
        } else if (aTermAppl.getAFun().equals(ATermUtils.SAMEASFUN)) {
            this.convertBinary(aTermAppl, OWL.sameAs);
        } else if (aTermAppl.getAFun().equals(ATermUtils.DIFFERENTFUN)) {
            this.convertBinary(aTermAppl, OWL.differentFrom);
        } else if (aTermAppl.getAFun().equals(ATermUtils.ALLDIFFERENTFUN)) {
            this.convertNary(aTermAppl, OWL.AllDifferent, OWL2.members);
        } else if (aTermAppl.getAFun().equals(ATermUtils.NOTFUN)) {
            aTermAppl = (ATermAppl)aTermAppl.getArgument(0);
            Node node = this.converter.convert(aTermAppl.getArgument(0));
            Node node3 = this.converter.convert(aTermAppl.getArgument(1));
            Node node4 = this.converter.convert(aTermAppl.getArgument(2));
            Node node5 = Node.createAnon();
            TripleAdder.add(this.graph, node5, (Resource)RDF.type, (RDFNode)OWL2.NegativePropertyAssertion);
            TripleAdder.add(this.graph, node5, (Resource)RDF.subject, node3);
            TripleAdder.add(this.graph, node5, (Resource)RDF.predicate, node);
            TripleAdder.add(this.graph, node5, (Resource)RDF.object, node4);
        } else if (aTermAppl.getAFun().equals(ATermUtils.PROPFUN)) {
            Node node = this.converter.convert(aTermAppl.getArgument(0));
            Node node6 = this.converter.convert(aTermAppl.getArgument(1));
            Node node7 = this.converter.convert(aTermAppl.getArgument(2));
            TripleAdder.add(this.graph, node6, node, node7);
        } else if (aTermAppl.getAFun().equals(ATermUtils.RULEFUN)) {
            Node node;
            Node node8;
            ATermList aTermList;
            Node node9 = null;
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            node9 = aTermAppl2 == ATermUtils.EMPTY ? Node.createAnon() : (ATermUtils.isBnode(aTermAppl2) ? Node.createAnon((AnonId)new AnonId(((ATermAppl)aTermAppl2.getArgument(0)).getName())) : Node.createURI((String)aTermAppl2.getName()));
            TripleAdder.add(this.graph, node9, (Resource)RDF.type, (RDFNode)SWRL.Imp);
            ATermList aTermList2 = (ATermList)aTermAppl.getArgument(1);
            if (aTermList2.isEmpty()) {
                TripleAdder.add(this.graph, node9, (Resource)SWRL.head, (RDFNode)RDF.nil);
            } else {
                aTermList = null;
                while (!aTermList2.isEmpty()) {
                    node8 = this.convertAtom((ATermAppl)aTermList2.getFirst());
                    node = Node.createAnon();
                    TripleAdder.add(this.graph, node, (Resource)RDF.type, (RDFNode)SWRL.AtomList);
                    TripleAdder.add(this.graph, node, (Resource)RDF.first, node8);
                    if (aTermList != null) {
                        TripleAdder.add(this.graph, (Node)aTermList, (Resource)RDF.rest, node);
                    } else {
                        TripleAdder.add(this.graph, node9, (Resource)SWRL.head, node);
                    }
                    aTermList = node;
                    aTermList2 = aTermList2.getNext();
                }
                TripleAdder.add(this.graph, aTermList, (Resource)RDF.rest, (RDFNode)RDF.nil);
            }
            aTermList = (ATermList)aTermAppl.getArgument(2);
            if (aTermList.isEmpty()) {
                TripleAdder.add(this.graph, node9, (Resource)SWRL.body, (RDFNode)RDF.nil);
            } else {
                node8 = null;
                while (!aTermList.isEmpty()) {
                    node = this.convertAtom((ATermAppl)aTermList.getFirst());
                    Node node10 = Node.createAnon();
                    TripleAdder.add(this.graph, node10, (Resource)RDF.type, (RDFNode)SWRL.AtomList);
                    TripleAdder.add(this.graph, node10, (Resource)RDF.first, node);
                    if (node8 != null) {
                        TripleAdder.add(this.graph, node8, (Resource)RDF.rest, node10);
                    } else {
                        TripleAdder.add(this.graph, node9, (Resource)SWRL.body, node10);
                    }
                    node8 = node10;
                    aTermList = aTermList.getNext();
                }
                TripleAdder.add(this.graph, node8, (Resource)RDF.rest, (RDFNode)RDF.nil);
            }
        }
    }

    private Node convertAtom(ATermAppl aTermAppl) {
        Node node = Node.createAnon();
        if (aTermAppl.getAFun().equals(ATermUtils.TYPEFUN)) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(1);
            Node node2 = this.convertAtomObject(aTermAppl2);
            Node node3 = this.converter.convert((ATerm)aTermAppl3);
            TripleAdder.add(this.graph, node, (Resource)RDF.type, (RDFNode)SWRL.ClassAtom);
            TripleAdder.add(this.graph, node, (Resource)SWRL.classPredicate, node3);
            TripleAdder.add(this.graph, node, (Resource)SWRL.argument1, node2);
        } else if (aTermAppl.getAFun().equals(ATermUtils.PROPFUN)) {
            ATermAppl aTermAppl4 = (ATermAppl)aTermAppl.getArgument(0);
            ATermAppl aTermAppl5 = (ATermAppl)aTermAppl.getArgument(1);
            ATermAppl aTermAppl6 = (ATermAppl)aTermAppl.getArgument(2);
            Node node4 = JenaUtils.makeGraphNode(aTermAppl4);
            Node node5 = this.convertAtomObject(aTermAppl5);
            Node node6 = this.convertAtomObject(aTermAppl6);
            if (this.kb.isObjectProperty((ATerm)aTermAppl4)) {
                TripleAdder.add(this.graph, node, (Resource)RDF.type, (RDFNode)SWRL.IndividualPropertyAtom);
            } else if (this.kb.isDatatypeProperty((ATerm)aTermAppl4)) {
                TripleAdder.add(this.graph, node, (Resource)RDF.type, (RDFNode)SWRL.DatavaluedPropertyAtom);
            } else {
                throw new UnsupportedOperationException("Unknown property: " + aTermAppl4);
            }
            TripleAdder.add(this.graph, node, (Resource)SWRL.propertyPredicate, node4);
            TripleAdder.add(this.graph, node, (Resource)SWRL.argument1, node5);
            TripleAdder.add(this.graph, node, (Resource)SWRL.argument2, node6);
        } else if (aTermAppl.getAFun().equals(ATermUtils.SAMEASFUN)) {
            ATermAppl aTermAppl7 = (ATermAppl)aTermAppl.getArgument(1);
            ATermAppl aTermAppl8 = (ATermAppl)aTermAppl.getArgument(2);
            Node node7 = this.convertAtomObject(aTermAppl7);
            Node node8 = this.convertAtomObject(aTermAppl8);
            TripleAdder.add(this.graph, node, (Resource)RDF.type, (RDFNode)SWRL.SameIndividualAtom);
            TripleAdder.add(this.graph, node, (Resource)SWRL.argument1, node7);
            TripleAdder.add(this.graph, node, (Resource)SWRL.argument2, node8);
        } else if (aTermAppl.getAFun().equals(ATermUtils.DIFFERENTFUN)) {
            ATermAppl aTermAppl9 = (ATermAppl)aTermAppl.getArgument(1);
            ATermAppl aTermAppl10 = (ATermAppl)aTermAppl.getArgument(2);
            Node node9 = this.convertAtomObject(aTermAppl9);
            Node node10 = this.convertAtomObject(aTermAppl10);
            TripleAdder.add(this.graph, node, (Resource)RDF.type, (RDFNode)SWRL.DifferentIndividualsAtom);
            TripleAdder.add(this.graph, node, (Resource)SWRL.argument1, node9);
            TripleAdder.add(this.graph, node, (Resource)SWRL.argument2, node10);
        } else if (aTermAppl.getAFun().equals(ATermUtils.BUILTINFUN)) {
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            ATermAppl aTermAppl11 = (ATermAppl)aTermList.getFirst();
            aTermList = aTermList.getNext();
            TripleAdder.add(this.graph, node, (Resource)RDF.type, (RDFNode)SWRL.BuiltinAtom);
            TripleAdder.add(this.graph, node, (Resource)SWRL.builtin, Node.createURI((String)aTermAppl11.toString()));
            if (aTermList.isEmpty()) {
                TripleAdder.add(this.graph, node, (Resource)SWRL.arguments, (RDFNode)RDF.nil);
            } else {
                Node node11 = null;
                while (!aTermList.isEmpty()) {
                    Node node12 = this.convertAtomObject((ATermAppl)aTermList.getFirst());
                    Node node13 = Node.createAnon();
                    TripleAdder.add(this.graph, node13, (Resource)RDF.first, node12);
                    if (node11 != null) {
                        TripleAdder.add(this.graph, node11, (Resource)RDF.rest, node13);
                    } else {
                        TripleAdder.add(this.graph, node, (Resource)SWRL.arguments, node13);
                    }
                    node11 = node13;
                    aTermList = aTermList.getNext();
                }
                TripleAdder.add(this.graph, node11, (Resource)RDF.rest, (RDFNode)RDF.nil);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported atom: " + node);
        }
        return node;
    }

    private Node convertAtomObject(ATermAppl aTermAppl) {
        Node node;
        if (ATermUtils.isVar(aTermAppl)) {
            node = JenaUtils.makeGraphNode((ATermAppl)aTermAppl.getArgument(0));
            TripleAdder.add(this.graph, node, (Resource)RDF.type, (RDFNode)SWRL.Variable);
        } else {
            node = JenaUtils.makeGraphNode(aTermAppl);
        }
        return node;
    }

    private void convertNary(ATermAppl aTermAppl, Resource resource, Property property) {
        Node node = Node.createAnon();
        TripleAdder.add(this.graph, node, (Resource)RDF.type, (RDFNode)resource);
        ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
        this.converter.visitList(aTermList);
        TripleAdder.add(this.graph, node, (Resource)property, this.converter.getResult());
    }

    private void convertBinary(ATermAppl aTermAppl, Property property) {
        Node node = this.converter.convert(aTermAppl.getArgument(0));
        Node node2 = this.converter.convert(aTermAppl.getArgument(1));
        TripleAdder.add(this.graph, node, (Resource)property, node2);
    }

    private void convertUnary(ATermAppl aTermAppl, Resource resource) {
        Node node = this.converter.convert(aTermAppl.getArgument(0));
        TripleAdder.add(this.graph, node, RDF.type.asNode(), resource.asNode());
    }
}

