/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.FSMBuilder;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.PropertyType;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.RoleTaxonomyBuilder;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.iterator.FilterIterator;
import org.mindswap.pellet.utils.iterator.IteratorUtils;
import org.mindswap.pellet.utils.iterator.MapIterator;

public class RBox {
    public static Logger log = Logger.getLogger(RBox.class.getName());
    private final Map<ATermAppl, Role> roles = new HashMap<ATermAppl, Role>();
    private final Set<Role> reflexiveRoles = new HashSet<Role>();
    private final Map<Role, Map<ATermAppl, Set<Set<ATermAppl>>>> domainAssertions = new HashMap<Role, Map<ATermAppl, Set<Set<ATermAppl>>>>();
    private final Map<Role, Map<ATermAppl, Set<Set<ATermAppl>>>> rangeAssertions = new HashMap<Role, Map<ATermAppl, Set<Set<ATermAppl>>>>();
    private Taxonomy<ATermAppl> objectTaxonomy;
    private Taxonomy<ATermAppl> dataTaxonomy;
    private Taxonomy<ATermAppl> annotationTaxonomy;
    private final FSMBuilder fsmBuilder = new FSMBuilder(this);

    public RBox() {
        this.addDatatypeRole(ATermUtils.TOP_DATA_PROPERTY);
        this.addDatatypeRole(ATermUtils.BOTTOM_DATA_PROPERTY);
        Role role = this.addObjectRole(ATermUtils.TOP_OBJECT_PROPERTY);
        Role role2 = this.addObjectRole(ATermUtils.BOTTOM_OBJECT_PROPERTY);
        role.setTransitive(true, DependencySet.INDEPENDENT);
        role.setReflexive(true, DependencySet.INDEPENDENT);
        role2.setIrreflexive(true, DependencySet.INDEPENDENT);
        role2.setAsymmetric(true, DependencySet.INDEPENDENT);
        this.addEquivalentRole((ATerm)role.getName(), (ATerm)role.getInverse().getName(), DependencySet.INDEPENDENT);
        this.addEquivalentRole((ATerm)role2.getName(), (ATerm)role2.getInverse().getName(), DependencySet.INDEPENDENT);
    }

    public Role getRole(ATerm aTerm) {
        return this.roles.get(aTerm);
    }

    public Role getDefinedRole(ATerm aTerm) {
        Role role = this.roles.get(aTerm);
        if (role == null) {
            throw new RuntimeException(aTerm + " is not defined as a property");
        }
        return role;
    }

    public Role addRole(ATermAppl aTermAppl) {
        Role role = this.getRole((ATerm)aTermAppl);
        if (role == null) {
            role = new Role(aTermAppl, PropertyType.UNTYPED);
            this.roles.put(aTermAppl, role);
        }
        return role;
    }

    public boolean addRange(ATerm aTerm, ATermAppl aTermAppl, Set<ATermAppl> set) {
        Set<Set<ATermAppl>> set2;
        Role role = this.getRole(aTerm);
        if (role == null) {
            throw new IllegalArgumentException(aTerm + " is not defined as a property");
        }
        Map<ATermAppl, Set<Set<ATermAppl>>> map = this.rangeAssertions.get(role);
        if (map == null) {
            map = new HashMap<ATermAppl, Set<Set<ATermAppl>>>();
            this.rangeAssertions.put(role, map);
        }
        if ((set2 = map.get(aTermAppl)) == null) {
            set2 = new HashSet<Set<ATermAppl>>();
            map.put(aTermAppl, set2);
        }
        return set2.add(set);
    }

    public boolean addRange(ATerm aTerm, ATermAppl aTermAppl) {
        Set<ATermAppl> set = Collections.singleton(ATermUtils.makeRange(aTerm, (ATerm)aTermAppl));
        return this.addRange(aTerm, aTermAppl, set);
    }

    public Role addObjectRole(ATermAppl aTermAppl) {
        Role role = this.getRole((ATerm)aTermAppl);
        PropertyType propertyType = role == null ? PropertyType.UNTYPED : role.getType();
        switch (propertyType) {
            case DATATYPE: {
                role = null;
                break;
            }
            case OBJECT: {
                break;
            }
            default: {
                if (role == null) {
                    role = new Role(aTermAppl, PropertyType.OBJECT);
                    this.roles.put(aTermAppl, role);
                } else {
                    role.setType(PropertyType.OBJECT);
                }
                ATermAppl aTermAppl2 = ATermUtils.makeInv(aTermAppl);
                Role role2 = new Role(aTermAppl2, PropertyType.OBJECT);
                this.roles.put(aTermAppl2, role2);
                role.setInverse(role2);
                role2.setInverse(role);
                this.addSubRole((ATerm)ATermUtils.BOTTOM_OBJECT_PROPERTY, (ATerm)role.getName(), DependencySet.INDEPENDENT);
                this.addSubRole((ATerm)role.getName(), (ATerm)ATermUtils.TOP_OBJECT_PROPERTY, DependencySet.INDEPENDENT);
                this.addSubRole((ATerm)ATermUtils.BOTTOM_OBJECT_PROPERTY, (ATerm)role.getName(), DependencySet.INDEPENDENT);
                this.addSubRole((ATerm)role.getName(), (ATerm)ATermUtils.TOP_OBJECT_PROPERTY, DependencySet.INDEPENDENT);
            }
        }
        return role;
    }

    public Role addDatatypeRole(ATermAppl aTermAppl) {
        Role role = this.getRole((ATerm)aTermAppl);
        if (role == null) {
            role = new Role(aTermAppl, PropertyType.DATATYPE);
            this.roles.put(aTermAppl, role);
            this.addSubRole((ATerm)ATermUtils.BOTTOM_DATA_PROPERTY, (ATerm)role.getName(), DependencySet.INDEPENDENT);
            this.addSubRole((ATerm)role.getName(), (ATerm)ATermUtils.TOP_DATA_PROPERTY, DependencySet.INDEPENDENT);
        } else {
            switch (role.getType()) {
                case DATATYPE: {
                    break;
                }
                case OBJECT: {
                    role = null;
                    break;
                }
                default: {
                    role.setType(PropertyType.DATATYPE);
                    this.addSubRole((ATerm)ATermUtils.BOTTOM_DATA_PROPERTY, (ATerm)role.getName(), DependencySet.INDEPENDENT);
                    this.addSubRole((ATerm)role.getName(), (ATerm)ATermUtils.TOP_DATA_PROPERTY, DependencySet.INDEPENDENT);
                }
            }
        }
        return role;
    }

    public Role addAnnotationRole(ATermAppl aTermAppl) {
        Role role = this.getRole((ATerm)aTermAppl);
        if (role == null) {
            role = new Role(aTermAppl, PropertyType.ANNOTATION);
            this.roles.put(aTermAppl, role);
        } else {
            switch (role.getType()) {
                case ANNOTATION: {
                    break;
                }
                case OBJECT: {
                    role = null;
                    break;
                }
                default: {
                    role.setType(PropertyType.ANNOTATION);
                }
            }
        }
        return role;
    }

    @Deprecated
    public Role addOntologyRole(ATermAppl aTermAppl) {
        return this.addAnnotationRole(aTermAppl);
    }

    public boolean addSubRole(ATerm aTerm, ATerm aTerm2) {
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSubProp(aTerm, aTerm2)) : DependencySet.INDEPENDENT;
        return this.addSubRole(aTerm, aTerm2, dependencySet);
    }

    public boolean addSubRole(ATerm aTerm, ATerm aTerm2, DependencySet dependencySet) {
        Role role = this.getRole(aTerm2);
        Role role2 = this.getRole(aTerm);
        if (role == null) {
            return false;
        }
        if (aTerm.getType() == 4) {
            role.addSubRoleChain((ATermList)aTerm, dependencySet);
        } else {
            if (role2 == null) {
                return false;
            }
            role.addSubRole(role2, dependencySet);
            role2.addSuperRole(role, dependencySet);
        }
        return true;
    }

    public boolean addEquivalentRole(ATerm aTerm, ATerm aTerm2) {
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeEqProp(aTerm, aTerm2)) : DependencySet.INDEPENDENT;
        return this.addEquivalentRole(aTerm2, aTerm, dependencySet);
    }

    public boolean addEquivalentRole(ATerm aTerm, ATerm aTerm2, DependencySet dependencySet) {
        Role role = this.getRole(aTerm);
        Role role2 = this.getRole(aTerm2);
        if (role == null || role2 == null) {
            return false;
        }
        role2.addSubRole(role, dependencySet);
        role2.addSuperRole(role, dependencySet);
        role.addSubRole(role2, dependencySet);
        role.addSuperRole(role2, dependencySet);
        if (role2.getInverse() != null) {
            role2.getInverse().addSubRole(role.getInverse(), dependencySet);
            role2.getInverse().addSuperRole(role.getInverse(), dependencySet);
            role.getInverse().addSubRole(role2.getInverse(), dependencySet);
            role.getInverse().addSuperRole(role2.getInverse(), dependencySet);
        }
        return true;
    }

    public boolean addDisjointRole(ATerm aTerm, ATerm aTerm2, DependencySet dependencySet) {
        Role role = this.getRole(aTerm);
        Role role2 = this.getRole(aTerm2);
        if (role == null || role2 == null) {
            return false;
        }
        role2.addDisjointRole(role, dependencySet);
        role.addDisjointRole(role2, dependencySet);
        return true;
    }

    public boolean addDomain(ATerm aTerm, ATermAppl aTermAppl, Set<ATermAppl> set) {
        Set<Set<ATermAppl>> set2;
        Role role = this.getRole(aTerm);
        if (role == null) {
            throw new IllegalArgumentException(aTerm + " is not defined as a property");
        }
        Map<ATermAppl, Set<Set<ATermAppl>>> map = this.domainAssertions.get(role);
        if (map == null) {
            map = new HashMap<ATermAppl, Set<Set<ATermAppl>>>();
            this.domainAssertions.put(role, map);
        }
        if ((set2 = map.get(aTermAppl)) == null) {
            set2 = new HashSet<Set<ATermAppl>>();
            map.put(aTermAppl, set2);
        }
        return set2.add(set);
    }

    public boolean addDomain(ATerm aTerm, ATermAppl aTermAppl) {
        Set<ATermAppl> set = Collections.singleton(ATermUtils.makeDomain(aTerm, (ATerm)aTermAppl));
        return this.addDomain(aTerm, aTermAppl, set);
    }

    public boolean addInverseRole(ATerm aTerm, ATerm aTerm2, DependencySet dependencySet) {
        Role role = this.getRole(aTerm);
        Role role2 = this.getRole(aTerm2);
        if (role == null || role2 == null || !role.isObjectRole() || !role2.isObjectRole()) {
            return false;
        }
        this.addEquivalentRole((ATerm)role.getInverse().getName(), aTerm2, dependencySet);
        return true;
    }

    public Iterator<ATermAppl> getAssertedDomains(Role role) {
        Map<ATermAppl, Set<Set<ATermAppl>>> map = this.domainAssertions.get(role);
        return map == null ? IteratorUtils.emptyIterator() : new ValueIterator(new DomainRangeIterator(map, role, true));
    }

    public Iterator<ATermAppl> getAssertedRanges(Role role) {
        Map<ATermAppl, Set<Set<ATermAppl>>> map = this.rangeAssertions.get(role);
        return map == null ? IteratorUtils.emptyIterator() : new ValueIterator(new DomainRangeIterator(map, role, false));
    }

    @Deprecated
    public boolean isDomainAsserted(ATerm aTerm, ATermAppl aTermAppl) {
        Role role = this.getRole(aTerm);
        if (role == null) {
            throw new IllegalArgumentException(aTerm + " is not defined as a property");
        }
        Map<ATermAppl, Set<Set<ATermAppl>>> map = this.domainAssertions.get(role);
        if (map == null) {
            return false;
        }
        Set<Set<ATermAppl>> set = map.get(aTermAppl);
        if (set == null) {
            return false;
        }
        Set<ATermAppl> set2 = Collections.singleton(ATermUtils.makeDomain(aTerm, (ATerm)aTermAppl));
        return set.contains(set2);
    }

    @Deprecated
    public boolean isRangeAsserted(ATerm aTerm, ATermAppl aTermAppl) {
        Role role = this.getRole(aTerm);
        if (role == null) {
            throw new IllegalArgumentException(aTerm + " is not defined as a property");
        }
        Map<ATermAppl, Set<Set<ATermAppl>>> map = this.rangeAssertions.get(role);
        if (map == null) {
            return false;
        }
        Set<Set<ATermAppl>> set = map.get(aTermAppl);
        if (set == null) {
            return false;
        }
        Set<ATermAppl> set2 = Collections.singleton(ATermUtils.makeRange(aTerm, (ATerm)aTermAppl));
        return set.contains(set2);
    }

    public boolean isRole(ATerm aTerm) {
        return this.roles.containsKey(aTerm);
    }

    /*
     * WARNING - void declaration
     */
    public void prepare() {
        Object object4;
        HashSet<Role> hashSet = new HashSet<Role>();
        block0: for (Role role : this.roles.values()) {
            object4 = new HashMap<ATerm, DependencySet>();
            HashSet<Role> object32 = new HashSet<Role>();
            HashSet<ATermList> hashSet2 = new HashSet<ATermList>();
            this.computeSubRoles(role, (Set<Role>)object32, (Set<ATermList>)hashSet2, (Map<ATerm, DependencySet>)object4, DependencySet.INDEPENDENT);
            role.setSubRolesAndChains(object32, hashSet2, (Map<ATerm, DependencySet>)object4);
            for (Role role2 : object32) {
                DependencySet dependencySet = role.getExplainSub((ATerm)role2.getName());
                role2.addSuperRole(role, dependencySet);
            }
            for (Role role2 : hashSet2) {
                if (role2.getLength() == 2 && role2.getFirst().equals((Object)role2.getLast()) && object32.contains(this.getRole(role2.getFirst()))) continue;
                role.setHasComplexSubRole(true);
                hashSet.add(role);
                continue block0;
            }
        }
        for (Role role : hashSet) {
            this.fsmBuilder.build(role);
        }
        for (Role role : this.roles.values()) {
            object4 = role.getInverse();
            if (object4 != null) {
                if (((Role)object4).isTransitive() && !role.isTransitive()) {
                    role.setTransitive(true, ((Role)object4).getExplainTransitive());
                } else if (role.isTransitive() && !((Role)object4).isTransitive()) {
                    ((Role)object4).setTransitive(true, role.getExplainTransitive());
                }
                if (((Role)object4).isFunctional() && !role.isInverseFunctional()) {
                    role.setInverseFunctional(true, ((Role)object4).getExplainFunctional());
                }
                if (role.isFunctional() && !((Role)object4).isInverseFunctional()) {
                    ((Role)object4).setInverseFunctional(true, role.getExplainFunctional());
                }
                if (((Role)object4).isInverseFunctional() && !role.isFunctional()) {
                    role.setFunctional(true, ((Role)object4).getExplainInverseFunctional());
                }
                if (((Role)object4).isAsymmetric() && !role.isAsymmetric()) {
                    role.setAsymmetric(true, ((Role)object4).getExplainAsymmetric());
                }
                if (role.isAsymmetric() && !((Role)object4).isAsymmetric()) {
                    ((Role)object4).setAsymmetric(true, role.getExplainAsymmetric());
                }
                if (((Role)object4).isReflexive() && !role.isReflexive()) {
                    role.setReflexive(true, ((Role)object4).getExplainReflexive());
                }
                if (role.isReflexive() && !((Role)object4).isReflexive()) {
                    ((Role)object4).setReflexive(true, role.getExplainReflexive());
                }
                for (Role role3 : role.getDisjointRoles()) {
                    ((Role)object4).addDisjointRole(role3.getInverse(), role.getExplainDisjointRole(role3));
                }
            }
            for (Role role4 : role.getSubRoles()) {
                if (role.isForceSimple()) {
                    role4.setForceSimple(true);
                }
                if (role4.isSimple()) continue;
                role.setSimple(false);
            }
        }
        for (Role role : this.roles.values()) {
            if (role.isForceSimple()) {
                if (!role.isSimple()) {
                    this.ignoreTransitivity(role);
                }
            } else {
                boolean bl = role.isTransitive();
                DependencySet dependencySet = role.getExplainTransitive();
                for (Role role5 : role.getSubRoles()) {
                    if (!role5.isTransitive()) continue;
                    if (role.isSubRoleOf(role5) && role != role5) {
                        bl = true;
                        DependencySet dependencySet2 = role.getExplainSub((ATerm)role5.getName()).union(role5.getExplainTransitive(), true);
                    }
                    role.addTransitiveSubRole(role5);
                }
                if (bl != role.isTransitive()) {
                    void var5_13;
                    role.setTransitive(bl, (DependencySet)var5_13);
                }
            }
            if (role.isFunctional()) {
                role.addFunctionalSuper(role);
            }
            for (Role role6 : role.getSuperRoles()) {
                DependencySet dependencySet;
                if (role6.equals(role)) continue;
                DependencySet dependencySet3 = dependencySet = PelletOptions.USE_TRACING ? role.getExplainSuper((ATerm)role6.getName()) : DependencySet.INDEPENDENT;
                if (role6.isFunctional()) {
                    DependencySet dependencySet4 = PelletOptions.USE_TRACING ? dependencySet.union(role6.getExplainFunctional(), true) : DependencySet.INDEPENDENT;
                    role.setFunctional(true, dependencySet4);
                    role.addFunctionalSuper(role6);
                }
                if (role6.isIrreflexive() && !role.isIrreflexive()) {
                    DependencySet dependencySet5 = PelletOptions.USE_TRACING ? dependencySet.union(role6.getExplainIrreflexive(), true) : DependencySet.INDEPENDENT;
                    role.setIrreflexive(true, dependencySet5);
                }
                if (role6.isAsymmetric() && !role.isAsymmetric()) {
                    DependencySet dependencySet6 = PelletOptions.USE_TRACING ? dependencySet.union(role6.getExplainAsymmetric(), true) : DependencySet.INDEPENDENT;
                    role.setAsymmetric(true, dependencySet6);
                }
                for (Role role7 : role6.getDisjointRoles().toArray(new Role[0])) {
                    DependencySet dependencySet7 = PelletOptions.USE_TRACING ? dependencySet.union(role6.getExplainDisjointRole(role7), true) : DependencySet.INDEPENDENT;
                    role.addDisjointRole(role7, dependencySet7);
                    role7.addDisjointRole(role, dependencySet7);
                }
            }
            if (role.isReflexive() && !role.isAnon()) {
                this.reflexiveRoles.add(role);
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine(role.debugString());
        }
        this.objectTaxonomy = null;
        this.dataTaxonomy = null;
        this.annotationTaxonomy = null;
    }

    public void propagateDomainRange() {
        for (Role role : this.roles.values()) {
            role.resetDomainRange();
        }
        for (Role role : this.roles.values()) {
            Map<ATermAppl, Set<Set<ATermAppl>>> map;
            Map<ATermAppl, Set<Set<ATermAppl>>> map2;
            Role role2 = role.getInverse();
            if (role2 != null) {
                map2 = this.domainAssertions.get(role2);
                map = this.rangeAssertions.get(role2);
                this.propogateDomain(role, map);
                this.propogateRange(role, map2);
            }
            map2 = this.domainAssertions.get(role);
            map = this.rangeAssertions.get(role);
            this.propogateDomain(role, map2);
            this.propogateRange(role, map);
        }
    }

    private void propogateDomain(Role role, Map<ATermAppl, Set<Set<ATermAppl>>> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<ATermAppl, Set<Set<ATermAppl>>> entry : map.entrySet()) {
            Set<ATermAppl> set = entry.getValue().iterator().next();
            ATermAppl aTermAppl = entry.getKey();
            ATermAppl aTermAppl2 = ATermUtils.normalize(aTermAppl);
            for (Role role2 : role.getSubRoles()) {
                DependencySet dependencySet = role.getExplainSub((ATerm)role2.getName());
                DependencySet dependencySet2 = dependencySet.union(set, true);
                role2.addDomain(aTermAppl2, dependencySet2);
            }
        }
    }

    private void propogateRange(Role role, Map<ATermAppl, Set<Set<ATermAppl>>> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<ATermAppl, Set<Set<ATermAppl>>> entry : map.entrySet()) {
            Set<ATermAppl> set = entry.getValue().iterator().next();
            ATermAppl aTermAppl = entry.getKey();
            ATermAppl aTermAppl2 = ATermUtils.normalize(aTermAppl);
            for (Role role2 : role.getSubRoles()) {
                DependencySet dependencySet = role.getExplainSub((ATerm)role2.getName());
                DependencySet dependencySet2 = dependencySet.union(set, true);
                role2.addRange(aTermAppl2, dependencySet2);
            }
        }
    }

    public boolean removeDomain(ATerm aTerm, ATermAppl aTermAppl) {
        if (!PelletOptions.USE_TRACING) {
            return false;
        }
        Role role = this.getRole(aTerm);
        if (role == null) {
            return false;
        }
        Map<ATermAppl, Set<Set<ATermAppl>>> map = this.domainAssertions.get(role);
        if (map == null) {
            return false;
        }
        Set<Set<ATermAppl>> set = map.get(aTermAppl);
        if (set == null) {
            return false;
        }
        Set<ATermAppl> set2 = Collections.singleton(ATermUtils.makeDomain(aTerm, (ATerm)aTermAppl));
        if (!set.remove(set2)) {
            return false;
        }
        if (set.isEmpty()) {
            map.remove(aTermAppl);
        }
        return true;
    }

    public boolean removeRange(ATerm aTerm, ATermAppl aTermAppl) {
        if (!PelletOptions.USE_TRACING) {
            return false;
        }
        Role role = this.getRole(aTerm);
        if (role == null) {
            return false;
        }
        Map<ATermAppl, Set<Set<ATermAppl>>> map = this.rangeAssertions.get(role);
        if (map == null) {
            return false;
        }
        Set<Set<ATermAppl>> set = map.get(aTermAppl);
        if (set == null) {
            return false;
        }
        Set<ATermAppl> set2 = Collections.singleton(ATermUtils.makeRange(aTerm, (ATerm)aTermAppl));
        if (!set.remove(set2)) {
            return false;
        }
        if (set.isEmpty()) {
            map.remove(aTermAppl);
        }
        return true;
    }

    void ignoreTransitivity(Role role) {
        Role role2 = role.isAnon() ? role.getInverse() : role;
        String string = "Unsupported axiom: Ignoring transitivity and/or complex subproperty axioms for " + role2;
        if (!PelletOptions.IGNORE_UNSUPPORTED_AXIOMS) {
            throw new UnsupportedFeatureException(string);
        }
        log.warning(string);
        role.removeSubRoleChains();
        role.setHasComplexSubRole(false);
        role.setSimple(true);
        role.setFSM(null);
        role.getInverse().removeSubRoleChains();
        role.getInverse().setHasComplexSubRole(false);
        role.getInverse().setSimple(true);
        role.getInverse().setFSM(null);
    }

    private void computeImmediateSubRoles(Role role, Map<ATerm, DependencySet> map) {
        Object object;
        Role role2 = role.getInverse();
        if (role2 != null && role2 != role) {
            DependencySet dependencySet;
            for (Role role3 : role2.getSubRoles()) {
                object = role3.getInverse();
                if (object == null) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Property " + role3 + " was supposed to be an ObjectProperty but it is not!");
                    continue;
                }
                if (object == role) continue;
                dependencySet = role2.getExplainSub((ATerm)role3.getName());
                map.put((ATerm)((Role)object).getName(), dependencySet);
            }
            for (ATermList aTermList : role2.getSubRoleChains()) {
                object = role2.getExplainSub((ATerm)aTermList);
                dependencySet = this.inverse(aTermList);
                map.put((ATerm)dependencySet, (DependencySet)object);
            }
        }
        for (Role role3 : role.getSubRoles()) {
            object = role.getExplainSub((ATerm)role3.getName());
            map.put((ATerm)role3.getName(), (DependencySet)object);
        }
        for (ATermList aTermList : role.getSubRoleChains()) {
            object = role.getExplainSub((ATerm)aTermList);
            map.put((ATerm)aTermList, (DependencySet)object);
        }
    }

    private void computeSubRoles(Role role, Set<Role> set, Set<ATermList> set2, Map<ATerm, DependencySet> map, DependencySet dependencySet) {
        if (set.contains(role)) {
            return;
        }
        set.add(role);
        map.put((ATerm)role.getName(), dependencySet);
        HashMap<ATerm, DependencySet> hashMap = new HashMap<ATerm, DependencySet>();
        this.computeImmediateSubRoles(role, hashMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            DependencySet dependencySet2;
            ATerm aTerm = (ATerm)entry.getKey();
            DependencySet dependencySet3 = dependencySet2 = PelletOptions.USE_TRACING ? dependencySet.union((DependencySet)entry.getValue(), true) : DependencySet.INDEPENDENT;
            if (aTerm instanceof ATermAppl) {
                Role role2 = this.getRole(aTerm);
                this.computeSubRoles(role2, set, set2, map, dependencySet2);
                continue;
            }
            set2.add((ATermList)aTerm);
            map.put(aTerm, dependencySet2);
        }
    }

    public String toString() {
        return "[RBox " + this.roles.values() + "]";
    }

    public ATermList inverse(ATermList aTermList) {
        ATermList aTermList2 = ATermUtils.EMPTY_LIST;
        ATermList aTermList3 = aTermList;
        while (!aTermList3.isEmpty()) {
            ATermAppl aTermAppl = (ATermAppl)aTermList3.getFirst();
            Role role = this.getRole((ATerm)aTermAppl);
            Role role2 = role.getInverse();
            if (role2 == null) {
                System.err.println("Property " + aTermAppl + " was supposed to be an ObjectProperty but it is not!");
            } else {
                aTermList2 = aTermList2.insert((ATerm)role2.getName());
            }
            aTermList3 = aTermList3.getNext();
        }
        return aTermList2;
    }

    public Set<ATermAppl> getRoleNames() {
        return this.roles.keySet();
    }

    public Set<Role> getReflexiveRoles() {
        return this.reflexiveRoles;
    }

    public Collection<Role> getRoles() {
        return this.roles.values();
    }

    public Taxonomy<ATermAppl> getObjectTaxonomy() {
        if (this.objectTaxonomy == null) {
            RoleTaxonomyBuilder roleTaxonomyBuilder = new RoleTaxonomyBuilder(this, PropertyType.OBJECT);
            this.objectTaxonomy = roleTaxonomyBuilder.classify();
        }
        return this.objectTaxonomy;
    }

    public Taxonomy<ATermAppl> getDataTaxonomy() {
        if (this.dataTaxonomy == null) {
            RoleTaxonomyBuilder roleTaxonomyBuilder = new RoleTaxonomyBuilder(this, PropertyType.DATATYPE);
            this.dataTaxonomy = roleTaxonomyBuilder.classify();
        }
        return this.dataTaxonomy;
    }

    public Taxonomy<ATermAppl> getAnnotationTaxonomy() {
        if (this.annotationTaxonomy == null) {
            RoleTaxonomyBuilder roleTaxonomyBuilder = new RoleTaxonomyBuilder(this, PropertyType.ANNOTATION);
            if (PelletOptions.USE_ANNOTATION_SUPPORT) {
                this.annotationTaxonomy = roleTaxonomyBuilder.classify();
            }
        }
        return this.annotationTaxonomy;
    }

    public boolean isObjectTaxonomyPrepared() {
        return this.objectTaxonomy != null;
    }

    public boolean isDataTaxonomyPrepared() {
        return this.dataTaxonomy != null;
    }

    public boolean isAnnotationTaxonomyPrepared() {
        return this.annotationTaxonomy != null;
    }

    private static class DomainRangeIterator
    extends FilterIterator<Map.Entry<ATermAppl, Set<Set<ATermAppl>>>> {
        final ATermAppl p;
        final boolean isDomain;

        public DomainRangeIterator(Map<ATermAppl, Set<Set<ATermAppl>>> map, Role role, boolean bl) {
            super(map.entrySet().iterator());
            this.p = role.getName();
            this.isDomain = bl;
        }

        @Override
        public boolean filter(Map.Entry<ATermAppl, Set<Set<ATermAppl>>> entry) {
            Set<Set<ATermAppl>> set = entry.getValue();
            Set<ATermAppl> set2 = Collections.singleton(this.isDomain ? ATermUtils.makeDomain((ATerm)this.p, (ATerm)entry.getKey()) : ATermUtils.makeRange((ATerm)this.p, (ATerm)entry.getKey()));
            return !set.contains(set2);
        }
    }

    private static class ValueIterator
    extends MapIterator<Map.Entry<ATermAppl, Set<Set<ATermAppl>>>, ATermAppl> {
        public ValueIterator(Iterator<Map.Entry<ATermAppl, Set<Set<ATermAppl>>>> iterator) {
            super(iterator);
        }

        @Override
        public ATermAppl map(Map.Entry<ATermAppl, Set<Set<ATermAppl>>> entry) {
            return entry.getKey();
        }
    }
}

