/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.BranchEffectTracker;
import com.clarkparsia.pellet.IncrementalChangeTracker;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.DatatypeReasonerImpl;
import com.clarkparsia.pellet.datatypes.exceptions.DatatypeReasonerException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.impl.SimpleBranchEffectTracker;
import com.clarkparsia.pellet.impl.SimpleIncrementalChangeTracker;
import com.clarkparsia.pellet.utils.MultiMapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.ABoxStats;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DefaultEdge;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.cache.CachedNode;
import org.mindswap.pellet.tableau.cache.CachedNodeFactory;
import org.mindswap.pellet.tableau.cache.ConceptCache;
import org.mindswap.pellet.tableau.cache.ConceptCacheLRU;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.SROIQIncStrategy;
import org.mindswap.pellet.tableau.completion.queue.BasicCompletionQueue;
import org.mindswap.pellet.tableau.completion.queue.CompletionQueue;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.OptimizedBasicCompletionQueue;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.CandidateSet;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.fsm.State;
import org.mindswap.pellet.utils.fsm.Transition;
import org.mindswap.pellet.utils.fsm.TransitionGraph;
import org.mindswap.pellet.utils.iterator.MultiListIterator;

public class ABox {
    public static final Logger log = Logger.getLogger(ABox.class.getName());
    private int anonCount = 0;
    public ABoxStats stats = new ABoxStats();
    protected final DatatypeReasoner dtReasoner;
    protected Map<ATermAppl, Node> nodes;
    protected List<ATermAppl> nodeList;
    private boolean changed = false;
    private boolean doExplanation;
    protected ConceptCache cache;
    private ABox lastCompletion;
    private boolean keepLastCompletion;
    private Clash lastClash;
    private boolean isComplete = false;
    private Clash clash;
    private Set<Clash> assertedClashes;
    private int branch;
    private List<Branch> branches;
    private List<NodeMerge> toBeMerged;
    private Map<ATermAppl, int[]> disjBranchStats;
    private ABox sourceABox;
    private boolean initialized = false;
    private KnowledgeBase kb;
    public boolean rulesNotApplied;
    public boolean ranRete = false;
    public boolean useRete = false;
    private BranchEffectTracker branchEffects;
    private CompletionQueue completionQueue;
    private IncrementalChangeTracker incChangeTracker;
    private boolean syntacticUpdate = false;

    public ABox(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
        this.nodes = new HashMap<ATermAppl, Node>();
        this.nodeList = new ArrayList<ATermAppl>();
        this.clash = null;
        this.assertedClashes = new HashSet<Clash>();
        this.doExplanation = false;
        this.dtReasoner = new DatatypeReasonerImpl();
        this.keepLastCompletion = false;
        this.setBranch(DependencySet.NO_BRANCH);
        this.branches = new ArrayList<Branch>();
        this.setDisjBranchStats(new HashMap<ATermAppl, int[]>());
        this.toBeMerged = new ArrayList<NodeMerge>();
        this.rulesNotApplied = true;
        this.branchEffects = PelletOptions.TRACK_BRANCH_EFFECTS ? new SimpleBranchEffectTracker() : null;
        this.completionQueue = PelletOptions.USE_COMPLETION_QUEUE ? (PelletOptions.USE_OPTIMIZED_BASIC_COMPLETION_QUEUE ? new OptimizedBasicCompletionQueue(this) : new BasicCompletionQueue(this)) : null;
        this.incChangeTracker = PelletOptions.USE_INCREMENTAL_CONSISTENCY ? new SimpleIncrementalChangeTracker() : null;
    }

    public ABox(KnowledgeBase knowledgeBase, ABox aBox, ATermAppl aTermAppl, boolean bl) {
        Object object;
        Object object2;
        this.kb = knowledgeBase;
        Timer timer = knowledgeBase.timers.startTimer("cloneABox");
        this.rulesNotApplied = true;
        this.initialized = aBox.initialized;
        this.setChanged(aBox.isChanged());
        this.setAnonCount(aBox.getAnonCount());
        this.cache = aBox.cache;
        this.clash = aBox.clash;
        this.dtReasoner = aBox.dtReasoner;
        this.doExplanation = aBox.doExplanation;
        this.setDisjBranchStats(aBox.getDisjBranchStats());
        int n = aTermAppl == null ? 0 : 1;
        int n2 = n + (bl ? aBox.nodes.size() : 0);
        this.nodes = new HashMap<ATermAppl, Node>(n2);
        this.nodeList = new ArrayList<ATermAppl>(n2);
        this.branchEffects = PelletOptions.TRACK_BRANCH_EFFECTS ? (bl ? aBox.branchEffects.copy() : new SimpleBranchEffectTracker()) : null;
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            if (bl) {
                this.completionQueue = aBox.completionQueue.copy();
                this.completionQueue.setABox(this);
            } else {
                this.completionQueue = PelletOptions.USE_OPTIMIZED_BASIC_COMPLETION_QUEUE ? new OptimizedBasicCompletionQueue(this) : new BasicCompletionQueue(this);
            }
        } else {
            this.completionQueue = null;
        }
        if (aTermAppl != null) {
            Iterator<Clash> iterator = new Individual(aTermAppl, this, null);
            ((Individual)((Object)iterator)).setNominalLevel(Integer.MAX_VALUE);
            ((Node)((Object)iterator)).setConceptRoot(true);
            ((Individual)((Object)iterator)).addType(ATermUtils.TOP, DependencySet.INDEPENDENT);
            this.nodes.put(aTermAppl, (Node)((Object)iterator));
            this.nodeList.add(aTermAppl);
            if (PelletOptions.COPY_ON_WRITE) {
                this.sourceABox = aBox;
            }
        }
        if (bl) {
            this.toBeMerged = aBox.getToBeMerged();
            if (this.sourceABox == null) {
                for (int i = 0; i < n2 - n; ++i) {
                    ATermAppl object3 = aBox.nodeList.get(i);
                    object2 = aBox.getNode((ATerm)object3);
                    object = ((Node)object2).copyTo(this);
                    this.nodes.put(object3, (Node)object);
                    this.nodeList.add(object3);
                }
                for (Node node : this.nodes.values()) {
                    node.updateNodeReferences();
                }
            }
        } else {
            this.toBeMerged = Collections.emptyList();
            this.sourceABox = null;
            this.initialized = false;
        }
        this.incChangeTracker = PelletOptions.USE_INCREMENTAL_CONSISTENCY ? (bl ? aBox.incChangeTracker.copy(this) : new SimpleIncrementalChangeTracker()) : null;
        this.assertedClashes = new HashSet<Clash>();
        for (Clash clash : aBox.assertedClashes) {
            this.assertedClashes.add(clash.copyTo(this));
        }
        if (aTermAppl == null || bl) {
            this.setBranch(aBox.branch);
            this.branches = new ArrayList<Branch>(aBox.branches.size());
            int n3 = aBox.branches.size();
            for (int i = 0; i < n3; ++i) {
                object2 = aBox.branches.get(i);
                if (this.sourceABox == null) {
                    object = ((Branch)object2).copyTo(this);
                    ((Branch)object).setNodeCount(((Branch)object2).getNodeCount() + n);
                } else {
                    object = object2;
                }
                this.branches.add((Branch)object);
            }
        } else {
            this.setBranch(DependencySet.NO_BRANCH);
            this.branches = new ArrayList<Branch>();
        }
        timer.stop();
    }

    public ABox copy() {
        return this.copy(this.kb);
    }

    public ABox copy(KnowledgeBase knowledgeBase) {
        return new ABox(knowledgeBase, this, null, true);
    }

    public ABox copy(ATermAppl aTermAppl, boolean bl) {
        return new ABox(this.kb, this, aTermAppl, bl);
    }

    public void copyOnWrite() {
        Object object;
        Object object2;
        if (this.sourceABox == null) {
            return;
        }
        Timer timer = this.kb.timers.startTimer("copyOnWrite");
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>(this.nodeList);
        int n = arrayList.size();
        int n2 = this.sourceABox.nodes.size();
        this.nodeList = new ArrayList<ATermAppl>(n2 + 1);
        this.nodeList.add((ATermAppl)arrayList.get(0));
        for (int i = 0; i < n2; ++i) {
            ATermAppl object3 = this.sourceABox.nodeList.get(i);
            object2 = this.sourceABox.getNode((ATerm)object3);
            object = ((Node)object2).copyTo(this);
            this.nodes.put(object3, (Node)object);
            this.nodeList.add(object3);
        }
        if (n > 1) {
            this.nodeList.addAll(arrayList.subList(1, n));
        }
        for (Node node : this.nodes.values()) {
            if (!this.sourceABox.nodes.containsKey(node.getName())) continue;
            node.updateNodeReferences();
        }
        int n3 = this.branches.size();
        for (int i = 0; i < n3; ++i) {
            object2 = this.branches.get(i);
            object = ((Branch)object2).copyTo(this);
            this.branches.set(i, (Branch)object);
            if (i >= this.sourceABox.getBranches().size()) {
                ((Branch)object).setNodeCount(((Branch)object).getNodeCount() + n2);
                continue;
            }
            ((Branch)object).setNodeCount(((Branch)object).getNodeCount() + 1);
        }
        timer.stop();
        this.sourceABox = null;
    }

    public void clearCaches(boolean bl) {
        this.lastCompletion = null;
        if (bl) {
            this.cache = new ConceptCacheLRU(this.kb);
        }
    }

    public Bool getCachedSat(ATermAppl aTermAppl) {
        return this.cache.getSat(aTermAppl);
    }

    public ConceptCache getCache() {
        return this.cache;
    }

    public CachedNode getCached(ATermAppl aTermAppl) {
        if (ATermUtils.isNominal(aTermAppl)) {
            return this.getIndividual(aTermAppl.getArgument(0)).getSame();
        }
        return (CachedNode)this.cache.get(aTermAppl);
    }

    private void cache(Individual individual, ATermAppl aTermAppl, boolean bl) {
        if (!bl) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Unsatisfiable: " + ATermUtils.toString(aTermAppl));
                log.fine("Equivalent to TOP: " + ATermUtils.toString(ATermUtils.negate(aTermAppl)));
            }
            this.cache.putSat(aTermAppl, false);
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cache " + individual.debugString());
            }
            this.cache.put(aTermAppl, CachedNodeFactory.createNode(aTermAppl, individual));
        }
    }

    public Bool isKnownSubClassOf(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Bool bool = Bool.UNKNOWN;
        CachedNode cachedNode = this.getCached(aTermAppl);
        if (cachedNode != null) {
            bool = this.isType(cachedNode, aTermAppl2);
        }
        return bool;
    }

    public boolean isSubClassOf(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Bool bool;
        if (!this.doExplanation && (bool = this.isKnownSubClassOf(aTermAppl, aTermAppl2)).isKnown()) {
            return bool.isTrue();
        }
        if (log.isLoggable(Level.FINE)) {
            long l = this.kb.timers.getTimer("subClassSat") == null ? 0L : this.kb.timers.getTimer("subClassSat").getCount();
            log.fine(l + ") Checking subclass [" + ATermUtils.toString(aTermAppl) + " " + ATermUtils.toString(aTermAppl2) + "]");
        }
        bool = ATermUtils.negate(aTermAppl2);
        ATermAppl aTermAppl3 = ATermUtils.makeAnd((ATerm)aTermAppl, (ATerm)bool);
        Timer timer = this.kb.timers.startTimer("subClassSat");
        boolean bl = !this.isSatisfiable(aTermAppl3, false);
        timer.stop();
        if (log.isLoggable(Level.FINE)) {
            log.fine(" Result: " + bl + " (" + timer.getLast() + "ms)");
        }
        return bl;
    }

    public boolean isSatisfiable(ATermAppl aTermAppl) {
        boolean bl = PelletOptions.USE_CACHING && (ATermUtils.isPrimitiveOrNegated(aTermAppl) || PelletOptions.USE_ADVANCED_CACHING);
        return this.isSatisfiable(aTermAppl, bl);
    }

    public boolean isSatisfiable(ATermAppl aTermAppl, boolean bl) {
        boolean bl2;
        Object object;
        if ((aTermAppl = ATermUtils.normalize(aTermAppl)).equals(ATermUtils.BOTTOM)) {
            this.lastClash = Clash.unexplained(null, DependencySet.INDEPENDENT, "Obvious contradiction in class expression: " + ATermUtils.toString(aTermAppl));
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Satisfiability for " + ATermUtils.toString(aTermAppl));
        }
        if (bl && (object = this.getCached(aTermAppl)) != null) {
            boolean bl3;
            bl2 = !object.isBottom();
            boolean bl4 = bl3 = bl && !object.isComplete();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cached sat for " + ATermUtils.toString(aTermAppl) + " is " + bl2);
            }
            if (!(bl3 || !bl2 && this.doExplanation)) {
                return bl2;
            }
        }
        ++this.stats.satisfiabilityCount;
        object = this.kb.timers.startTimer("satisfiability");
        bl2 = this.isConsistent(SetUtils.emptySet(), aTermAppl, bl);
        ((Timer)object).stop();
        return bl2;
    }

    public CandidateSet<ATermAppl> getObviousInstances(ATermAppl aTermAppl) {
        return this.getObviousInstances(aTermAppl, this.kb.getIndividuals());
    }

    public CandidateSet<ATermAppl> getObviousInstances(ATermAppl aTermAppl, Collection<ATermAppl> collection) {
        aTermAppl = ATermUtils.normalize(aTermAppl);
        Set<ATermAppl> set = this.kb.isClassified() && this.kb.getTaxonomy().contains(aTermAppl) ? this.kb.getTaxonomy().getFlattenedSubs(aTermAppl, false) : Collections.emptySet();
        set.remove(ATermUtils.BOTTOM);
        CandidateSet<ATermAppl> candidateSet = new CandidateSet<ATermAppl>();
        for (ATermAppl aTermAppl2 : collection) {
            Bool bool = this.isKnownType(aTermAppl2, aTermAppl, set);
            candidateSet.add(aTermAppl2, bool);
        }
        return candidateSet;
    }

    public void getObviousTypes(ATermAppl aTermAppl, List<ATermAppl> list, List<ATermAppl> list2) {
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Individual individual = this.getIndividual((ATerm)aTermAppl);
        individual = !individual.getMergeDependency(true).isIndependent() ? this.getIndividual((ATerm)aTermAppl) : individual.getSame();
        individual.getObviousTypes(list, list2);
    }

    public CandidateSet<ATermAppl> getObviousSubjects(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        CandidateSet<ATermAppl> candidateSet = new CandidateSet<ATermAppl>(this.kb.getIndividuals());
        this.getObviousSubjects(aTermAppl, aTermAppl2, candidateSet);
        return candidateSet;
    }

    public void getSubjects(ATermAppl aTermAppl, ATermAppl aTermAppl2, CandidateSet<ATermAppl> candidateSet) {
        Iterator<ATermAppl> iterator = candidateSet.iterator();
        while (iterator.hasNext()) {
            ATermAppl aTermAppl3 = iterator.next();
            Bool bool = this.hasObviousPropertyValue(aTermAppl3, aTermAppl, aTermAppl2);
            candidateSet.update(aTermAppl3, bool);
        }
    }

    public void getObviousSubjects(ATermAppl aTermAppl, ATermAppl aTermAppl2, CandidateSet<ATermAppl> candidateSet) {
        Iterator<ATermAppl> iterator = candidateSet.iterator();
        while (iterator.hasNext()) {
            ATermAppl aTermAppl3 = iterator.next();
            Bool bool = this.hasObviousPropertyValue(aTermAppl3, aTermAppl, aTermAppl2);
            if (bool.isFalse()) {
                iterator.remove();
                continue;
            }
            candidateSet.update(aTermAppl3, bool);
        }
    }

    public void getObviousObjects(ATermAppl aTermAppl, CandidateSet<ATermAppl> candidateSet) {
        aTermAppl = this.getRole((ATerm)aTermAppl).getInverse().getName();
        Iterator<ATermAppl> iterator = candidateSet.iterator();
        while (iterator.hasNext()) {
            ATermAppl aTermAppl2 = iterator.next();
            Bool bool = this.hasObviousObjectPropertyValue(aTermAppl2, aTermAppl, null);
            candidateSet.update(aTermAppl2, bool);
        }
    }

    public Bool isKnownType(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return this.isKnownType(aTermAppl, aTermAppl2, SetUtils.emptySet());
    }

    public Bool isKnownType(ATermAppl aTermAppl, ATermAppl aTermAppl2, Collection<ATermAppl> collection) {
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Individual individual = this.getIndividual((ATerm)aTermAppl);
        boolean bl = true;
        if (individual.isMerged()) {
            bl = individual.getMergeDependency(true).isIndependent();
            individual = individual.getSame();
        }
        Bool bool = this.isKnownType(individual, aTermAppl2, collection);
        if (bl) {
            return bool;
        }
        if (bool.isTrue()) {
            return Bool.UNKNOWN;
        }
        return bool;
    }

    public Bool isKnownType(Individual individual, ATermAppl aTermAppl, Collection<ATermAppl> collection) {
        Bool bool = this.isType(individual, aTermAppl);
        if (bool.isUnknown()) {
            Set<ATermAppl> set = ATermUtils.isAnd(aTermAppl) ? ATermUtils.listToSet((ATermList)aTermAppl.getArgument(0)) : SetUtils.singleton(aTermAppl);
            bool = Bool.TRUE;
            for (ATermAppl aTermAppl2 : set) {
                Bool bool2 = individual.hasObviousType(aTermAppl2);
                if (bool2.isUnknown() && individual.hasObviousType(collection)) {
                    bool2 = Bool.TRUE;
                }
                if (bool2.isKnown()) {
                    bool = bool.and(bool2);
                    continue;
                }
                bool = Bool.UNKNOWN;
                Collection<ATermAppl> collection2 = this.kb.getTBox().getAxioms(aTermAppl2);
                for (ATermAppl aTermAppl3 : collection2) {
                    ATermAppl aTermAppl4 = (ATermAppl)aTermAppl3.getArgument(1);
                    boolean bl = aTermAppl3.getAFun().equals(ATermUtils.EQCLASSFUN);
                    if (!bl) continue;
                    Iterator<ATermAppl> iterator = ATermUtils.isAnd(aTermAppl4) ? new MultiListIterator((ATermList)aTermAppl4.getArgument(0)) : Collections.singleton(aTermAppl4).iterator();
                    Bool bool3 = Bool.TRUE;
                    while (iterator.hasNext() && bool3.isTrue()) {
                        aTermAppl4 = iterator.next();
                        bool3 = this.isKnownType(individual, aTermAppl4, SetUtils.emptySet());
                    }
                    if (!bool3.isTrue()) continue;
                    bool = Bool.TRUE;
                    break;
                }
                if (!bool.isUnknown()) continue;
                return Bool.UNKNOWN;
            }
        }
        return bool;
    }

    private Bool isType(CachedNode cachedNode, ATermAppl aTermAppl) {
        CachedNode cachedNode2;
        CachedNode cachedNode3;
        Object object;
        Bool bool = Bool.UNKNOWN;
        boolean bl = this.kb.getTBox().isPrimitive(aTermAppl);
        if (bl && !cachedNode.isTop() && !cachedNode.isBottom() && cachedNode.isComplete()) {
            object = cachedNode.getDepends().get(aTermAppl);
            if (object == null) {
                return Bool.FALSE;
            }
            if (((DependencySet)object).isIndependent() && cachedNode.isIndependent()) {
                return Bool.TRUE;
            }
        }
        if ((cachedNode3 = this.getCached((ATermAppl)(object = ATermUtils.negate(aTermAppl)))) != null && cachedNode3.isComplete()) {
            bool = this.cache.isMergable(this.kb, cachedNode, cachedNode3).not();
        }
        if (PelletOptions.CHECK_NOMINAL_EDGES && bool.isUnknown() && (cachedNode2 = this.getCached(aTermAppl)) != null) {
            bool = this.cache.checkNominalEdges(this.kb, cachedNode, cachedNode2);
        }
        return bool;
    }

    public boolean isSameAs(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        ATermAppl aTermAppl3 = ATermUtils.makeValue((ATerm)aTermAppl2);
        return this.isType(aTermAppl, aTermAppl3);
    }

    public boolean isType(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Object object;
        Object object2;
        aTermAppl2 = ATermUtils.normalize(aTermAppl2);
        if (!this.doExplanation()) {
            if (this.kb.isClassified() && this.kb.getTaxonomy().contains(aTermAppl2)) {
                object2 = this.kb.getTaxonomy().getFlattenedSubs(aTermAppl2, false);
                object2.remove(ATermUtils.BOTTOM);
            } else {
                object2 = SetUtils.emptySet();
            }
            object = this.isKnownType(aTermAppl, aTermAppl2, (Collection<ATermAppl>)object2);
            if (((Bool)object).isKnown()) {
                return ((Bool)object).isTrue();
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Checking type " + ATermUtils.toString(aTermAppl2) + " for individual " + ATermUtils.toString(aTermAppl));
        }
        object2 = ATermUtils.negate(aTermAppl2);
        object = this.kb.timers.startTimer("isType");
        boolean bl = !this.isConsistent(SetUtils.singleton(aTermAppl), (ATermAppl)object2, false);
        ((Timer)object).stop();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Type " + bl + " " + ATermUtils.toString(aTermAppl2) + " for individual " + ATermUtils.toString(aTermAppl));
        }
        return bl;
    }

    public boolean isType(List<ATermAppl> list, ATermAppl aTermAppl) {
        ATermAppl aTermAppl2;
        boolean bl;
        aTermAppl = ATermUtils.normalize(aTermAppl);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Checking type " + ATermUtils.toString(aTermAppl) + " for individuals " + list.size());
        }
        boolean bl2 = bl = !this.isConsistent(list, aTermAppl2 = ATermUtils.negate(aTermAppl), false);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Type " + bl + " " + ATermUtils.toString(aTermAppl) + " for individuals " + list.size());
        }
        return bl;
    }

    public Bool hasObviousPropertyValue(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        Role role = this.getRole((ATerm)aTermAppl2);
        if (role.isDatatypeRole()) {
            try {
                Object object = aTermAppl3 == null ? null : this.dtReasoner.getValue(aTermAppl3);
                return this.hasObviousDataPropertyValue(aTermAppl, aTermAppl2, object);
            }
            catch (UnrecognizedDatatypeException unrecognizedDatatypeException) {
                log.warning(String.format("Returning false for property value check (%s,%s,%s) due to datatype problem with input literal: %s", aTermAppl, aTermAppl2, aTermAppl3, unrecognizedDatatypeException.getMessage()));
                return Bool.FALSE;
            }
            catch (InvalidLiteralException invalidLiteralException) {
                log.warning(String.format("Returning false for property value check (%s,%s,%s) due to problem with input literal: %s", aTermAppl, aTermAppl2, aTermAppl3, invalidLiteralException.getMessage()));
                return Bool.FALSE;
            }
        }
        return this.hasObviousObjectPropertyValue(aTermAppl, aTermAppl2, aTermAppl3);
    }

    public Bool hasObviousDataPropertyValue(ATermAppl aTermAppl, ATermAppl aTermAppl2, Object object) {
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Individual individual = this.getIndividual((ATerm)aTermAppl);
        Role role = this.getRole((ATerm)aTermAppl2);
        if (role.isTop()) {
            return Bool.TRUE;
        }
        if (role.isBottom()) {
            return Bool.FALSE;
        }
        boolean bl = false;
        if (!individual.getMergeDependency(true).isIndependent()) {
            bl = true;
            individual = this.getIndividual((ATerm)aTermAppl);
        } else {
            individual = individual.getSame();
        }
        Bool bool = individual.hasDataPropertyValue(role, object);
        if (bl && bool.isFalse()) {
            return Bool.UNKNOWN;
        }
        return bool;
    }

    public Bool hasObviousObjectPropertyValue(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        Role role = this.getRole((ATerm)aTermAppl2);
        if (role.isTop()) {
            return Bool.TRUE;
        }
        if (role.isBottom()) {
            return Bool.FALSE;
        }
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        HashSet<ATermAppl> hashSet2 = new HashSet<ATermAppl>();
        this.getObjectPropertyValues(aTermAppl, role, hashSet, hashSet2, true);
        if (aTermAppl3 == null) {
            if (!hashSet.isEmpty()) {
                return Bool.TRUE;
            }
            if (!hashSet2.isEmpty()) {
                return Bool.UNKNOWN;
            }
            return Bool.FALSE;
        }
        if (hashSet.contains(aTermAppl3)) {
            return Bool.TRUE;
        }
        if (hashSet2.contains(aTermAppl3)) {
            return Bool.UNKNOWN;
        }
        return Bool.FALSE;
    }

    public boolean hasPropertyValue(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        Bool bool = this.hasObviousPropertyValue(aTermAppl, aTermAppl2, aTermAppl3);
        if (bool.isKnown() && (bool.isFalse() || !this.doExplanation())) {
            return bool.isTrue();
        }
        ATermAppl aTermAppl4 = null;
        aTermAppl4 = aTermAppl3 == null ? (this.kb.isDatatypeProperty((ATerm)aTermAppl2) ? ATermUtils.makeMin((ATerm)aTermAppl2, 1, (ATerm)ATermUtils.TOP_LIT) : ATermUtils.makeMin((ATerm)aTermAppl2, 1, (ATerm)ATermUtils.TOP)) : ATermUtils.makeHasValue((ATerm)aTermAppl2, (ATerm)aTermAppl3);
        boolean bl = this.isType(aTermAppl, aTermAppl4);
        return bl;
    }

    public List<ATermAppl> getDataPropertyValues(ATermAppl aTermAppl, Role role, ATermAppl aTermAppl2) {
        return this.getDataPropertyValues(aTermAppl, role, aTermAppl2, false);
    }

    public List<ATermAppl> getDataPropertyValues(ATermAppl aTermAppl, Role role, ATermAppl aTermAppl2, boolean bl) {
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Individual individual = this.getIndividual((ATerm)aTermAppl);
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        boolean bl2 = true;
        if (individual.isMerged()) {
            bl2 = individual.getMergeDependency(true).isIndependent();
            individual = individual.getSame();
        }
        EdgeList edgeList = individual.getRSuccessorEdges(role);
        for (int i = 0; i < edgeList.size(); ++i) {
            ATermAppl aTermAppl3;
            Edge edge = edgeList.edgeAt(i);
            DependencySet dependencySet = edge.getDepends();
            Literal literal = (Literal)edge.getTo();
            ATermAppl aTermAppl4 = literal.getTerm();
            if (aTermAppl4 == null) continue;
            if (aTermAppl2 != null && !literal.hasType((ATerm)aTermAppl2)) {
                try {
                    if (!this.dtReasoner.isSatisfiable(Collections.singleton(aTermAppl2), literal.getValue())) {
                        continue;
                    }
                }
                catch (DatatypeReasonerException datatypeReasonerException) {
                    String string = String.format("Unexpected datatype reasoner exception while fetching property values (%s,%s,%s): %s", aTermAppl, role, aTermAppl2, datatypeReasonerException.getMessage());
                    log.severe(string);
                    throw new InternalReasonerException(string);
                }
            }
            if (bl2 && dependencySet.isIndependent()) {
                arrayList.add(aTermAppl4);
                continue;
            }
            if (bl || !this.isType(aTermAppl, aTermAppl3 = ATermUtils.makeHasValue((ATerm)role.getName(), (ATerm)aTermAppl4))) continue;
            arrayList.add(aTermAppl4);
        }
        return arrayList;
    }

    public List<ATermAppl> getObviousDataPropertyValues(ATermAppl aTermAppl, Role role, ATermAppl aTermAppl2) {
        return this.getDataPropertyValues(aTermAppl, role, aTermAppl2, true);
    }

    public void getObjectPropertyValues(ATermAppl aTermAppl, Role role, Set<ATermAppl> set, Set<ATermAppl> set2, boolean bl) {
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Individual individual = this.getIndividual((ATerm)aTermAppl);
        boolean bl2 = true;
        if (individual.isMerged()) {
            bl2 = individual.getMergeDependency(true).isIndependent();
            individual = individual.getSame();
        }
        if (role.isSimple()) {
            this.getSimpleObjectPropertyValues(individual, role, set, set2, bl);
        } else if (!role.hasComplexSubRole()) {
            this.getTransitivePropertyValues(individual, role, set, set2, bl, new HashMap<Individual, Set<Role>>(), true);
        } else {
            TransitionGraph<Role> transitionGraph = role.getFSM();
            this.getComplexObjectPropertyValues(individual, transitionGraph.getInitialState(), transitionGraph, set, set2, bl, new HashMap<Individual, Set<State<Role>>>(), true);
        }
        if (!bl2) {
            set2.addAll(set);
            set.clear();
        }
    }

    void getSimpleObjectPropertyValues(Individual individual, Role role, Set<ATermAppl> set, Set<ATermAppl> set2, boolean bl) {
        EdgeList edgeList = individual.getRNeighborEdges(role);
        for (int i = 0; i < edgeList.size(); ++i) {
            Edge edge = edgeList.edgeAt(i);
            DependencySet dependencySet = edge.getDepends();
            Individual individual2 = (Individual)edge.getNeighbor(individual);
            if (!individual2.isRootNominal()) continue;
            if (dependencySet.isIndependent()) {
                if (bl) {
                    this.getSames(individual2, set, set2);
                    continue;
                }
                set.add(individual2.getName());
                continue;
            }
            if (bl) {
                this.getSames(individual2, set2, set2);
                continue;
            }
            set2.add(individual2.getName());
        }
    }

    void getTransitivePropertyValues(Individual individual, Role role, Set<ATermAppl> set, Set<ATermAppl> set2, boolean bl, Map<Individual, Set<Role>> map, boolean bl2) {
        if (!MultiMapUtils.addAll(map, individual, role.getSubRoles())) {
            return;
        }
        EdgeList edgeList = individual.getRNeighborEdges(role);
        for (int i = 0; i < edgeList.size(); ++i) {
            Role role2;
            Edge edge = edgeList.edgeAt(i);
            DependencySet dependencySet = edge.getDepends();
            Individual individual2 = (Individual)edge.getNeighbor(individual);
            Role role3 = role2 = edge.getFrom().equals(individual) ? edge.getRole() : edge.getRole().getInverse();
            if (individual2.isRootNominal()) {
                if (bl2 && dependencySet.isIndependent()) {
                    if (bl) {
                        this.getSames(individual2, set, set2);
                    } else {
                        set.add(individual2.getName());
                    }
                } else if (bl) {
                    this.getSames(individual2, set2, set2);
                } else {
                    set2.add(individual2.getName());
                }
            }
            if (role.isSimple()) continue;
            Set<Role> set3 = SetUtils.intersection(role2.getSuperRoles(), role.getTransitiveSubRoles());
            for (Role role4 : set3) {
                this.getTransitivePropertyValues(individual2, role4, set, set2, bl, map, bl2 && dependencySet.isIndependent());
            }
        }
    }

    void getComplexObjectPropertyValues(Individual individual, State<Role> state, TransitionGraph<Role> transitionGraph, Set<ATermAppl> set, Set<ATermAppl> set2, boolean bl, HashMap<Individual, Set<State<Role>>> hashMap, boolean bl2) {
        if (!MultiMapUtils.add(hashMap, individual, state)) {
            return;
        }
        if (transitionGraph.isFinal(state) && individual.isRootNominal()) {
            log.fine("add " + individual);
            if (bl2) {
                if (bl) {
                    this.getSames(individual, set, set2);
                } else {
                    set.add(individual.getName());
                }
            } else if (bl) {
                this.getSames(individual, set2, set2);
            } else {
                set2.add(individual.getName());
            }
        }
        log.fine(individual.toString());
        for (Transition<Role> transition : state.getTransitions()) {
            Role role = transition.getName();
            EdgeList edgeList = individual.getRNeighborEdges(role);
            for (int i = 0; i < edgeList.size(); ++i) {
                Edge edge = edgeList.edgeAt(i);
                DependencySet dependencySet = edge.getDepends();
                Individual individual2 = (Individual)edge.getNeighbor(individual);
                this.getComplexObjectPropertyValues(individual2, transition.getTo(), transitionGraph, set, set2, bl, hashMap, bl2 && dependencySet.isIndependent());
            }
        }
    }

    public void getSames(Individual individual, Set<ATermAppl> set, Set<ATermAppl> set2) {
        set.add(individual.getName());
        boolean bl = individual.isMerged() && !individual.getMergeDependency(true).isIndependent();
        for (Node node : individual.getMerged()) {
            boolean bl2;
            if (!node.isRootNominal()) continue;
            boolean bl3 = bl2 = node.isMerged() && !node.getMergeDependency(true).isIndependent();
            if (bl || bl2) {
                set2.add(node.getName());
                this.getSames((Individual)node, set2, set2);
                continue;
            }
            set.add(node.getName());
            this.getSames((Individual)node, set, set2);
        }
    }

    public boolean isConsistent() {
        boolean bl = false;
        this.checkAssertedClashes();
        bl = this.isConsistent(SetUtils.emptySet(), null, false);
        if (bl) {
            this.cache.putSat(ATermUtils.BOTTOM, false);
            assert (this.isComplete()) : "ABox not marked complete!";
        }
        return bl;
    }

    private boolean checkAssertedClashes() {
        Iterator<Clash> iterator = this.assertedClashes.iterator();
        while (iterator.hasNext()) {
            Clash clash = iterator.next();
            Node node = clash.getNode();
            ATermAppl aTermAppl = clash.args != null ? (ATermAppl)clash.args[0] : null;
            boolean bl = true;
            switch (clash.getClashType()) {
                case ATOMIC: {
                    ATermAppl aTermAppl2 = ATermUtils.negate(aTermAppl);
                    bl = !node.hasType((ATerm)aTermAppl) || !node.hasType((ATerm)aTermAppl2);
                    break;
                }
                case NOMINAL: {
                    bl = !node.isSame(this.getNode((ATerm)aTermAppl));
                    break;
                }
                case INVALID_LITERAL: {
                    bl = false;
                    break;
                }
                default: {
                    log.warning("Unexpected asserted clash type: " + clash);
                }
            }
            if (bl) {
                iterator.remove();
                continue;
            }
            this.setClash(clash);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConsistent(Collection<ATermAppl> collection, ATermAppl aTermAppl, boolean bl) {
        boolean bl2;
        int n;
        Object object2;
        Timer timer = this.kb.timers.startTimer("isConsistent");
        if (log.isLoggable(Level.FINE)) {
            if (aTermAppl == null) {
                log.fine("ABox consistency for " + collection.size() + " individuals");
            } else {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("[");
                Iterator<ATermAppl> iterator = collection.iterator();
                for (n = 0; n < 100 && iterator.hasNext(); ++n) {
                    if (n > 0) {
                        ((StringBuilder)object2).append(", ");
                    }
                    ((StringBuilder)object2).append(ATermUtils.toString(iterator.next()));
                }
                if (iterator.hasNext()) {
                    ((StringBuilder)object2).append(", ...");
                }
                ((StringBuilder)object2).append("]");
                log.fine("Consistency " + ATermUtils.toString(aTermAppl) + " for " + collection.size() + " individuals " + object2);
            }
        }
        object2 = this.kb.getExpressivityChecker().getExpressivityWith(aTermAppl);
        boolean bl3 = aTermAppl == null;
        n = bl3 && this.isEmpty() ? 1 : 0;
        boolean bl4 = collection.isEmpty() && (!bl3 || n != 0);
        boolean bl5 = ((Expressivity)object2).hasNominal() && !PelletOptions.USE_PSEUDO_NOMINALS;
        boolean bl6 = bl4 && !bl5;
        ATermAppl aTermAppl2 = null;
        if (bl4) {
            aTermAppl2 = ATermUtils.CONCEPT_SAT_IND;
            collection = SetUtils.singleton(aTermAppl2);
        }
        if (n != 0) {
            aTermAppl = ATermUtils.TOP;
        }
        ABox aBox = bl6 ? this.copy(aTermAppl2, false) : (bl3 ? this : this.copy(aTermAppl2, true));
        for (ATermAppl object3 : collection) {
            aBox.setSyntacticUpdate(true);
            aBox.addType(object3, aTermAppl);
            aBox.setSyntacticUpdate(false);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Consistency check starts");
        }
        CompletionStrategy completionStrategy = this.kb.chooseStrategy(aBox, (Expressivity)object2);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Strategy: " + completionStrategy.getClass().getName());
        }
        Timer timer2 = this.kb.timers.getTimer("complete");
        timer2.start();
        try {
            completionStrategy.complete((Expressivity)object2);
        }
        finally {
            timer2.stop();
        }
        boolean bl7 = bl2 = !aBox.isClosed();
        if (aTermAppl2 != null && aTermAppl != null && bl) {
            this.cache(aBox.getIndividual((ATerm)aTermAppl2), aTermAppl, bl2);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Consistent: " + bl2 + " Time: " + timer.getElapsed() + " Branches " + aBox.branches.size() + " Tree depth: " + aBox.stats.treeDepth + " Tree size: " + aBox.getNodes().size() + " Restores " + aBox.stats.globalRestores + " global " + aBox.stats.localRestores + " local" + " Backtracks " + aBox.stats.backtracks + " avg backjump " + (double)aBox.stats.backjumps / (double)aBox.stats.backtracks);
        }
        if (bl2) {
            if (bl3 && this.isEmpty()) {
                this.setComplete(true);
            }
        } else {
            this.lastClash = aBox.getClash();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Clash: " + aBox.getClash().detailedString());
            }
            if (this.doExplanation && PelletOptions.USE_TRACING) {
                Object object;
                if (collection.size() == 1) {
                    object = collection.iterator().next();
                    ATermAppl aTermAppl3 = ATermUtils.makeTypeAtom((ATermAppl)object, aTermAppl);
                    ATermAppl aTermAppl4 = this.getExplanationSet();
                    boolean bl8 = aTermAppl4.remove(aTermAppl3);
                    if (!bl8 && log.isLoggable(Level.FINE)) {
                        log.fine("Explanation set is missing an axiom.\n\tAxiom: " + aTermAppl3 + "\n\tExplantionSet: " + aTermAppl4);
                    }
                }
                if (log.isLoggable(Level.FINE)) {
                    object = new StringBuilder();
                    for (ATermAppl aTermAppl4 : this.getExplanationSet()) {
                        ((StringBuilder)object).append("\n\t");
                        ((StringBuilder)object).append(ATermUtils.toString(aTermAppl4));
                    }
                    log.fine("Explanation: " + object);
                }
            }
        }
        ++this.stats.consistencyCount;
        this.lastCompletion = this.keepLastCompletion ? aBox : null;
        timer.stop();
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isIncConsistent() {
        boolean bl;
        assert (this.isComplete()) : "Initial consistency check has not been performed!";
        Timer timer = this.kb.timers.startTimer("isIncConsistent");
        Timer timer2 = this.kb.timers.startTimer("isConsistent");
        this.lastCompletion = null;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Consistency check starts");
        }
        SROIQIncStrategy sROIQIncStrategy = new SROIQIncStrategy(this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Strategy: " + sROIQIncStrategy.getClass().getName());
        }
        this.setComplete(false);
        Timer timer3 = this.kb.timers.getTimer("complete");
        timer3.start();
        try {
            ((CompletionStrategy)sROIQIncStrategy).complete(this.kb.getExpressivityChecker().getExpressivity());
        }
        finally {
            timer3.stop();
        }
        boolean bl2 = bl = !this.isClosed();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Consistent: " + bl + " Tree depth: " + this.stats.treeDepth + " Tree size: " + this.getNodes().size());
        }
        if (!bl) {
            this.lastClash = this.getClash();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getClash().detailedString());
            }
        }
        ++this.stats.consistencyCount;
        this.lastCompletion = this;
        timer2.stop();
        timer.stop();
        return bl;
    }

    public EdgeList getInEdges(ATerm aTerm) {
        return this.getNode(aTerm).getInEdges();
    }

    public EdgeList getOutEdges(ATerm aTerm) {
        Node node = this.getNode(aTerm);
        if (node instanceof Literal) {
            return new EdgeList();
        }
        return ((Individual)node).getOutEdges();
    }

    public Individual getIndividual(ATerm aTerm) {
        Node node = this.nodes.get(aTerm);
        if (node instanceof Individual) {
            return (Individual)node;
        }
        return null;
    }

    public Literal getLiteral(ATerm aTerm) {
        Node node = this.nodes.get(aTerm);
        if (node instanceof Literal) {
            return (Literal)node;
        }
        return null;
    }

    public Node getNode(ATerm aTerm) {
        return this.nodes.get(aTerm);
    }

    public void addType(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeTypeAtom(aTermAppl, aTermAppl2)) : DependencySet.INDEPENDENT;
        this.addType(aTermAppl, aTermAppl2, dependencySet);
    }

    public void addType(ATermAppl aTermAppl, ATermAppl aTermAppl2, DependencySet dependencySet) {
        aTermAppl2 = ATermUtils.normalize(aTermAppl2);
        int n = this.branch;
        this.setBranch(DependencySet.NO_BRANCH);
        Individual individual = this.getIndividual((ATerm)aTermAppl);
        individual.addType(aTermAppl2, dependencySet, false);
        while (individual.isMerged()) {
            dependencySet = dependencySet.union(individual.getMergeDependency(false), this.doExplanation);
            individual.addType(aTermAppl2, dependencySet, !(individual = (Individual)individual.getMergedTo()).isMerged());
        }
        this.setBranch(n);
    }

    public Edge addEdge(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3, DependencySet dependencySet) {
        Role role = this.getRole((ATerm)aTermAppl);
        Individual individual = this.getIndividual((ATerm)aTermAppl2);
        Node node = this.getNode((ATerm)aTermAppl3);
        if (individual.isMerged() && node.isMerged()) {
            return null;
        }
        if (node.isMerged()) {
            node.addInEdge(new DefaultEdge(role, individual, node, dependencySet));
            dependencySet = dependencySet.union(node.getMergeDependency(true), true);
            dependencySet = dependencySet.copy(dependencySet.max() + 1);
            node = node.getSame();
        }
        DefaultEdge defaultEdge = new DefaultEdge(role, individual, node, dependencySet);
        Edge edge = individual.getOutEdges().getExactEdge(individual, role, node);
        if (edge == null) {
            individual.addOutEdge(defaultEdge);
        } else if (!edge.getDepends().isIndependent()) {
            individual.removeEdge(edge);
            individual.addOutEdge(defaultEdge);
        }
        if (individual.isMerged()) {
            dependencySet = dependencySet.union(individual.getMergeDependency(true), true);
            dependencySet = dependencySet.copy(dependencySet.max() + 1);
            individual = individual.getSame();
            defaultEdge = new DefaultEdge(role, individual, node, dependencySet);
            if (individual.getOutEdges().hasEdge(defaultEdge)) {
                return null;
            }
            individual.addOutEdge(defaultEdge);
            node.addInEdge(defaultEdge);
        } else if (edge == null) {
            node.addInEdge(defaultEdge);
        } else if (!edge.getDepends().isIndependent()) {
            node.removeInEdge(edge);
            node.addInEdge(defaultEdge);
        }
        return defaultEdge;
    }

    public boolean removeNode(ATermAppl aTermAppl) {
        return this.nodes.remove(aTermAppl) != null;
    }

    public void removeType(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        aTermAppl2 = ATermUtils.normalize(aTermAppl2);
        Node node = this.getNode((ATerm)aTermAppl);
        node.removeType(aTermAppl2);
    }

    public Literal addLiteral(DependencySet dependencySet) {
        return this.createLiteral(ATermUtils.makeLiteral(this.createUniqueName(false)), dependencySet);
    }

    public Literal addLiteral(ATermAppl aTermAppl) {
        int n = this.getBranch();
        this.setBranch(DependencySet.NO_BRANCH);
        Literal literal = this.addLiteral(aTermAppl, DependencySet.INDEPENDENT);
        this.setBranch(n);
        return literal;
    }

    public Literal addLiteral(ATermAppl aTermAppl, DependencySet dependencySet) {
        if (aTermAppl == null || !ATermUtils.isLiteral(aTermAppl)) {
            throw new InternalReasonerException("Invalid value to create a literal. Value: " + aTermAppl);
        }
        return this.createLiteral(aTermAppl, dependencySet);
    }

    private Literal createLiteral(ATermAppl aTermAppl, DependencySet dependencySet) {
        Object object;
        ATermAppl aTermAppl2;
        if (ATermUtils.NO_DATATYPE.equals(aTermAppl.getArgument(2))) {
            aTermAppl2 = aTermAppl;
        } else {
            try {
                aTermAppl2 = this.getDatatypeReasoner().getCanonicalRepresentation(aTermAppl);
            }
            catch (InvalidLiteralException invalidLiteralException) {
                object = String.format("Attempt to create an invalid literal (%s): %s", aTermAppl, invalidLiteralException.getMessage());
                if (PelletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                    log.fine((String)object);
                    aTermAppl2 = aTermAppl;
                }
                log.severe((String)object);
                throw new InternalReasonerException((String)object, invalidLiteralException);
            }
            catch (UnrecognizedDatatypeException unrecognizedDatatypeException) {
                String string = String.format("Attempt to create a literal with an unrecognized datatype (%s): %s", aTermAppl, unrecognizedDatatypeException.getMessage());
                log.severe(string);
                throw new InternalReasonerException(string, unrecognizedDatatypeException);
            }
        }
        Node node = this.getNode((ATerm)aTermAppl2);
        if (node != null) {
            if (node instanceof Literal) {
                if (((Literal)node).getValue() == null && PelletOptions.USE_COMPLETION_QUEUE) {
                    object = new QueueElement(node);
                    this.completionQueue.add((QueueElement)object, NodeSelector.LITERAL);
                }
                if (this.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
                    this.branchEffects.add(this.getBranch(), node.getName());
                }
                return (Literal)node;
            }
            throw new InternalReasonerException("Same term refers to both a literal and an individual: " + aTermAppl2);
        }
        int n = this.branch;
        this.setBranch(DependencySet.NO_BRANCH);
        Literal literal = new Literal(aTermAppl2, aTermAppl, this, dependencySet);
        literal.addType(ATermUtils.TOP_LIT, dependencySet);
        this.setBranch(n);
        this.nodes.put(aTermAppl2, literal);
        this.nodeList.add(aTermAppl2);
        if (literal.getValue() == null && PelletOptions.USE_COMPLETION_QUEUE) {
            QueueElement queueElement = new QueueElement(literal);
            this.completionQueue.add(queueElement, NodeSelector.LITERAL);
        }
        if (this.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.branchEffects.add(this.getBranch(), literal.getName());
        }
        return literal;
    }

    public Individual addIndividual(ATermAppl aTermAppl, DependencySet dependencySet) {
        Individual individual = this.addIndividual(aTermAppl, null, dependencySet);
        if (this.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.branchEffects.add(this.getBranch(), individual.getName());
        }
        return individual;
    }

    public Individual addFreshIndividual(Individual individual, DependencySet dependencySet) {
        boolean bl = individual == null;
        ATermAppl aTermAppl = this.createUniqueName(bl);
        Individual individual2 = this.addIndividual(aTermAppl, individual, dependencySet);
        if (bl) {
            individual2.setNominalLevel(1);
        }
        return individual2;
    }

    private Individual addIndividual(ATermAppl aTermAppl, Individual individual, DependencySet dependencySet) {
        if (this.nodes.containsKey(aTermAppl)) {
            throw new InternalReasonerException("adding a node twice " + aTermAppl);
        }
        this.setChanged(true);
        Individual individual2 = new Individual(aTermAppl, this, individual);
        this.nodes.put(aTermAppl, individual2);
        this.nodeList.add(aTermAppl);
        if (individual2.getDepth() > this.stats.treeDepth) {
            this.stats.treeDepth = individual2.getDepth();
            if (log.isLoggable(Level.FINER)) {
                log.finer("Depth: " + this.stats.treeDepth + " Size: " + this.size());
            }
        }
        individual2.addType(ATermUtils.TOP, dependencySet);
        if (this.getBranch() > 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.branchEffects.add(this.getBranch(), individual2.getName());
        }
        return individual2;
    }

    public void addSame(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Individual individual = this.getIndividual((ATerm)aTermAppl);
        Individual individual2 = this.getIndividual((ATerm)aTermAppl2);
        ATermAppl aTermAppl3 = ATermUtils.makeSameAs((ATerm)aTermAppl, (ATerm)aTermAppl2);
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.kb.getSyntacticAssertions().add(aTermAppl3);
        }
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(aTermAppl3) : DependencySet.INDEPENDENT;
        this.getToBeMerged().add(new NodeMerge(individual, individual2, dependencySet));
    }

    public void addDifferent(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Individual individual = this.getIndividual((ATerm)aTermAppl);
        Individual individual2 = this.getIndividual((ATerm)aTermAppl2);
        ATermAppl aTermAppl3 = ATermUtils.makeDifferent((ATerm)aTermAppl, (ATerm)aTermAppl2);
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.kb.getSyntacticAssertions().add(aTermAppl3);
        }
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(aTermAppl3) : DependencySet.INDEPENDENT;
        int n = this.branch;
        this.setBranch(DependencySet.NO_BRANCH);
        individual.setDifferent(individual2, dependencySet);
        this.setBranch(n);
    }

    public void addAllDifferent(ATermList aTermList) {
        ATermAppl aTermAppl = ATermUtils.makeAllDifferent(aTermList);
        ATermList aTermList2 = aTermList;
        while (!aTermList2.isEmpty()) {
            ATermList aTermList3 = aTermList2.getNext();
            while (!aTermList3.isEmpty()) {
                Individual individual = this.getIndividual(aTermList2.getFirst());
                Individual individual2 = this.getIndividual(aTermList3.getFirst());
                if (PelletOptions.USE_INCREMENTAL_DELETION) {
                    this.kb.getSyntacticAssertions().add(aTermAppl);
                }
                DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(aTermAppl) : DependencySet.INDEPENDENT;
                int n = this.branch;
                this.setBranch(DependencySet.NO_BRANCH);
                individual.setDifferent(individual2, dependencySet);
                this.setBranch(n);
                aTermList3 = aTermList3.getNext();
            }
            aTermList2 = aTermList2.getNext();
        }
    }

    public boolean isNode(ATerm aTerm) {
        return this.getNode(aTerm) != null;
    }

    public final ATermAppl createUniqueName(boolean bl) {
        ++this.anonCount;
        ATermAppl aTermAppl = bl ? ATermUtils.makeAnonNominal(this.anonCount) : ATermUtils.makeAnon(this.anonCount);
        return aTermAppl;
    }

    public final Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public final List<ATermAppl> getNodeNames() {
        return this.nodeList;
    }

    public String toString() {
        return "[size: " + this.nodes.size() + " freeMemory: " + (double)Runtime.getRuntime().freeMemory() / 1000000.0 + "mb]";
    }

    public DatatypeReasoner getDatatypeReasoner() {
        return this.dtReasoner;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setComplete(boolean bl) {
        this.isComplete = bl;
    }

    public boolean isClosed() {
        return !PelletOptions.SATURATE_TABLEAU && this.clash != null;
    }

    public Clash getClash() {
        return this.clash;
    }

    public void setClash(Clash clash) {
        if (clash != null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("CLSH: " + clash);
                if (clash.getDepends().max() > this.branch && this.branch != -1) {
                    log.severe("Invalid clash dependency " + clash + " > " + this.branch);
                }
            }
            if (this.branch == DependencySet.NO_BRANCH && clash.getDepends().getBranch() == DependencySet.NO_BRANCH) {
                this.assertedClashes.add(clash);
            }
            if (this.clash != null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Clash was already set \nExisting: " + this.clash + "\nNew     : " + clash);
                }
                if (this.clash.getDepends().max() < clash.getDepends().max()) {
                    return;
                }
            }
        }
        this.clash = clash;
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.kb.getDependencyIndex().setClashDependencies(this.clash);
        }
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public Role getRole(ATerm aTerm) {
        return this.kb.getRole(aTerm);
    }

    public RBox getRBox() {
        return this.kb.getRBox();
    }

    public TBox getTBox() {
        return this.kb.getTBox();
    }

    public int getBranch() {
        return this.branch;
    }

    public void setBranch(int n) {
        this.branch = n;
    }

    public void incrementBranch() {
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            this.completionQueue.incrementBranch(this.branch);
        }
        ++this.branch;
    }

    public boolean isInitialized() {
        return this.initialized && !this.kb.isChanged();
    }

    public void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    public final boolean doExplanation() {
        return this.doExplanation;
    }

    public void setDoExplanation(boolean bl) {
        this.doExplanation = bl;
    }

    public void setExplanation(DependencySet dependencySet) {
        this.lastClash = Clash.unexplained(null, dependencySet);
    }

    public String getExplanation() {
        if (this.lastClash == null) {
            return "No inconsistency was found! There is no explanation generated.";
        }
        return this.lastClash.detailedString();
    }

    public Set<ATermAppl> getExplanationSet() {
        if (this.lastClash == null) {
            throw new RuntimeException("No explanation was generated!");
        }
        return this.lastClash.getDepends().getExplain();
    }

    public BranchEffectTracker getBranchEffectTracker() {
        if (this.branchEffects == null) {
            throw new NullPointerException();
        }
        return this.branchEffects;
    }

    public List<Branch> getBranches() {
        return this.branches;
    }

    public IncrementalChangeTracker getIncrementalChangeTracker() {
        if (this.incChangeTracker == null) {
            throw new NullPointerException();
        }
        return this.incChangeTracker;
    }

    public IndividualIterator getIndIterator() {
        return new IndividualIterator(this);
    }

    public void validate() {
        if (!PelletOptions.VALIDATE_ABOX) {
            return;
        }
        System.out.print("VALIDATING...");
        IndividualIterator individualIterator = this.getIndIterator();
        while (individualIterator.hasNext()) {
            Individual individual = (Individual)individualIterator.next();
            if (individual.isPruned()) continue;
            this.validate(individual);
        }
    }

    void validateTypes(Individual individual, List<ATermAppl> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ATermAppl aTermAppl;
            ATermAppl aTermAppl2 = list.get(i);
            if (aTermAppl2.getArity() == 0 || !individual.hasType((ATerm)(aTermAppl = (ATermAppl)aTermAppl2.getArgument(0)))) continue;
            if (!individual.hasType((ATerm)aTermAppl2)) {
                throw new InternalReasonerException("Invalid type found: " + individual + " " + " " + aTermAppl2 + " " + individual.debugString() + " " + individual.depends);
            }
            throw new InternalReasonerException("Clash found: " + individual + " " + aTermAppl2 + " " + individual.debugString() + " " + individual.depends);
        }
    }

    void validate(Individual individual) {
        Object object;
        Object object2;
        int n;
        Object object3;
        this.validateTypes(individual, individual.getTypes(0));
        this.validateTypes(individual, individual.getTypes(2));
        this.validateTypes(individual, individual.getTypes(1));
        this.validateTypes(individual, individual.getTypes(5));
        if (!individual.isRoot()) {
            object3 = individual.getInEdges();
            int n2 = n = ((EdgeList)object3).size() == 1 || ((EdgeList)object3).size() == 2 && ((EdgeList)object3).hasEdgeFrom(individual) ? 1 : 0;
            if (n == 0) {
                throw new InternalReasonerException("Invalid blockable node: " + individual + " " + individual.getInEdges());
            }
        } else if (individual.isNominal()) {
            object3 = ATermUtils.makeValue((ATerm)individual.getName());
            if (!ATermUtils.isAnonNominal(individual.getName()) && !individual.hasType((ATerm)object3)) {
                throw new InternalReasonerException("Invalid nominal node: " + individual + " " + individual.getTypes());
            }
        }
        for (ATermAppl aTermAppl : individual.getDepends().keySet()) {
            object2 = individual.getDepends((ATerm)aTermAppl);
            if (((DependencySet)object2).max() <= this.branch && (PelletOptions.USE_SMART_RESTORE || ((DependencySet)object2).getBranch() <= this.branch)) continue;
            throw new InternalReasonerException("Invalid ds found: " + individual + " " + aTermAppl + " " + object2 + " " + this.branch);
        }
        for (Node node : individual.getDifferents()) {
            object2 = individual.getDifferenceDependency(node);
            if (((DependencySet)object2).max() > this.branch || ((DependencySet)object2).getBranch() > this.branch) {
                throw new InternalReasonerException("Invalid ds: " + individual + " != " + node + " " + object2);
            }
            if (node.getDifferenceDependency(individual) != null) continue;
            throw new InternalReasonerException("Invalid difference: " + individual + " != " + node + " " + object2);
        }
        object3 = individual.getOutEdges();
        for (n = 0; n < ((EdgeList)object3).size(); ++n) {
            object2 = ((EdgeList)object3).edgeAt(n);
            object = object2.getTo();
            if (this.nodes.get(((Node)object).getName()) != object) {
                throw new InternalReasonerException("Invalid edge to a non-existing node: " + object2 + " " + this.nodes.get(((Node)object).getName()) + "(" + this.nodes.get(((Node)object).getName()).hashCode() + ")" + object + "(" + object.hashCode() + ")");
            }
            if (!((Node)object).getInEdges().hasEdge((Edge)object2)) {
                throw new InternalReasonerException("Invalid edge: " + object2);
            }
            if (((Node)object).isMerged()) {
                throw new InternalReasonerException("Invalid edge to a removed node: " + object2 + " " + ((Node)object).isMerged());
            }
            DependencySet dependencySet = object2.getDepends();
            if (dependencySet.max() > this.branch || dependencySet.getBranch() > this.branch) {
                throw new InternalReasonerException("Invalid ds: " + object2 + " " + dependencySet);
            }
            EdgeList edgeList = individual.getEdgesTo((Node)object);
            if (edgeList.getRoles().size() == edgeList.size()) continue;
            throw new InternalReasonerException("Duplicate edges: " + edgeList);
        }
        object3 = individual.getInEdges();
        for (n = 0; n < ((EdgeList)object3).size(); ++n) {
            object2 = ((EdgeList)object3).edgeAt(n);
            object = object2.getDepends();
            if (((DependencySet)object).max() <= this.branch && ((DependencySet)object).getBranch() <= this.branch) continue;
            throw new InternalReasonerException("Invalid ds: " + object2 + " " + object);
        }
    }

    public void printTree() {
        if (!PelletOptions.PRINT_ABOX) {
            return;
        }
        System.err.println("PRINTING... " + DependencySet.INDEPENDENT);
        for (Node node : this.nodes.values()) {
            if (!node.isRoot() || node instanceof Literal) continue;
            this.printNode((Individual)node, new HashSet<Individual>(), "   ");
        }
    }

    private void printNode(Individual individual, Set<Individual> set, String string) {
        boolean bl = individual.isNominal() && !set.isEmpty();
        System.err.print(individual);
        if (!set.add(individual)) {
            System.err.println();
            return;
        }
        if (individual.isMerged()) {
            System.err.println(" -> " + individual.getMergedTo() + " " + individual.getMergeDependency(false));
            return;
        }
        if (individual.isPruned()) {
            throw new InternalReasonerException("Pruned node: " + individual);
        }
        System.err.print(" = ");
        for (int i = 0; i < 7; ++i) {
            for (ATermAppl object2 : individual.getTypes(i)) {
                System.err.print(ATermUtils.toString(object2));
                System.err.print(", ");
            }
        }
        System.err.println(individual.getDifferents());
        if (bl) {
            return;
        }
        string = string + "  ";
        for (Object object : individual.getOutEdges()) {
            Node node = object.getTo();
            EdgeList edgeList = individual.getEdgesTo(node);
            System.err.print(string + "[");
            for (int i = 0; i < edgeList.size(); ++i) {
                if (i > 0) {
                    System.err.print(", ");
                }
                System.err.print(edgeList.edgeAt(i).getRole());
            }
            System.err.print("] ");
            if (node instanceof Individual) {
                this.printNode((Individual)node, set, string);
                continue;
            }
            System.err.println(" (Literal) " + ATermUtils.toString(node.getName()) + " " + ATermUtils.toString(node.getTypes()));
        }
    }

    public Clash getLastClash() {
        return this.lastClash;
    }

    public ABox getLastCompletion() {
        return this.lastCompletion;
    }

    public boolean isKeepLastCompletion() {
        return this.keepLastCompletion;
    }

    public void setKeepLastCompletion(boolean bl) {
        this.keepLastCompletion = bl;
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public void setLastCompletion(ABox aBox) {
        this.lastCompletion = aBox;
    }

    protected void setSyntacticUpdate(boolean bl) {
        this.syntacticUpdate = bl;
    }

    protected boolean isSyntacticUpdate() {
        return this.syntacticUpdate;
    }

    public CompletionQueue getCompletionQueue() {
        return this.completionQueue;
    }

    public void reset() {
        if (!this.isComplete()) {
            return;
        }
        this.setComplete(false);
        Iterator<ATermAppl> iterator = this.nodeList.iterator();
        while (iterator.hasNext()) {
            ATermAppl aTermAppl = iterator.next();
            Node node = this.nodes.get(aTermAppl);
            if (!node.isRootNominal()) {
                iterator.remove();
                this.nodes.remove(aTermAppl);
                continue;
            }
            node.reset(false);
        }
        this.setComplete(false);
        this.setInitialized(false);
        this.setClash(null);
        this.setBranch(DependencySet.NO_BRANCH);
        this.branches = new ArrayList<Branch>();
        this.setDisjBranchStats(new HashMap<ATermAppl, int[]>());
        this.rulesNotApplied = true;
    }

    public void resetQueue() {
        for (Node node : this.nodes.values()) {
            node.reset(true);
        }
    }

    public int setAnonCount(int n) {
        this.anonCount = n;
        return this.anonCount;
    }

    public int getAnonCount() {
        return this.anonCount;
    }

    public void setDisjBranchStats(Map<ATermAppl, int[]> map) {
        this.disjBranchStats = map;
    }

    public Map<ATermAppl, int[]> getDisjBranchStats() {
        return this.disjBranchStats;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public List<NodeMerge> getToBeMerged() {
        return this.toBeMerged;
    }
}

