/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.sparqlowl.parser;

import java.text.StringCharacterIterator;

public class ParserUtilities {
    public static String dropFirstAndLast(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        int n = string.length();
        if (n < 3) {
            if (n == 2) {
                return "";
            }
            throw new IllegalArgumentException();
        }
        return string.substring(1, n - 1);
    }

    public static String dropFirstAndLast3(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        int n = string.length();
        if (n < 7) {
            if (n == 6) {
                return "";
            }
            throw new IllegalArgumentException();
        }
        return string.substring(3, n - 3);
    }

    public static String sparqlUnescape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            if (c == '\\') {
                c = stringCharacterIterator.next();
                switch (c) {
                    case 't': {
                        stringBuilder.append('\t');
                        break;
                    }
                    case 'b': {
                        stringBuilder.append('\b');
                        break;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        break;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        break;
                    }
                    case '\\': {
                        stringBuilder.append('\\');
                        break;
                    }
                    case '\"': {
                        stringBuilder.append('\"');
                        break;
                    }
                    case '\'': {
                        stringBuilder.append('\'');
                        break;
                    }
                    case '\uffff': {
                        stringBuilder.append('\\');
                        break;
                    }
                    default: {
                        stringBuilder.append('\\');
                        stringBuilder.append(c);
                        break;
                    }
                }
            } else {
                stringBuilder.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }
}

