/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Set;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.iterator.MultiListIterator;

public class ELSyntaxUtils {
    public static boolean isEL(ATermAppl aTermAppl) {
        AFun aFun = aTermAppl.getAFun();
        boolean bl = false;
        if (ATermUtils.isPrimitive(aTermAppl) || ATermUtils.isBottom(aTermAppl)) {
            bl = true;
        } else if (aFun.equals(ATermUtils.ANDFUN)) {
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            while (!aTermList.isEmpty() && ELSyntaxUtils.isEL((ATermAppl)aTermList.getFirst())) {
                aTermList = aTermList.getNext();
            }
            bl = aTermList.isEmpty();
        } else if (aFun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(1);
            bl = ATermUtils.isPrimitive(aTermAppl2) && ELSyntaxUtils.isEL(aTermAppl3);
        } else {
            bl = false;
        }
        return bl;
    }

    public static ATermAppl simplify(ATermAppl aTermAppl) throws InternalReasonerException {
        ATermAppl aTermAppl2 = aTermAppl;
        AFun aFun = aTermAppl.getAFun();
        if (aFun.equals(ATermUtils.ANDFUN)) {
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            Set<ATermAppl> set = CollectionUtils.makeSet();
            MultiListIterator multiListIterator = new MultiListIterator(aTermList);
            while (multiListIterator.hasNext()) {
                ATermAppl aTermAppl3 = multiListIterator.next();
                if (ATermUtils.isAnd(aTermAppl3)) {
                    multiListIterator.append((ATermList)aTermAppl3.getArgument(0));
                    continue;
                }
                if (aTermAppl3.equals(ATermUtils.BOTTOM)) {
                    return ATermUtils.BOTTOM;
                }
                if (aTermAppl3.equals(ATermUtils.TOP)) continue;
                set.add(aTermAppl3);
            }
            if (set.size() > 1) {
                aTermAppl2 = ATermUtils.makeAnd(ATermUtils.toSet(set));
            } else if (set.size() == 1) {
                aTermAppl2 = set.iterator().next();
            }
        } else if (aFun.equals(ATermUtils.SOMEFUN)) {
            ATerm aTerm = aTermAppl.getArgument(0);
            ATermAppl aTermAppl4 = (ATermAppl)aTermAppl.getArgument(1);
            ATermAppl aTermAppl5 = ELSyntaxUtils.simplify(aTermAppl4);
            aTermAppl2 = aTermAppl5.equals(ATermUtils.BOTTOM) ? ATermUtils.BOTTOM : ATermUtils.makeSomeValues(aTerm, (ATerm)aTermAppl5);
        } else if (!(ATermUtils.isPrimitive(aTermAppl) || ATermUtils.isBottom(aTermAppl) || ATermUtils.isTop(aTermAppl))) {
            throw new InternalReasonerException("Concept " + aTermAppl + " is not an EL concept");
        }
        return aTermAppl2;
    }
}

