/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDUnsignedInt
extends AbstractDerivedIntegerType {
    private static final XSDUnsignedInt instance;
    private static final long MAX_VALUE;

    public static XSDUnsignedInt getInstance() {
        return instance;
    }

    private XSDUnsignedInt() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#unsignedInt"), 0, MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String string) throws InvalidLiteralException {
        try {
            long l = DatatypeConverter.parseLong(string);
            if (l < 0L) {
                throw new InvalidLiteralException(this.getName(), string);
            }
            if (l > MAX_VALUE) {
                throw new InvalidLiteralException(this.getName(), string);
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
    }

    static {
        MAX_VALUE = 0xFFFFFFFFL;
        instance = new XSDUnsignedInt();
    }
}

