/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermBlob;
import aterm.ATermList;
import aterm.ATermPlaceholder;
import aterm.Visitor;
import aterm.pure.ATermImpl;
import aterm.pure.PureFactory;
import java.util.List;
import jjtraveler.VisitFailure;
import shared.SharedObject;

class ATermBlobImpl
extends ATermImpl
implements ATermBlob {
    byte[] data;

    protected ATermBlobImpl(PureFactory factory) {
        super(factory);
    }

    public int getType() {
        return 6;
    }

    protected void init(int hashCode, ATermList annos, byte[] data) {
        super.init(hashCode, annos);
        this.data = data;
    }

    public SharedObject duplicate() {
        ATermBlobImpl clone = new ATermBlobImpl(this.factory);
        clone.init(this.hashCode(), this.getAnnotations(), this.data);
        return clone;
    }

    public boolean equivalent(SharedObject obj) {
        if (super.equivalent(obj)) {
            ATermBlob peer = (ATermBlob)((Object)obj);
            return peer.getBlobData() == this.data;
        }
        return false;
    }

    protected boolean match(ATerm pattern, List list) {
        ATermAppl appl;
        AFun afun;
        ATerm type;
        if (this.equals(pattern)) {
            return true;
        }
        if (pattern.getType() == 5 && (type = ((ATermPlaceholder)pattern).getPlaceholder()).getType() == 3 && (afun = (appl = (ATermAppl)type).getAFun()).getName().equals("blob") && afun.getArity() == 0 && !afun.isQuoted()) {
            list.add(this.data);
            return true;
        }
        return super.match(pattern, list);
    }

    public byte[] getBlobData() {
        return this.data;
    }

    public int getBlobSize() {
        return this.data.length;
    }

    public ATerm setAnnotations(ATermList annos) {
        return this.getPureFactory().makeBlob(this.data, annos);
    }

    public void accept(Visitor v) throws VisitFailure {
        v.visitBlob(this);
    }
}

