/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.lang.LangTurtleBase;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;

public class LangTriG
extends LangTurtleBase<Quad> {
    public LangTriG(Tokenizer tokens2, ParserProfile profile, StreamRDF dest) {
        super(tokens2, profile, dest);
    }

    @Override
    public Lang getLang() {
        return RDFLanguages.TRIG;
    }

    @Override
    protected final void oneTopLevelElement() {
        this.oneNamedGraphBlock();
    }

    protected final void oneNamedGraphBlock() {
        Node graphNode = Quad.tripleInQuad;
        Token token = this.peekToken();
        if (token.isNode()) {
            Token t = token;
            graphNode = this.node();
            this.nextToken();
            token = this.peekToken();
            if (graphNode.isURI()) {
                this.setCurrentGraph(graphNode);
            } else {
                this.exception(t, "Not a legal graph name: " + graphNode, new Object[0]);
            }
        } else {
            this.setCurrentGraph(Quad.tripleInQuad);
        }
        if (token.getType() == TokenType.EQUALS) {
            this.nextToken();
            token = this.peekToken();
        }
        if (token.getType() != TokenType.LBRACE) {
            this.exception(token, "Expected start of graph: got %s", this.peekToken());
        }
        this.nextToken();
        while (!(token = this.peekToken()).hasType(TokenType.RBRACE)) {
            this.triplesSameSubject();
        }
        token = this.nextToken();
        if (token.getType() != TokenType.RBRACE) {
            this.exception(token, "Expected end of graph: got %s", token);
        }
        if ((token = this.peekToken()).hasType(TokenType.DOT)) {
            this.nextToken();
        }
        this.setCurrentGraph(Quad.tripleInQuad);
    }

    @Override
    protected void expectEndOfTriples() {
        if (this.lookingAt(TokenType.DOT)) {
            this.nextToken();
            return;
        }
        if (this.lookingAt(TokenType.RBRACE)) {
            return;
        }
        this.exception(this.peekToken(), "Triples not terminated properly: expected '.', '}' or EOF: got %s", this.peekToken());
    }

    @Override
    protected void emit(Node subject, Node predicate, Node object) {
        Node graph = this.getCurrentGraph();
        if (graph == Quad.defaultGraphNodeGenerated) {
            graph = Quad.tripleInQuad;
        }
        Quad quad = this.profile.createQuad(graph, subject, predicate, object, this.currLine, this.currCol);
        this.dest.quad(quad);
    }
}

