/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.VersionInfo;
import pellet.PelletClassify;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletConsistency;
import pellet.PelletEntailment;
import pellet.PelletExceptionFormatter;
import pellet.PelletExplain;
import pellet.PelletExtractInferences;
import pellet.PelletInfo;
import pellet.PelletModularity;
import pellet.PelletQuery;
import pellet.PelletRealize;
import pellet.PelletTransTree;
import pellet.PelletUnsatisfiable;
import pellet.Pellint;

public class Pellet {
    public static final Logger logger = Logger.getLogger(Pellet.class.getName());
    public static final PelletExceptionFormatter exceptionFormatter = new PelletExceptionFormatter();
    private static final Map<String, PelletCmdApp> COMMANDS = new TreeMap<String, PelletCmdApp>();

    public static void main(String[] stringArray) {
        Pellet pellet = new Pellet();
        try {
            pellet.run(stringArray);
        }
        catch (PelletCmdException pelletCmdException) {
            Pellet.printError(pelletCmdException);
            StringWriter stringWriter = new StringWriter();
            pelletCmdException.printStackTrace(new PrintWriter(stringWriter));
            logger.fine(stringWriter.toString());
            logger.throwing(null, null, pelletCmdException);
            System.exit(1);
        }
    }

    private static void printError(Throwable throwable) {
        System.err.println(exceptionFormatter.formatException(throwable));
    }

    public static PelletCmdApp getCommand(String string) {
        PelletCmdApp pelletCmdApp = COMMANDS.get(string.toLowerCase());
        if (pelletCmdApp == null) {
            throw new PelletCmdException("Unrecognized subcommand: " + string);
        }
        return pelletCmdApp;
    }

    private void run(String[] stringArray) {
        if (stringArray.length == 0) {
            throw new PelletCmdException("Type 'pellet help' for usage.");
        }
        String string = stringArray[0];
        if (string.equals("h") || string.equals("-h") || string.equals("help") || string.equals("--help")) {
            if (stringArray.length == 1) {
                this.mainhelp();
            } else {
                PelletCmdApp pelletCmdApp = Pellet.getCommand(stringArray[1]);
                pelletCmdApp.help();
            }
        } else if (string.equals("--version") || string.equals("-V")) {
            this.version();
        } else {
            PelletCmdApp pelletCmdApp = Pellet.getCommand(string);
            pelletCmdApp.parseArgs(stringArray);
            pelletCmdApp.run();
            pelletCmdApp.finish();
        }
    }

    private void mainhelp() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getVersionInfo().getVersionString();
        stringBuffer.append("Usage: pellet <subcommand> [options] <file URI>...\n");
        stringBuffer.append("Pellet command-line client, version " + string + "." + "\n");
        stringBuffer.append("Type 'pellet help <subcommand>' for help on a specific subcommand.\n");
        stringBuffer.append("\n");
        stringBuffer.append("Available subcommands:\n");
        for (String string2 : COMMANDS.keySet()) {
            stringBuffer.append("\t");
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Pellet is an OWL ontology reasoner.\n");
        stringBuffer.append("For more information, see http://clarkparsia.com/pellet");
        System.out.println(stringBuffer);
        System.exit(0);
    }

    private VersionInfo getVersionInfo() {
        return VersionInfo.getInstance();
    }

    private void version() {
        System.out.println(this.getVersionInfo());
    }

    static {
        COMMANDS.put("classify", new PelletClassify());
        COMMANDS.put("consistency", new PelletConsistency());
        COMMANDS.put("realize", new PelletRealize());
        COMMANDS.put("unsat", new PelletUnsatisfiable());
        COMMANDS.put("explain", new PelletExplain());
        COMMANDS.put("query", new PelletQuery());
        COMMANDS.put("modularity", new PelletModularity());
        COMMANDS.put("trans-tree", new PelletTransTree());
        COMMANDS.put("extract", new PelletExtractInferences());
        COMMANDS.put("lint", new Pellint());
        COMMANDS.put("info", new PelletInfo());
        COMMANDS.put("entail", new PelletEntailment());
    }
}

