/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import aterm.ATermAppl;
import com.clarkparsia.pellet.owlapiv3.PelletVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.Timer;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;

public class PelletLoader {
    public static Logger log = Logger.getLogger(PelletLoader.class.getName());
    private KnowledgeBase kb;
    private OWLOntologyManager manager;
    private Set<OWLOntology> ontologies;
    private boolean processImports;
    private Set<OWLOntology> notImported;
    private Map<OWLOntology, Set<OWLOntology>> importDependencies;
    private PelletVisitor visitor;
    private ChangeVisitor changeVisitor = new ChangeVisitor();

    public PelletLoader(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
        this.visitor = new PelletVisitor(knowledgeBase);
        this.processImports = true;
        this.ontologies = new HashSet<OWLOntology>();
        this.notImported = new HashSet<OWLOntology>();
        this.importDependencies = new HashMap<OWLOntology, Set<OWLOntology>>();
    }

    public boolean loadImports() {
        return this.getProcessImports();
    }

    public void setLoadImports(boolean bl) {
        this.setProcessImports(bl);
    }

    public boolean getProcessImports() {
        return this.processImports;
    }

    public void setProcessImports(boolean bl) {
        this.processImports = bl;
    }

    public void clear() {
        this.visitor.clear();
        this.kb.clear();
        this.ontologies.clear();
        this.notImported.clear();
        this.importDependencies.clear();
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public void setKB(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
    }

    public ATermAppl term(OWLObject oWLObject) {
        this.visitor.reset();
        this.visitor.setAddAxiom(false);
        oWLObject.accept((OWLObjectVisitor)this.visitor);
        ATermAppl aTermAppl = this.visitor.result();
        if (aTermAppl == null) {
            throw new InternalReasonerException("Cannot create ATerm from description " + oWLObject);
        }
        return aTermAppl;
    }

    public void reload() {
        log.fine("Reloading the ontologies");
        HashSet<OWLOntology> hashSet = new HashSet<OWLOntology>(this.notImported);
        this.clear();
        this.load(hashSet);
    }

    public void load(Set<OWLOntology> set) {
        Timer timer = this.kb.timers.startTimer("load");
        int n = 0;
        LinkedHashSet<OWLOntology> linkedHashSet = new LinkedHashSet<OWLOntology>();
        for (OWLOntology oWLOntology : set) {
            n += this.load(oWLOntology, false, linkedHashSet);
        }
        this.visitor.reset();
        this.visitor.setAddAxiom(true);
        for (OWLOntology oWLOntology : linkedHashSet) {
            oWLOntology.accept((OWLObjectVisitor)this.visitor);
        }
        this.visitor.verify();
        timer.stop();
    }

    private int load(OWLOntology oWLOntology, boolean bl, Collection<OWLOntology> collection) {
        boolean bl2;
        if (!bl) {
            this.notImported.add(oWLOntology);
        }
        if (!(bl2 = this.ontologies.add(oWLOntology))) {
            return 0;
        }
        int n = oWLOntology.getAxioms().size();
        collection.add(oWLOntology);
        if (this.processImports) {
            for (OWLOntology oWLOntology2 : oWLOntology.getImports()) {
                n += this.load(oWLOntology2, true, collection);
                Set<OWLOntology> set = this.importDependencies.get(oWLOntology2);
                if (set == null) {
                    set = new HashSet<OWLOntology>();
                    this.importDependencies.put(oWLOntology2, set);
                }
                set.add(oWLOntology);
            }
        }
        return n;
    }

    public Set<OWLAxiom> getUnsupportedAxioms() {
        return this.visitor.getUnsupportedAxioms();
    }

    public void unload(Set<OWLOntology> set) {
        for (OWLOntology oWLOntology : set) {
            this.unload(oWLOntology);
        }
    }

    private void unload(OWLOntology oWLOntology) {
        boolean bl = this.ontologies.remove(oWLOntology);
        if (!bl) {
            return;
        }
        this.notImported.remove(oWLOntology);
        if (this.processImports) {
            for (OWLOntology oWLOntology2 : oWLOntology.getImports()) {
                Set<OWLOntology> set = this.importDependencies.get(oWLOntology2);
                if (set == null) continue;
                set.remove(oWLOntology);
                if (!set.isEmpty()) continue;
                this.importDependencies.remove(oWLOntology2);
                if (this.notImported.contains(oWLOntology2)) continue;
                this.unload(oWLOntology2);
            }
        }
    }

    public Set<OWLOntology> getOntologies() {
        return Collections.unmodifiableSet(this.ontologies);
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public void setManager(OWLOntologyManager oWLOntologyManager) {
        this.manager = oWLOntologyManager;
    }

    public boolean applyChanges(List<? extends OWLOntologyChange> list) {
        for (OWLOntologyChange oWLOntologyChange : list) {
            if (!this.ontologies.contains(oWLOntologyChange.getOntology()) || this.changeVisitor.process(oWLOntologyChange)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Reload required by ontology change " + oWLOntologyChange);
            }
            return false;
        }
        return true;
    }

    private class ChangeVisitor
    implements OWLOntologyChangeVisitor {
        private boolean reloadRequired;

        private ChangeVisitor() {
        }

        public boolean isReloadRequired() {
            return this.reloadRequired;
        }

        public boolean process(OWLOntologyChange oWLOntologyChange) {
            this.reset();
            oWLOntologyChange.accept((OWLOntologyChangeVisitor)this);
            return !this.isReloadRequired();
        }

        public void reset() {
            PelletLoader.this.visitor.reset();
            this.reloadRequired = false;
        }

        public void visit(AddAxiom addAxiom) {
            PelletLoader.this.visitor.setAddAxiom(true);
            addAxiom.getAxiom().accept((OWLObjectVisitor)PelletLoader.this.visitor);
            this.reloadRequired = PelletLoader.this.visitor.isReloadRequired();
        }

        public void visit(RemoveAxiom removeAxiom) {
            PelletLoader.this.visitor.setAddAxiom(false);
            removeAxiom.getAxiom().accept((OWLObjectVisitor)PelletLoader.this.visitor);
            this.reloadRequired = PelletLoader.this.visitor.isReloadRequired();
        }

        public void visit(AddImport addImport) {
            this.reloadRequired = PelletLoader.this.getProcessImports();
        }

        public void visit(AddOntologyAnnotation addOntologyAnnotation) {
        }

        public void visit(RemoveImport removeImport) {
            this.reloadRequired = PelletLoader.this.getProcessImports();
        }

        public void visit(RemoveOntologyAnnotation removeOntologyAnnotation) {
        }

        public void visit(SetOntologyID setOntologyID) {
        }
    }
}

