/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import com.clarkparsia.modularity.AbstractModuleExtractor;
import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import com.clarkparsia.owlapi.modularity.locality.LocalityEvaluator;
import com.clarkparsia.owlapi.modularity.locality.SyntacticLocalityEvaluator;
import com.clarkparsia.owlapiv3.OntologyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.DisjointSet;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.progress.ConsoleProgressMonitor;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;

public class AxiomBasedModuleExtractor
extends AbstractModuleExtractor {
    public static final Logger log = Logger.getLogger(AxiomBasedModuleExtractor.class.getName());
    private boolean optimizeForSharedModules = true;

    public AxiomBasedModuleExtractor() {
    }

    public AxiomBasedModuleExtractor(LocalityClass localityClass) {
        super((LocalityEvaluator)new SyntacticLocalityEvaluator(localityClass));
    }

    public AxiomBasedModuleExtractor(LocalityEvaluator localityEvaluator) {
        super(localityEvaluator);
    }

    private OWLEntity extractModuleSignature(OWLEntity oWLEntity, Set<OWLEntity> set, List<OWLEntity> list, Set<OWLEntity> set2) {
        assert (!this.modules.containsKey(oWLEntity)) : "po already contained entity";
        assert (list.isEmpty()) : "non-empty current cycle passed into function";
        HashSet<OWLEntity> hashSet = new HashSet<OWLEntity>();
        if (oWLEntity != null) {
            set2.add(oWLEntity);
            hashSet.add(oWLEntity);
            set.add(oWLEntity);
            this.modules.put(oWLEntity, set2);
        }
        int n = -1;
        HashSet<Object> hashSet2 = new HashSet();
        while (set2.size() != n) {
            Object object;
            n = set2.size();
            ArrayList<OWLEntity> arrayList = new ArrayList<OWLEntity>();
            Iterator iterator = SetUtils.difference(set2, hashSet2);
            hashSet2 = new HashSet<OWLEntity>(set2);
            OWLEntity oWLEntity22 = new HashSet();
            Object object2 = iterator.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                for (OWLAxiom oWLAxiom : this.getAxioms((OWLEntity)object)) {
                    if (!oWLEntity22.add(oWLAxiom) || this.isLocal(oWLAxiom, set2)) continue;
                    for (OWLEntity oWLEntity3 : this.getSignature(oWLAxiom)) {
                        if (!set2.add(oWLEntity3)) continue;
                        arrayList.add(oWLEntity3);
                    }
                }
            }
            for (OWLEntity oWLEntity22 : arrayList) {
                if (hashSet.contains(oWLEntity22)) continue;
                if (!this.modules.containsKey(oWLEntity22)) {
                    object2 = new HashSet();
                    object = new ArrayList();
                    OWLEntity oWLEntity4 = this.extractModuleSignature(oWLEntity22, set, (List<OWLEntity>)object, (Set<OWLEntity>)object2);
                    set2.addAll((Collection<OWLEntity>)object2);
                    if (oWLEntity4.equals(oWLEntity22)) {
                        assert (!set.contains(oWLEntity22)) : "Recursive call did not cleanup stack";
                        continue;
                    }
                    hashSet.addAll((Collection<OWLEntity>)object);
                    if (hashSet.contains(oWLEntity4)) {
                        set.addAll((Collection<OWLEntity>)object);
                        continue;
                    }
                    list.addAll(hashSet);
                    return oWLEntity4;
                }
                if (set.contains(oWLEntity22)) {
                    list.addAll(hashSet);
                    return oWLEntity22;
                }
                set2.addAll((Collection)this.modules.get(oWLEntity22));
            }
            for (OWLEntity oWLEntity22 : hashSet) {
                this.modules.put(oWLEntity22, set2);
            }
        }
        set.removeAll(hashSet);
        return oWLEntity;
    }

    private void extractModuleSignature(OWLEntity oWLEntity, DisjointSet<OWLEntity> disjointSet, ArrayList<OWLEntity> arrayList, Set<OWLEntity> set) {
        assert (!arrayList.contains(oWLEntity)) : "stack contained entity already";
        assert (!this.modules.containsKey(oWLEntity)) : "po already contained entity";
        HashSet<OWLEntity> hashSet = new HashSet<OWLEntity>();
        if (oWLEntity != null) {
            arrayList.add(oWLEntity);
            set.add(oWLEntity);
            disjointSet.add(oWLEntity);
            hashSet.add(oWLEntity);
            this.modules.put(oWLEntity, hashSet);
        }
        int n = -1;
        HashSet hashSet2 = new HashSet();
        while (hashSet.size() != n) {
            n = hashSet.size();
            ArrayList arrayList2 = new ArrayList();
            Set set2 = SetUtils.difference(hashSet, hashSet2);
            hashSet2 = new HashSet(hashSet);
            OWLEntity oWLEntity2 = new HashSet();
            for (OWLEntity oWLEntity3 : set2) {
                for (OWLAxiom oWLAxiom : this.getAxioms(oWLEntity3)) {
                    if (!oWLEntity2.add(oWLAxiom) || this.isLocal(oWLAxiom, hashSet)) continue;
                    for (OWLEntity oWLEntity4 : this.getSignature(oWLAxiom)) {
                        if (!hashSet.add(oWLEntity4)) continue;
                        arrayList2.add(oWLEntity4);
                    }
                }
            }
            Iterator object = arrayList2.iterator();
            while (object.hasNext()) {
                oWLEntity2 = (OWLEntity)object.next();
                if (oWLEntity2.equals(oWLEntity)) continue;
                if (!this.modules.containsKey(oWLEntity2)) {
                    this.extractModuleSignature(oWLEntity2, disjointSet, arrayList, set);
                }
                if (set.contains(oWLEntity2)) {
                    assert (arrayList.contains(oWLEntity2)) : "node was supposed to be on the stack";
                    boolean bl = false;
                    int n2 = arrayList.size() - 1;
                    while (!bl) {
                        OWLEntity oWLEntity5 = arrayList.get(n2);
                        disjointSet.union(oWLEntity2, oWLEntity5);
                        bl = oWLEntity5.equals(oWLEntity2);
                        --n2;
                    }
                    continue;
                }
                hashSet.addAll((Collection)this.modules.get(oWLEntity2));
            }
        }
        for (OWLEntity oWLEntity6 : disjointSet.elements()) {
            if (!disjointSet.isSame(oWLEntity, oWLEntity6)) continue;
            ((Set)this.modules.get(oWLEntity6)).addAll(hashSet);
        }
        arrayList.remove(arrayList.size() - 1);
        set.remove(oWLEntity);
    }

    @Override
    protected void extractModuleSignatures(Set<? extends OWLEntity> set) {
        log.fine("Extract module for " + set);
        ConsoleProgressMonitor consoleProgressMonitor = new ConsoleProgressMonitor();
        consoleProgressMonitor.setProgressTitle("Extracting");
        consoleProgressMonitor.setProgressLength(set.size());
        consoleProgressMonitor.taskStarted();
        HashSet<OWLEntity> hashSet = new HashSet<OWLEntity>();
        for (OWLAxiom oWLAxiom : this.getAxioms()) {
            if (this.isLocal(oWLAxiom, Collections.emptySet())) continue;
            hashSet.addAll(OntologyUtils.getSignature(oWLAxiom));
        }
        for (OWLEntity oWLEntity : set) {
            consoleProgressMonitor.incrementProgress();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Class: " + oWLEntity);
            }
            if (this.modules.containsKey(oWLEntity)) continue;
            if (this.optimizeForSharedModules) {
                this.extractModuleSignature(oWLEntity, new HashSet<OWLEntity>(), new ArrayList<OWLEntity>(), new HashSet<OWLEntity>(hashSet));
                continue;
            }
            this.extractModuleSignature(oWLEntity, new DisjointSet<OWLEntity>(), new ArrayList<OWLEntity>(), new HashSet<OWLEntity>(hashSet));
        }
        consoleProgressMonitor.taskFinished();
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.modules.toString());
        }
    }

    @Override
    public Set<OWLAxiom> extractModule(Set<? extends OWLEntity> set) {
        if (this.isChanged()) {
            this.resetModules();
        }
        HashSet<OWLEntity> hashSet = new HashSet<OWLEntity>(set);
        for (OWLAxiom oWLAxiom : this.getAxioms()) {
            if (this.isLocal(oWLAxiom, Collections.emptySet())) continue;
            hashSet.addAll(OntologyUtils.getSignature(oWLAxiom));
        }
        if (!this.entityAxioms.isEmpty()) {
            if (this.optimizeForSharedModules) {
                this.extractModuleSignature(null, new HashSet<OWLEntity>(), new ArrayList<OWLEntity>(), hashSet);
            } else {
                this.extractModuleSignature(null, new DisjointSet<OWLEntity>(), new ArrayList<OWLEntity>(), hashSet);
            }
        }
        return this.getModuleAxioms(hashSet);
    }

    public boolean isOptimizeForSharedModules() {
        return this.optimizeForSharedModules;
    }

    public void setOptimizeForSharedModules(boolean bl) {
        this.optimizeForSharedModules = bl;
    }
}

