/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpDiff;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpMinus;
import com.hp.hpl.jena.sparql.algebra.op.OpModifier;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.main.VarFinder;
import java.util.Set;
import org.apache.jena.atlas.lib.SetUtils;

public class JoinClassifier {
    public static boolean print = false;

    public static boolean isLinear(OpJoin join) {
        if (print) {
            System.err.println(join);
        }
        return JoinClassifier.isLinear(join.getLeft(), join.getRight());
    }

    public static boolean isLinear(Op left, Op right) {
        left = JoinClassifier.effectiveOp(left);
        if ((right = JoinClassifier.effectiveOp(right)) instanceof OpModifier) {
            return false;
        }
        if (right instanceof OpDiff) {
            return false;
        }
        if (right instanceof OpMinus) {
            return false;
        }
        return JoinClassifier.check(left, right);
    }

    private static boolean check(Op leftOp, Op rightOp) {
        boolean bad1;
        if (print) {
            System.err.println(leftOp);
            System.err.println(rightOp);
        }
        VarFinder vfLeft = new VarFinder(leftOp);
        Set<Var> vLeftFixed = vfLeft.getFixed();
        Set<Var> vLeftOpt = vfLeft.getOpt();
        if (print) {
            System.err.println("Left/fixed:    " + vLeftFixed);
        }
        if (print) {
            System.err.println("Left/opt:      " + vLeftOpt);
        }
        VarFinder vfRight = new VarFinder(rightOp);
        Set<Var> vRightFixed = vfRight.getFixed();
        Set<Var> vRightOpt = vfRight.getOpt();
        Set<Var> vRightFilter = vfRight.getFilter();
        if (print) {
            System.err.println("Right/fixed:   " + vRightFixed);
        }
        if (print) {
            System.err.println("Right/opt:     " + vRightOpt);
        }
        if (print) {
            System.err.println("Right/filter:  " + vRightFilter);
        }
        vLeftOpt = SetUtils.difference(vLeftOpt, vLeftFixed);
        vRightOpt = SetUtils.difference(vRightOpt, vRightFixed);
        vRightFilter = SetUtils.difference(vRightFilter, vRightFixed);
        if (print) {
            System.err.println();
        }
        if (print) {
            System.err.println("Left/opt:      " + vLeftOpt);
        }
        if (print) {
            System.err.println("Right/opt:     " + vRightOpt);
        }
        if (print) {
            System.err.println("Right/filter:  " + vRightFilter);
        }
        boolean r11 = SetUtils.intersectionP(vRightOpt, vLeftFixed);
        boolean r12 = SetUtils.intersectionP(vRightOpt, vLeftOpt);
        boolean bl = bad1 = r11 || r12;
        if (print) {
            System.err.println("bad1 = " + bad1);
        }
        boolean bad2 = SetUtils.intersectionP(vRightFilter, vLeftFixed);
        if (print) {
            System.err.println("bad2 = " + bad2);
        }
        return !bad1 && !bad2;
    }

    public static Op effectiveOp(Op op) {
        if (op instanceof OpExt) {
            op = ((OpExt)op).effectiveOp();
        }
        return op;
    }
}

