/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.owlapi.explanation.BlackBoxExplanation;
import com.clarkparsia.owlapi.explanation.GlassBoxExplanation;
import com.clarkparsia.owlapi.explanation.HSTExplanationGenerator;
import com.clarkparsia.owlapi.explanation.SatisfiabilityConverter;
import com.clarkparsia.owlapi.explanation.TransactionAwareSingleExpGen;
import com.clarkparsia.owlapi.explanation.io.ExplanationRenderer;
import com.clarkparsia.owlapi.explanation.io.manchester.ManchesterSyntaxExplanationRenderer;
import com.clarkparsia.owlapi.explanation.util.ExplanationProgressMonitor;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.OWLAPILoader;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxEditorParser;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.progress.ConsoleProgressMonitor;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.semanticweb.owlapi.expression.ParserException;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public class PelletExplain
extends PelletCmdApp {
    private SatisfiabilityConverter converter;
    private int errorExpCount = 0;
    private OWLAPILoader loader;
    private int maxExplanations = 1;
    private boolean useBlackBox = false;
    private ProgressMonitor monitor;
    private int multiAxiomExpCount = 0;
    private int multipleExpCount = 0;
    private PelletReasoner reasoner;
    private OWLEntity name1;
    private OWLEntity name2;
    private OWLObject name3;

    public PelletExplain() {
        GlassBoxExplanation.setup();
    }

    @Override
    public String getAppId() {
        return "PelletExplain: Explains one or more inferences in a given ontology including ontology inconsistency";
    }

    @Override
    public String getAppCmd() {
        return "pellet explain " + this.getMandatoryOptions() + "[options] <file URI>...\n\n" + "The options --unsat, --all-unsat, --inconsistent, --subclass, \n" + "--hierarchy, and --instance are mutually exclusive. By default \n " + "--inconsistent option is assumed. In the following descriptions \n" + "C, D, and i can be URIs or local names.";
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions pelletCmdOptions = this.getGlobalOptions();
        pelletCmdOptions.add(this.getIgnoreImportsOption());
        PelletCmdOption pelletCmdOption = new PelletCmdOption("unsat");
        pelletCmdOption.setType("C");
        pelletCmdOption.setDescription("Explain why the given class is unsatisfiable");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("all-unsat");
        pelletCmdOption.setDescription("Explain all unsatisfiable classes");
        pelletCmdOption.setDefaultValue(false);
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.NONE);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("inconsistent");
        pelletCmdOption.setDescription("Explain why the ontology is inconsistent");
        pelletCmdOption.setDefaultValue(false);
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.NONE);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("hierarchy");
        pelletCmdOption.setDescription("Print all explanations for the class hierarchy");
        pelletCmdOption.setDefaultValue(false);
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.NONE);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("subclass");
        pelletCmdOption.setDescription("Explain why C is a subclass of D");
        pelletCmdOption.setType("C,D");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("instance");
        pelletCmdOption.setDescription("Explain why i is an instance of C");
        pelletCmdOption.setType("i,C");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("property-value");
        pelletCmdOption.setDescription("Explain why s has value o for property p");
        pelletCmdOption.setType("s,p,o");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("method");
        pelletCmdOption.setShortOption("m");
        pelletCmdOption.setType("glass | black");
        pelletCmdOption.setDescription("Method that will be used to generate explanations");
        pelletCmdOption.setDefaultValue("glass");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("max");
        pelletCmdOption.setShortOption("x");
        pelletCmdOption.setType("positive integer");
        pelletCmdOption.setDescription("Maximum number of generated explanations for each inference");
        pelletCmdOption.setDefaultValue(1);
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = pelletCmdOptions.getOption("verbose");
        pelletCmdOption.setDescription("Print detailed exceptions and messages about the progress");
        return pelletCmdOptions;
    }

    @Override
    public void parseArgs(String[] stringArray) {
        super.parseArgs(stringArray);
        this.maxExplanations = this.options.getOption("max").getValueAsNonNegativeInteger();
        this.loader = (OWLAPILoader)this.getLoader("OWLAPIv3");
        this.getKB();
        this.converter = new SatisfiabilityConverter(this.loader.getManager().getOWLDataFactory());
        this.reasoner = this.loader.getReasoner();
        this.loadMethod();
        this.loadNames();
    }

    @Override
    public void run() {
        try {
            if (this.name1 == null) {
                this.verbose("Explain all the subclass relations in the ontology");
                this.explainClassHierarchy();
            } else if (this.name2 == null) {
                if (((OWLClassExpression)this.name1).isOWLNothing()) {
                    this.verbose("Explain all the unsatisfiable classes");
                    this.explainUnsatisfiableClasses();
                } else {
                    this.verbose("Explain unsatisfiability of " + this.name1);
                    this.explainUnsatisfiableClass((OWLClass)this.name1);
                }
            } else if (this.name3 != null) {
                this.verbose("Explain property assertion " + this.name1 + " and " + this.name2 + " and " + this.name3);
                this.explainPropertyValue((OWLIndividual)this.name1, (OWLProperty)this.name2, this.name3);
            } else if (this.name1.isOWLClass() && this.name2.isOWLClass()) {
                this.verbose("Explain subclass relation between " + this.name1 + " and " + this.name2);
                this.explainSubClass((OWLClass)this.name1, (OWLClass)this.name2);
            } else if (this.name1.isOWLNamedIndividual() && this.name2.isOWLClass()) {
                this.verbose("Explain instance relation between " + this.name1 + " and " + this.name2);
                this.explainInstance((OWLIndividual)this.name1, (OWLClass)this.name2);
            }
            this.printStatistics();
        }
        catch (OWLException oWLException) {
            throw new RuntimeException(oWLException);
        }
    }

    private void explainAxiom(OWLAxiom oWLAxiom) throws OWLException {
        int n;
        HSTExplanationGenerator hSTExplanationGenerator = new HSTExplanationGenerator(this.getSingleExplanationGenerator());
        RendererExplanationProgressMonitor rendererExplanationProgressMonitor = new RendererExplanationProgressMonitor(oWLAxiom);
        hSTExplanationGenerator.setProgressMonitor((ExplanationProgressMonitor)rendererExplanationProgressMonitor);
        OWLClassExpression oWLClassExpression = this.converter.convert(oWLAxiom);
        Timer timer = this.timers.startTimer("explain");
        Set set = hSTExplanationGenerator.getExplanations(oWLClassExpression, this.maxExplanations);
        timer.stop();
        if (set.isEmpty()) {
            rendererExplanationProgressMonitor.foundNoExplanations();
        }
        if (timer.getCount() % 10L == 0L) {
            // empty if block
        }
        if ((n = set.size()) == 0) {
            ++this.errorExpCount;
        } else if (n == 1) {
            if (((Set)set.iterator().next()).size() > 1) {
                ++this.multiAxiomExpCount;
            }
        } else {
            ++this.multipleExpCount;
        }
    }

    public void explainClassHierarchy() throws OWLException {
        HashSet<OWLClass> hashSet = new HashSet<OWLClass>();
        this.reasoner.flush();
        this.startTask("Classification");
        this.reasoner.getKB().classify();
        this.finishTask("Classification");
        this.startTask("Realization");
        this.reasoner.getKB().realize();
        this.finishTask("Realization");
        this.monitor = new ConsoleProgressMonitor();
        this.monitor.setProgressTitle("Explaining");
        this.monitor.setProgressLength(this.reasoner.getRootOntology().getClassesInSignature().size());
        this.monitor.taskStarted();
        Node<OWLClass> node = this.reasoner.getEquivalentClasses((OWLClassExpression)OWL.Nothing);
        this.explainClassHierarchy(OWL.Nothing, node, hashSet);
        Node<OWLClass> node2 = this.reasoner.getEquivalentClasses((OWLClassExpression)OWL.Thing);
        this.explainClassHierarchy(OWL.Thing, node2, hashSet);
        this.monitor.taskFinished();
    }

    public void explainEquivalentClass(OWLClass oWLClass, OWLClass oWLClass2) throws OWLException {
        if (oWLClass.equals(oWLClass2)) {
            return;
        }
        OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom = OWL.equivalentClasses((OWLClassExpression)oWLClass, (OWLClassExpression)oWLClass2);
        this.explainAxiom((OWLAxiom)oWLEquivalentClassesAxiom);
    }

    public void explainInstance(OWLIndividual oWLIndividual, OWLClass oWLClass) throws OWLException {
        if (oWLClass.isOWLThing()) {
            return;
        }
        OWLClassAssertionAxiom oWLClassAssertionAxiom = OWL.classAssertion(oWLIndividual, (OWLClassExpression)oWLClass);
        this.explainAxiom((OWLAxiom)oWLClassAssertionAxiom);
    }

    public void explainPropertyValue(OWLIndividual oWLIndividual, OWLProperty oWLProperty, OWLObject oWLObject) throws OWLException {
        if (oWLProperty.isOWLObjectProperty()) {
            this.explainAxiom((OWLAxiom)OWL.propertyAssertion(oWLIndividual, (OWLObjectPropertyExpression)((OWLObjectProperty)oWLProperty), (OWLIndividual)oWLObject));
        } else {
            this.explainAxiom((OWLAxiom)OWL.propertyAssertion(oWLIndividual, (OWLDataPropertyExpression)((OWLDataProperty)oWLProperty), (OWLLiteral)oWLObject));
        }
    }

    public void explainSubClass(OWLClass oWLClass, OWLClass oWLClass2) throws OWLException {
        if (oWLClass.equals(oWLClass2)) {
            return;
        }
        if (oWLClass.isOWLNothing()) {
            return;
        }
        if (oWLClass2.isOWLThing()) {
            return;
        }
        OWLSubClassOfAxiom oWLSubClassOfAxiom = OWL.subClassOf((OWLClassExpression)oWLClass, (OWLClassExpression)oWLClass2);
        this.explainAxiom((OWLAxiom)oWLSubClassOfAxiom);
    }

    public void explainUnsatisfiableClasses() throws OWLException {
        for (OWLClass oWLClass : this.reasoner.getEquivalentClasses((OWLClassExpression)OWL.Nothing)) {
            if (oWLClass.isOWLNothing()) continue;
            this.explainUnsatisfiableClass(oWLClass);
        }
    }

    public void explainUnsatisfiableClass(OWLClass oWLClass) throws OWLException {
        this.explainSubClass(oWLClass, OWL.Nothing);
    }

    private void explainClassHierarchy(OWLClass oWLClass, Node<OWLClass> node, Set<OWLClass> set) throws OWLException {
        Object object2;
        if (set.contains(oWLClass)) {
            return;
        }
        set.add(oWLClass);
        set.addAll(node.getEntities());
        for (Object object2 : node) {
            this.monitor.incrementProgress();
            this.explainEquivalentClass(oWLClass, (OWLClass)object2);
        }
        for (Object object2 : this.reasoner.getInstances((OWLClassExpression)oWLClass, true).getFlattened()) {
            this.explainInstance((OWLIndividual)object2, oWLClass);
        }
        Iterator iterator = this.reasoner.getSubClasses((OWLClassExpression)oWLClass, true);
        object2 = new HashMap();
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            Object object3 = (Node)iterator2.next();
            if (object3.isBottomNode()) continue;
            OWLClass oWLClass2 = (OWLClass)object3.getRepresentativeElement();
            object2.put(oWLClass2, object3);
            this.explainSubClass(oWLClass2, oWLClass);
        }
        for (Object object3 : object2.entrySet()) {
            this.explainClassHierarchy((OWLClass)object3.getKey(), (Node<OWLClass>)((Node)object3.getValue()), set);
        }
    }

    private TransactionAwareSingleExpGen getSingleExplanationGenerator() {
        if (this.useBlackBox) {
            if (this.options.getOption("inconsistent") != null) {
                if (!this.options.getOption("inconsistent").getValueAsBoolean()) {
                    return new BlackBoxExplanation(this.reasoner.getRootOntology(), (OWLReasonerFactory)PelletReasonerFactory.getInstance(), (OWLReasoner)this.reasoner);
                }
                this.output("WARNING: black method cannot be used to explain inconsistency. Switching to glass.");
                return new GlassBoxExplanation(this.reasoner);
            }
            return new BlackBoxExplanation(this.reasoner.getRootOntology(), (OWLReasonerFactory)PelletReasonerFactory.getInstance(), (OWLReasoner)this.reasoner);
        }
        return new GlassBoxExplanation(this.reasoner);
    }

    private void loadMethod() {
        String string = this.options.getOption("method").getValueAsString();
        if (string.equalsIgnoreCase("black")) {
            this.useBlackBox = true;
        } else if (string.equalsIgnoreCase("glass")) {
            this.useBlackBox = false;
        } else {
            throw new PelletCmdException("Unrecognized method: " + string);
        }
    }

    private void loadNames() {
        String string;
        this.name2 = null;
        this.name1 = null;
        this.name3 = null;
        PelletCmdOption pelletCmdOption = this.options.getOption("hierarchy");
        if (pelletCmdOption != null && pelletCmdOption.getValueAsBoolean()) {
            return;
        }
        pelletCmdOption = this.options.getOption("all-unsat");
        if (pelletCmdOption != null && pelletCmdOption.getValueAsBoolean()) {
            this.name1 = OWL.Nothing;
            return;
        }
        pelletCmdOption = this.options.getOption("inconsistent");
        if (pelletCmdOption != null && pelletCmdOption.getValueAsBoolean()) {
            if (this.useBlackBox) {
                throw new PelletCmdException("Black box method cannot be used to explain ontology inconsistency");
            }
            this.name1 = OWL.Thing;
            return;
        }
        pelletCmdOption = this.options.getOption("unsat");
        if (pelletCmdOption != null && (string = pelletCmdOption.getValueAsString()) != null) {
            this.name1 = OntologyUtils.findEntity(string, this.loader.getAllOntologies());
            if (this.name1 == null) {
                throw new PelletCmdException("Undefined entity: " + string);
            }
            if (!this.name1.isOWLClass()) {
                throw new PelletCmdException("Not a defined class: " + string);
            }
            if (this.name1.isTopEntity() && this.useBlackBox) {
                throw new PelletCmdException("Black box method cannot be used to explain unsatisfiability of owl:Thing");
            }
            return;
        }
        pelletCmdOption = this.options.getOption("subclass");
        if (pelletCmdOption != null && (string = pelletCmdOption.getValueAsString()) != null) {
            String[] stringArray = string.split(",");
            if (stringArray.length != 2) {
                throw new PelletCmdException("Invalid format for subclass option: " + string);
            }
            this.name1 = OntologyUtils.findEntity(stringArray[0], this.loader.getAllOntologies());
            this.name2 = OntologyUtils.findEntity(stringArray[1], this.loader.getAllOntologies());
            if (this.name1 == null) {
                throw new PelletCmdException("Undefined entity: " + stringArray[0]);
            }
            if (!this.name1.isOWLClass()) {
                throw new PelletCmdException("Not a defined class: " + stringArray[0]);
            }
            if (this.name2 == null) {
                throw new PelletCmdException("Undefined entity: " + stringArray[1]);
            }
            if (!this.name2.isOWLClass()) {
                throw new PelletCmdException("Not a defined class: " + stringArray[1]);
            }
            return;
        }
        pelletCmdOption = this.options.getOption("instance");
        if (pelletCmdOption != null && (string = pelletCmdOption.getValueAsString()) != null) {
            String[] stringArray = string.split(",");
            if (stringArray.length != 2) {
                throw new PelletCmdException("Invalid format for instance option: " + string);
            }
            this.name1 = OntologyUtils.findEntity(stringArray[0], this.loader.getAllOntologies());
            this.name2 = OntologyUtils.findEntity(stringArray[1], this.loader.getAllOntologies());
            if (this.name1 == null) {
                throw new PelletCmdException("Undefined entity: " + stringArray[0]);
            }
            if (!this.name1.isOWLNamedIndividual()) {
                throw new PelletCmdException("Not a defined individual: " + stringArray[0]);
            }
            if (this.name2 == null) {
                throw new PelletCmdException("Undefined entity: " + stringArray[1]);
            }
            if (!this.name2.isOWLClass()) {
                throw new PelletCmdException("Not a defined class: " + stringArray[1]);
            }
            return;
        }
        pelletCmdOption = this.options.getOption("property-value");
        if (pelletCmdOption != null && (string = pelletCmdOption.getValueAsString()) != null) {
            String[] stringArray = string.split(",");
            if (stringArray.length != 3) {
                throw new PelletCmdException("Invalid format for property-value option: " + string);
            }
            this.name1 = OntologyUtils.findEntity(stringArray[0], this.loader.getAllOntologies());
            this.name2 = OntologyUtils.findEntity(stringArray[1], this.loader.getAllOntologies());
            if (this.name1 == null) {
                throw new PelletCmdException("Undefined entity: " + stringArray[0]);
            }
            if (!this.name1.isOWLNamedIndividual()) {
                throw new PelletCmdException("Not an individual: " + stringArray[0]);
            }
            if (this.name2 == null) {
                throw new PelletCmdException("Undefined entity: " + stringArray[1]);
            }
            if (!this.name2.isOWLObjectProperty() && !this.name2.isOWLDataProperty()) {
                throw new PelletCmdException("Not a defined property: " + stringArray[1]);
            }
            if (this.name2.isOWLObjectProperty()) {
                this.name3 = OntologyUtils.findEntity(stringArray[2], this.loader.getAllOntologies());
                if (this.name3 == null) {
                    throw new PelletCmdException("Undefined entity: " + stringArray[2]);
                }
                if (!(this.name3 instanceof OWLIndividual)) {
                    throw new PelletCmdException("Not a defined individual: " + stringArray[2]);
                }
            } else {
                ManchesterOWLSyntaxEditorParser manchesterOWLSyntaxEditorParser = new ManchesterOWLSyntaxEditorParser(this.loader.getManager().getOWLDataFactory(), stringArray[2]);
                try {
                    this.name3 = manchesterOWLSyntaxEditorParser.parseConstant();
                }
                catch (ParserException parserException) {
                    throw new PelletCmdException("Not a valid literal: " + stringArray[2]);
                }
            }
            return;
        }
        this.name1 = OWL.Thing;
        if (this.useBlackBox) {
            throw new PelletCmdException("Black box method cannot be used to explain ontology inconsistency");
        }
    }

    private void printStatistics() throws OWLException {
        if (!this.verbose) {
            return;
        }
        Timer timer = this.timers.getTimer("explain");
        if (timer != null) {
            this.verbose("Subclass relations   : " + timer.getCount());
            this.verbose("Multiple explanations: " + this.multipleExpCount);
            this.verbose("Single explanation     ");
            this.verbose(" with multiple axioms: " + this.multiAxiomExpCount);
            this.verbose("Error explaining     : " + this.errorExpCount);
            this.verbose("Average time         : " + timer.getAverage() + "ms");
        }
    }

    private class RendererExplanationProgressMonitor
    implements ExplanationProgressMonitor {
        private ExplanationRenderer rend = new ManchesterSyntaxExplanationRenderer();
        private OWLAxiom axiom;
        private Set<Set<OWLAxiom>> setExplanations;
        private PrintWriter pw;

        private RendererExplanationProgressMonitor(OWLAxiom oWLAxiom) {
            this.axiom = oWLAxiom;
            this.pw = new PrintWriter(System.out);
            this.setExplanations = new HashSet<Set<OWLAxiom>>();
            try {
                this.rend.startRendering((Writer)this.pw);
            }
            catch (OWLException oWLException) {
                System.err.println("Error rendering explanation: " + (Object)((Object)oWLException));
            }
            catch (IOException iOException) {
                System.err.println("Error rendering explanation: " + iOException);
            }
        }

        public void foundExplanation(Set<OWLAxiom> set) {
            if (!this.setExplanations.contains(set)) {
                this.setExplanations.add(set);
                this.pw.flush();
                try {
                    this.rend.render(this.axiom, Collections.singleton(set));
                }
                catch (IOException iOException) {
                    System.err.println("Error rendering explanation: " + iOException);
                }
                catch (OWLException oWLException) {
                    System.err.println("Error rendering explanation: " + (Object)((Object)oWLException));
                }
            }
        }

        public boolean isCancelled() {
            return false;
        }

        public void foundAllExplanations() {
            try {
                this.rend.endRendering();
            }
            catch (OWLException oWLException) {
                System.err.println("Error rendering explanation: " + (Object)((Object)oWLException));
            }
            catch (IOException iOException) {
                System.err.println("Error rendering explanation: " + iOException);
            }
        }

        public void foundNoExplanations() {
            try {
                this.rend.render(this.axiom, Collections.emptySet());
                this.rend.endRendering();
            }
            catch (OWLException oWLException) {
                System.err.println("Error rendering explanation: " + (Object)((Object)oWLException));
            }
            catch (IOException iOException) {
                System.err.println("Error rendering explanation: " + iOException);
            }
        }
    }
}

