/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.exceptions.DatatypeReasonerException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

public class Literal
extends Node {
    private ATermAppl atermValue;
    private Object value;
    private boolean hasValue;
    private NodeMerge merge;
    private boolean clashed = false;

    public Literal(ATermAppl aTermAppl, ATermAppl aTermAppl2, ABox aBox, DependencySet dependencySet) {
        super(aTermAppl, aBox);
        if (aTermAppl2 != null) {
            boolean bl = this.hasValue = !aTermAppl2.getArgument(2).equals((Object)ATermUtils.NO_DATATYPE);
            if (this.hasValue) {
                try {
                    this.value = aBox.dtReasoner.getValue(aTermAppl2);
                }
                catch (InvalidLiteralException invalidLiteralException) {
                    String string = String.format("Attempt to create literal from invalid literal (%s): %s", aTermAppl2, invalidLiteralException.getMessage());
                    if (PelletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                        log.fine(string);
                        this.value = null;
                    }
                    log.severe(string);
                    throw new InternalReasonerException(string, invalidLiteralException);
                }
                catch (UnrecognizedDatatypeException unrecognizedDatatypeException) {
                    String string = String.format("Attempt to create literal from with unrecognized datatype (%s): %s", aTermAppl2, unrecognizedDatatypeException.getMessage());
                    log.severe(string);
                    throw new InternalReasonerException(string, unrecognizedDatatypeException);
                }
                if (this.value == null) {
                    this.depends.put(aTermAppl, dependencySet);
                }
            }
            this.atermValue = ATermUtils.makeValue((ATerm)aTermAppl2);
        } else {
            this.hasValue = false;
        }
    }

    public Literal(Literal literal, ABox aBox) {
        super(literal, aBox);
        this.atermValue = literal.atermValue;
        this.value = literal.value;
        this.hasValue = literal.hasValue;
    }

    @Override
    public DependencySet getNodeDepends() {
        return this.getDepends((ATerm)ATermUtils.TOP_LIT);
    }

    @Override
    public Node copyTo(ABox aBox) {
        return new Literal(this, aBox);
    }

    @Override
    public final boolean isLeaf() {
        return true;
    }

    @Override
    public int getNominalLevel() {
        return this.isNominal() ? 0 : Integer.MAX_VALUE;
    }

    @Override
    public boolean isNominal() {
        return this.value != null;
    }

    @Override
    public boolean isBlockable() {
        return this.value == null;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public boolean isIndividual() {
        return false;
    }

    @Override
    public boolean isDifferent(Node node) {
        if (super.isDifferent(node)) {
            return true;
        }
        Literal literal = (Literal)node;
        if (this.hasValue && literal.hasValue) {
            return this.value.getClass().equals(literal.value.getClass()) && !this.value.equals(literal.value);
        }
        return false;
    }

    @Override
    public boolean hasType(ATerm aTerm) {
        ATermAppl aTermAppl;
        if (aTerm instanceof ATermAppl && ATermUtils.isNominal(aTermAppl = (ATermAppl)aTerm)) {
            try {
                ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
                ATermAppl aTermAppl3 = this.abox.getDatatypeReasoner().getCanonicalRepresentation(aTermAppl2);
                if (!aTermAppl3.equals(aTermAppl2)) {
                    aTerm = ATermUtils.makeValue((ATerm)aTermAppl3);
                }
            }
            catch (InvalidLiteralException invalidLiteralException) {
                log.warning(String.format("hasType called with nominal using invalid literal ('%s'), returning false", invalidLiteralException.getMessage()));
                return false;
            }
            catch (UnrecognizedDatatypeException unrecognizedDatatypeException) {
                log.warning(String.format("hasType called with nominal using literal with unrecognized datatype ('%s'), returning false", unrecognizedDatatypeException.getMessage()));
                return false;
            }
        }
        if (super.hasType(aTerm)) {
            return true;
        }
        return this.hasValue && this.atermValue.equals(aTerm);
    }

    @Override
    public DependencySet getDifferenceDependency(Node node) {
        DependencySet dependencySet = null;
        if (this.isDifferent(node) && (dependencySet = (DependencySet)this.differents.get(node)) == null) {
            dependencySet = DependencySet.INDEPENDENT;
        }
        return dependencySet;
    }

    @Override
    public void addType(ATermAppl aTermAppl, DependencySet dependencySet) {
        ATermAppl aTermAppl2;
        if (this.hasType((ATerm)aTermAppl)) {
            return;
        }
        if (ATermUtils.isNot(aTermAppl) && ATermUtils.isNominal(aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0))) {
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl2.getArgument(0);
            Literal literal = this.abox.getLiteral((ATerm)aTermAppl3);
            if (literal == null) {
                literal = this.abox.addLiteral(aTermAppl3, dependencySet);
            }
            super.setDifferent(literal, dependencySet);
            return;
        }
        super.addType(aTermAppl, dependencySet);
        this.checkClash();
    }

    public void addAllTypes(Map<ATermAppl, DependencySet> map, DependencySet dependencySet) {
        for (Map.Entry<ATermAppl, DependencySet> entry : map.entrySet()) {
            ATermAppl aTermAppl = entry.getKey();
            if (this.hasType((ATerm)aTermAppl)) continue;
            DependencySet dependencySet2 = entry.getValue();
            super.addType(aTermAppl, dependencySet2.union(dependencySet, this.abox.doExplanation()));
        }
        this.checkClash();
    }

    @Override
    public boolean hasSuccessor(Node node) {
        return false;
    }

    @Override
    public final Literal getSame() {
        return (Literal)super.getSame();
    }

    @Override
    public ATermAppl getTerm() {
        return this.hasValue ? (ATermAppl)this.atermValue.getArgument(0) : null;
    }

    public String getLang() {
        return this.hasValue ? ((ATermAppl)((ATermAppl)this.atermValue.getArgument(0)).getArgument(1)).getName() : "";
    }

    public String getLexicalValue() {
        if (this.hasValue) {
            return this.value.toString();
        }
        return null;
    }

    void reportClash(Clash clash) {
        this.clashed = true;
        this.abox.setClash(clash);
    }

    /*
     * WARNING - void declaration
     */
    private void checkClash() {
        this.clashed = false;
        if (this.hasValue && this.value == null) {
            this.reportClash(Clash.invalidLiteral(this, this.getDepends((ATerm)this.name), this.getTerm()));
            return;
        }
        if (this.hasType((ATerm)ATermUtils.BOTTOM_LIT)) {
            this.reportClash(Clash.emptyDatatype(this, this.getDepends((ATerm)ATermUtils.BOTTOM_LIT)));
            if (this.abox.doExplanation()) {
                System.out.println("1) Literal clash dependency = " + this.abox.getClash());
            }
            return;
        }
        Set<ATermAppl> set = this.getTypes();
        DatatypeReasoner datatypeReasoner = this.abox.getDatatypeReasoner();
        try {
            if (this.hasValue) {
                if (!datatypeReasoner.isSatisfiable(set, this.value)) {
                    void object3;
                    ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
                    for (ATermAppl object2 : set) {
                        if (ATermUtils.TOP_LIT.equals(object2)) continue;
                        arrayList.add(object2);
                    }
                    ATermAppl[] aTermApplArray = arrayList.toArray(new ATermAppl[arrayList.size() - 1]);
                    DependencySet literal = DependencySet.EMPTY;
                    for (int i = 0; i < aTermApplArray.length; ++i) {
                        ATermAppl aTermAppl;
                        ATermAppl aTermAppl2;
                        DependencySet dependencySet = object3.union(this.getDepends((ATerm)aTermApplArray[i]), this.abox.doExplanation());
                        if (!this.abox.doExplanation() || (aTermAppl2 = datatypeReasoner.getDefinition(aTermAppl = ATermUtils.isNot(aTermApplArray[i]) ? (ATermAppl)aTermApplArray[i].getArgument(0) : aTermApplArray[i])) == null) continue;
                        DependencySet dependencySet2 = dependencySet.union(Collections.singleton(ATermUtils.makeDatatypeDefinition(aTermAppl, aTermAppl2)), true);
                    }
                    this.reportClash(Clash.valueDatatype(this, (DependencySet)object3, (ATermAppl)this.atermValue.getArgument(0), aTermApplArray[0]));
                }
            } else if (datatypeReasoner.isSatisfiable(set)) {
                if (!datatypeReasoner.containsAtLeast(2, set)) {
                    void var5_19;
                    Object obj = datatypeReasoner.valueIterator(set).next();
                    ATermAppl aTermAppl = datatypeReasoner.getLiteral(obj);
                    Literal literal = this.abox.getLiteral((ATerm)aTermAppl);
                    if (literal == null) {
                        Literal literal2 = this.abox.addLiteral(aTermAppl);
                    }
                    DependencySet dependencySet = DependencySet.INDEPENDENT;
                    for (DependencySet dependencySet3 : this.depends.values()) {
                        dependencySet = dependencySet.union(dependencySet3, this.abox.doExplanation());
                    }
                    this.merge = new NodeMerge(this, (Node)var5_19, dependencySet);
                }
            } else {
                void var5_22;
                ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
                for (ATermAppl aTermAppl : set) {
                    if (ATermUtils.TOP_LIT.equals(aTermAppl)) continue;
                    arrayList.add(aTermAppl);
                }
                ATermAppl[] aTermApplArray = arrayList.toArray(new ATermAppl[arrayList.size() - 1]);
                DependencySet dependencySet = DependencySet.EMPTY;
                for (int i = 0; i < aTermApplArray.length; ++i) {
                    ATermAppl aTermAppl;
                    DependencySet dependencySet4 = var5_22.union(this.getDepends((ATerm)aTermApplArray[i]), this.abox.doExplanation());
                    if (!this.abox.doExplanation() || (aTermAppl = datatypeReasoner.getDefinition(aTermApplArray[i])) == null) continue;
                    DependencySet dependencySet5 = dependencySet4.union(Collections.singleton(ATermUtils.makeDatatypeDefinition(aTermApplArray[i], aTermAppl)), true);
                }
                this.reportClash(Clash.emptyDatatype(this, (DependencySet)var5_22, aTermApplArray));
            }
        }
        catch (DatatypeReasonerException datatypeReasonerException) {
            String string = "Unexcepted datatype reasoner exception: " + datatypeReasonerException.getMessage();
            log.severe(string);
            throw new InternalReasonerException(string, datatypeReasonerException);
        }
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean restore(int n) {
        Boolean bl = this.restorePruned(n);
        if (Boolean.FALSE.equals(bl)) {
            return bl;
        }
        boolean bl2 = Boolean.TRUE.equals(bl);
        bl2 |= super.restore(n);
        if (this.clashed) {
            this.checkClash();
        }
        return bl2;
    }

    @Override
    public final void prune(DependencySet dependencySet) {
        this.pruned = dependencySet;
    }

    @Override
    public void unprune(int n) {
        super.unprune(n);
        this.checkClash();
    }

    public String debugString() {
        return this.name + " = " + this.getTypes().toString();
    }

    public NodeMerge getMergeToConstant() {
        return this.merge;
    }

    public void clearMergeToConstant() {
        this.merge = null;
    }
}

