/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.model;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryParameters;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryResultImpl
implements QueryResult {
    private Collection<ResultBinding> bindings;
    private List<ATermAppl> resultVars;
    private Query query;
    private QueryParameters parameters;

    public QueryResultImpl(Query query) {
        this.query = query;
        this.parameters = query.getQueryParameters();
        this.resultVars = new ArrayList<ATermAppl>(query.getResultVars());
        this.bindings = query.isDistinct() ? new HashSet<ResultBinding>() : new ArrayList<ResultBinding>();
    }

    @Override
    public void add(ResultBinding resultBinding) {
        this.bindings.add(this.process(resultBinding));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QueryResultImpl queryResultImpl = (QueryResultImpl)object;
        if (this.bindings == null ? queryResultImpl.bindings != null : !this.bindings.equals(queryResultImpl.bindings)) {
            return false;
        }
        return !(this.resultVars == null ? queryResultImpl.resultVars != null : !this.resultVars.equals(queryResultImpl.resultVars));
    }

    @Override
    public List<ATermAppl> getResultVars() {
        return Collections.unmodifiableList(this.resultVars);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.bindings == null ? 0 : this.bindings.hashCode());
        n = 31 * n + (this.resultVars == null ? 0 : this.resultVars.hashCode());
        return n;
    }

    @Override
    public boolean isDistinct() {
        return this.bindings instanceof Set;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<ResultBinding> iterator() {
        return this.bindings.iterator();
    }

    @Override
    public int size() {
        return this.bindings.size();
    }

    public String toString() {
        return this.bindings.toString();
    }

    private ResultBinding process(ResultBinding resultBinding) {
        if (this.parameters == null) {
            return resultBinding;
        }
        int n = this.query.getResultVars().size();
        for (Map.Entry<ATermAppl, ATermAppl> entry : this.parameters.entrySet()) {
            ATermAppl aTermAppl = entry.getKey();
            ATermAppl aTermAppl2 = entry.getValue();
            if (n != 0 && !this.query.getResultVars().contains(aTermAppl)) continue;
            resultBinding.setValue(aTermAppl, aTermAppl2);
        }
        return resultBinding;
    }
}

