/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.AbstractABoxEngineWrapper;
import com.clarkparsia.pellet.sparqldl.engine.BindingIterator;
import com.clarkparsia.pellet.sparqldl.engine.LiteralIterator;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.QueryResultImpl;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.sparqldl.model.ResultBindingImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;

public class SimpleQueryEngine
extends AbstractABoxEngineWrapper {
    public static final Logger log = Logger.getLogger(QueryEngine.class.getName());

    @Override
    public boolean supports(Query query) {
        return true;
    }

    @Override
    public QueryResult execABoxQuery(Query query) {
        QueryResultImpl queryResultImpl = new QueryResultImpl(query);
        KnowledgeBase knowledgeBase = query.getKB();
        long l = knowledgeBase.getABox().stats.satisfiabilityCount;
        long l2 = knowledgeBase.getABox().stats.consistencyCount;
        if (query.getDistVars().isEmpty()) {
            if (QueryEngine.execBooleanABoxQuery(query)) {
                queryResultImpl.add(new ResultBindingImpl());
            }
        } else {
            boolean bl;
            Object object;
            Object object22;
            HashMap<ATermAppl, Set<ATermAppl>> hashMap = new HashMap<ATermAppl, Set<ATermAppl>>();
            for (Object object22 : query.getDistVarsForType(Query.VarType.INDIVIDUAL)) {
                object = query.rollUpTo((ATermAppl)object22, Collections.EMPTY_SET, false);
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Rolled up class " + object);
                }
                Set<ATermAppl> set = knowledgeBase.getInstances((ATermAppl)object);
                hashMap.put((ATermAppl)object22, set);
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer("Var bindings: " + hashMap);
            }
            BindingIterator bindingIterator = new BindingIterator(hashMap);
            object22 = query.getDistVarsForType(Query.VarType.LITERAL);
            object = query.getDistVarsForType(Query.VarType.INDIVIDUAL);
            boolean bl2 = bl = !object.containsAll((Collection<?>)object22);
            if (bl) {
                while (bindingIterator.hasNext()) {
                    ResultBinding resultBinding = (ResultBinding)bindingIterator.next();
                    LiteralIterator literalIterator = new LiteralIterator(query, resultBinding);
                    while (literalIterator.hasNext()) {
                        ResultBinding resultBinding2 = (ResultBinding)literalIterator.next();
                        boolean bl3 = QueryEngine.execBooleanABoxQuery(query.apply(resultBinding2));
                        if (!bl3) continue;
                        queryResultImpl.add(resultBinding2);
                    }
                }
            } else {
                while (bindingIterator.hasNext()) {
                    ResultBinding resultBinding = (ResultBinding)bindingIterator.next();
                    boolean bl4 = query.getDistVarsForType(Query.VarType.INDIVIDUAL).size() == 1 || QueryEngine.execBooleanABoxQuery(query.apply(resultBinding));
                    if (!bl4) continue;
                    queryResultImpl.add(resultBinding);
                }
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Results: " + queryResultImpl);
            log.fine("Total satisfiability operations: " + (knowledgeBase.getABox().stats.satisfiabilityCount - l));
            log.fine("Total consistency operations: " + (knowledgeBase.getABox().stats.consistencyCount - l2));
        }
        return queryResultImpl;
    }
}

