/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDate;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDateTime;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDTime;
import com.clarkparsia.pellet.rules.builtins.ComparisonTesters;
import com.clarkparsia.pellet.rules.builtins.Function;
import com.clarkparsia.pellet.rules.builtins.GeneralFunction;
import com.clarkparsia.pellet.rules.builtins.StringFunctionAdapter;
import com.clarkparsia.pellet.rules.builtins.StringToStringFunction;
import java.math.BigDecimal;
import javax.xml.datatype.XMLGregorianCalendar;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.utils.ATermUtils;

public class DateTimeOperators {
    public static final GeneralFunction date = new Date();
    public static final GeneralFunction dateTime = new DateTime();
    public static final Function dayTimeDuration = new StringFunctionAdapter(new Duration(Duration.DURATIONTYPE.DAYTIME), "http://www.w3.org/2001/XMLSchema#duration");
    public static final GeneralFunction time = new Time();
    public static final Function yearMonthDuration = new StringFunctionAdapter(new Duration(Duration.DURATIONTYPE.YEARMONTH), "http://www.w3.org/2001/XMLSchema#duration");

    private static boolean applicability(int n, int n2, boolean[] blArray) {
        if (blArray.length < n || blArray.length > n2) {
            return false;
        }
        if (blArray[0]) {
            return true;
        }
        for (int i = 1; i < blArray.length; ++i) {
            if (blArray[i]) continue;
            return false;
        }
        return true;
    }

    private static Literal[] argList(Literal[] literalArray) {
        Literal[] literalArray2 = new Literal[literalArray.length - 1];
        for (int i = 1; i < literalArray.length; ++i) {
            literalArray2[i - 1] = literalArray[i];
        }
        return literalArray2;
    }

    private static boolean checkValue(String string, Datatype<?> datatype) {
        try {
            datatype.getValue(ATermUtils.makeTypedLiteral(string, datatype.getName()));
            return true;
        }
        catch (InvalidLiteralException invalidLiteralException) {
            return false;
        }
    }

    private static Literal createDecimal(ABox aBox, Number number) {
        ATermAppl aTermAppl = ATermUtils.makeTypedLiteral(number.toString(), "http://www.w3.org/2001/XMLSchema#decimal");
        return aBox.addLiteral(aTermAppl);
    }

    private static Literal createInteger(ABox aBox, Number number) {
        ATermAppl aTermAppl = ATermUtils.makeTypedLiteral(number.toString(), "http://www.w3.org/2001/XMLSchema#integer");
        return aBox.addLiteral(aTermAppl);
    }

    private static boolean mergeResults(Literal[] literalArray, Literal[] literalArray2) {
        for (int i = 0; i < literalArray.length; ++i) {
            if (literalArray[i] == null) {
                if (literalArray2[i] == null) {
                    return false;
                }
                literalArray[i] = literalArray2[i];
                continue;
            }
            if (literalArray2[i] == null || ComparisonTesters.equal.test(new Literal[]{literalArray[i], literalArray2[i]})) continue;
            return false;
        }
        return true;
    }

    private static String pad(int n, String string) {
        while (string.length() < n) {
            string = "0" + string;
        }
        return string;
    }

    private static boolean restBound(Literal[] literalArray) {
        for (int i = 1; i < literalArray.length; ++i) {
            if (literalArray[i] != null) continue;
            return false;
        }
        return true;
    }

    private static String toDate(String string, String string2, String string3) {
        return DateTimeOperators.pad(4, string) + "-" + DateTimeOperators.pad(2, string2) + "-" + DateTimeOperators.pad(2, string3);
    }

    private static String toTime(String string, String string2, String string3) {
        String string4 = "";
        int n = string3.indexOf(46);
        if (n >= 0) {
            string4 = string3.substring(n);
            string3 = string3.substring(0, n);
        }
        return DateTimeOperators.pad(2, string) + ":" + DateTimeOperators.pad(2, string2) + ":" + DateTimeOperators.pad(2, string3) + string4;
    }

    private static String toTZ(int n) {
        if (n == 0) {
            return "Z";
        }
        return String.format("%+03d:02d", n / 60, n % 60);
    }

    private static class Time
    implements GeneralFunction,
    StringToStringFunction {
        StringFunctionAdapter allBound = new StringFunctionAdapter(this, "http://www.w3.org/2001/XMLSchema#time");

        private Time() {
        }

        @Override
        public boolean apply(ABox aBox, Literal[] literalArray) {
            if (DateTimeOperators.restBound(literalArray)) {
                Literal literal = this.allBound.apply(aBox, literalArray[0], DateTimeOperators.argList(literalArray));
                if (literal != null) {
                    if (literalArray[0] == null) {
                        literalArray[0] = literal;
                    }
                    return true;
                }
                return false;
            }
            if (literalArray[0].getValue() instanceof XMLGregorianCalendar) {
                XMLGregorianCalendar xMLGregorianCalendar = (XMLGregorianCalendar)literalArray[0].getValue();
                Literal[] literalArray2 = new Literal[5];
                literalArray2[0] = literalArray[0];
                literalArray2[1] = DateTimeOperators.createInteger(aBox, xMLGregorianCalendar.getHour());
                literalArray2[2] = DateTimeOperators.createInteger(aBox, xMLGregorianCalendar.getMinute());
                BigDecimal bigDecimal = xMLGregorianCalendar.getFractionalSecond();
                literalArray2[3] = DateTimeOperators.createDecimal(aBox, bigDecimal == null ? Integer.valueOf(xMLGregorianCalendar.getSecond()) : bigDecimal.add(BigDecimal.valueOf(xMLGregorianCalendar.getSecond())));
                if (xMLGregorianCalendar.getTimezone() != Integer.MIN_VALUE) {
                    literalArray2[4] = aBox.addLiteral(ATermUtils.makePlainLiteral(DateTimeOperators.toTZ(xMLGregorianCalendar.getTimezone())));
                }
                if (DateTimeOperators.mergeResults(literalArray, literalArray2)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String apply(String ... stringArray) {
            String string;
            if (stringArray.length < 3 || stringArray.length > 4) {
                return null;
            }
            String string2 = "";
            if (stringArray.length == 4) {
                string2 = stringArray[3];
            }
            if (!DateTimeOperators.checkValue(string = DateTimeOperators.toTime(stringArray[0], stringArray[1], stringArray[2]) + string2, XSDTime.getInstance())) {
                return null;
            }
            return string;
        }

        @Override
        public boolean isApplicable(boolean[] blArray) {
            return DateTimeOperators.applicability(4, 5, blArray);
        }
    }

    private static class Duration
    implements GeneralFunction,
    StringToStringFunction {
        private static final char[] SEP = new char[]{'Y', 'M', 'D', 'H', 'M', 'S'};
        private StringFunctionAdapter allBound;
        private DURATIONTYPE granularity;

        public Duration(DURATIONTYPE dURATIONTYPE) {
            this.granularity = dURATIONTYPE;
            this.allBound = new StringFunctionAdapter(this, "http://www.w3.org/2001/XMLSchema#duration");
        }

        @Override
        public boolean apply(ABox aBox, Literal[] literalArray) {
            if (DateTimeOperators.restBound(literalArray)) {
                Literal literal = this.allBound.apply(aBox, literalArray[0], DateTimeOperators.argList(literalArray));
                if (literal != null) {
                    if (literalArray[0] == null) {
                        literalArray[0] = literal;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public String apply(String ... stringArray) {
            StringBuffer stringBuffer;
            if (stringArray.length > SEP.length + this.granularity.start) {
                return null;
            }
            if (stringArray[0].charAt(0) != '-') {
                stringBuffer = new StringBuffer("P");
            } else {
                stringBuffer = new StringBuffer("-P");
                stringArray[0] = stringArray[0].substring(1);
            }
            boolean bl = false;
            int n = this.granularity.start;
            for (String string : stringArray) {
                if (string.length() > 0) {
                    if (n > 2 && !bl) {
                        bl = true;
                        stringBuffer.append('T');
                    }
                    stringBuffer.append(string);
                    stringBuffer.append(SEP[n]);
                }
                ++n;
            }
            return stringBuffer.toString();
        }

        @Override
        public boolean isApplicable(boolean[] blArray) {
            return DateTimeOperators.applicability(4, 5, blArray);
        }

        public static enum DURATIONTYPE {
            FULL(0, 5),
            YEARMONTH(0, 2),
            DAYTIME(2, 5);

            private int start;
            private int end;

            private DURATIONTYPE(int n2, int n3) {
                this.start = n2;
                this.end = n3;
            }
        }
    }

    private static class DateTime
    implements GeneralFunction,
    StringToStringFunction {
        StringFunctionAdapter allBound = new StringFunctionAdapter(this, "http://www.w3.org/2001/XMLSchema#dateTime");

        private DateTime() {
        }

        @Override
        public boolean apply(ABox aBox, Literal[] literalArray) {
            if (DateTimeOperators.restBound(literalArray)) {
                Literal literal = this.allBound.apply(aBox, literalArray[0], DateTimeOperators.argList(literalArray));
                if (literal != null) {
                    if (literalArray[0] == null) {
                        literalArray[0] = literal;
                    }
                    return true;
                }
                return false;
            }
            if (literalArray[0].getValue() instanceof XMLGregorianCalendar) {
                XMLGregorianCalendar xMLGregorianCalendar = (XMLGregorianCalendar)literalArray[0].getValue();
                Literal[] literalArray2 = new Literal[8];
                literalArray2[0] = literalArray[0];
                literalArray2[1] = DateTimeOperators.createInteger(aBox, xMLGregorianCalendar.getYear());
                literalArray2[2] = DateTimeOperators.createInteger(aBox, xMLGregorianCalendar.getMonth());
                literalArray2[3] = DateTimeOperators.createInteger(aBox, xMLGregorianCalendar.getDay());
                literalArray2[4] = DateTimeOperators.createInteger(aBox, xMLGregorianCalendar.getHour());
                literalArray2[5] = DateTimeOperators.createInteger(aBox, xMLGregorianCalendar.getMinute());
                BigDecimal bigDecimal = xMLGregorianCalendar.getFractionalSecond();
                literalArray2[6] = DateTimeOperators.createDecimal(aBox, bigDecimal == null ? Integer.valueOf(xMLGregorianCalendar.getSecond()) : bigDecimal.add(BigDecimal.valueOf(xMLGregorianCalendar.getSecond())));
                if (xMLGregorianCalendar.getTimezone() != Integer.MIN_VALUE) {
                    literalArray2[7] = aBox.addLiteral(ATermUtils.makePlainLiteral(DateTimeOperators.toTZ(xMLGregorianCalendar.getTimezone())));
                }
                if (DateTimeOperators.mergeResults(literalArray, literalArray2)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String apply(String ... stringArray) {
            String string;
            if (stringArray.length < 6 || stringArray.length > 7) {
                return null;
            }
            String string2 = "";
            if (stringArray.length == 7) {
                string2 = stringArray[6];
            }
            if (!DateTimeOperators.checkValue(string = DateTimeOperators.toDate(stringArray[0], stringArray[1], stringArray[2]) + "T" + DateTimeOperators.toTime(stringArray[3], stringArray[4], stringArray[5]) + string2, XSDDateTime.getInstance())) {
                return null;
            }
            return string;
        }

        @Override
        public boolean isApplicable(boolean[] blArray) {
            return DateTimeOperators.applicability(7, 8, blArray);
        }
    }

    private static class Date
    implements GeneralFunction,
    StringToStringFunction {
        StringFunctionAdapter allBound = new StringFunctionAdapter(this, "http://www.w3.org/2001/XMLSchema#date");

        private Date() {
        }

        @Override
        public boolean apply(ABox aBox, Literal[] literalArray) {
            Literal literal;
            if (literalArray[0] != null && literalArray[0].getValue() instanceof XMLGregorianCalendar) {
                XMLGregorianCalendar xMLGregorianCalendar = (XMLGregorianCalendar)literalArray[0].getValue();
                Literal[] literalArray2 = new Literal[]{literalArray[0], DateTimeOperators.createInteger(aBox, xMLGregorianCalendar.getYear()), DateTimeOperators.createInteger(aBox, xMLGregorianCalendar.getMonth()), DateTimeOperators.createInteger(aBox, xMLGregorianCalendar.getDay()), xMLGregorianCalendar.getTimezone() != Integer.MIN_VALUE ? aBox.addLiteral(ATermUtils.makePlainLiteral(DateTimeOperators.toTZ(xMLGregorianCalendar.getTimezone()))) : aBox.addLiteral(ATermUtils.makePlainLiteral(""))};
                if (DateTimeOperators.mergeResults(literalArray, literalArray2)) {
                    return true;
                }
            } else if (DateTimeOperators.restBound(literalArray) && (literal = this.allBound.apply(aBox, literalArray[0], DateTimeOperators.argList(literalArray))) != null) {
                if (literalArray[0] == null) {
                    literalArray[0] = literal;
                }
                return true;
            }
            return false;
        }

        @Override
        public String apply(String ... stringArray) {
            String string;
            if (stringArray.length < 3 || stringArray.length > 4) {
                return null;
            }
            String string2 = "";
            if (stringArray.length == 4) {
                string2 = stringArray[3];
            }
            if (!DateTimeOperators.checkValue(string = DateTimeOperators.toDate(stringArray[0], stringArray[1], stringArray[2]) + string2, XSDDate.getInstance())) {
                return null;
            }
            return string;
        }

        @Override
        public boolean isApplicable(boolean[] blArray) {
            return DateTimeOperators.applicability(4, 5, blArray);
        }
    }
}

