/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomObject;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.DefaultAtomObjectVisitor;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import java.util.Collection;
import java.util.HashSet;

public class VariableUtils {
    public static Collection<AtomDVariable> getDVars(RuleAtom ruleAtom) {
        VisitingDCollector visitingDCollector = new VisitingDCollector();
        for (AtomObject atomObject : ruleAtom.getAllArguments()) {
            atomObject.accept(visitingDCollector);
        }
        return visitingDCollector.getVariables();
    }

    public static Collection<AtomIVariable> getIVars(RuleAtom ruleAtom) {
        VisitingICollector visitingICollector = new VisitingICollector();
        for (AtomObject atomObject : ruleAtom.getAllArguments()) {
            atomObject.accept(visitingICollector);
        }
        return visitingICollector.getVariables();
    }

    public static Collection<AtomVariable> getVars(RuleAtom ruleAtom) {
        VisitingCollector visitingCollector = new VisitingCollector();
        for (AtomObject atomObject : ruleAtom.getAllArguments()) {
            atomObject.accept(visitingCollector);
        }
        return visitingCollector.getVariables();
    }

    public static boolean isVariable(AtomObject atomObject) {
        VisitingCollector visitingCollector = new VisitingCollector();
        atomObject.accept(visitingCollector);
        return visitingCollector.getVariables().size() == 1;
    }

    private static class VisitingICollector
    extends DefaultAtomObjectVisitor {
        private Collection<AtomIVariable> variables = new HashSet<AtomIVariable>();

        public Collection<AtomIVariable> getVariables() {
            return this.variables;
        }

        @Override
        public void visit(AtomIVariable atomIVariable) {
            this.variables.add(atomIVariable);
        }
    }

    private static class VisitingDCollector
    extends DefaultAtomObjectVisitor {
        private Collection<AtomDVariable> variables = new HashSet<AtomDVariable>();

        public Collection<AtomDVariable> getVariables() {
            return this.variables;
        }

        @Override
        public void visit(AtomDVariable atomDVariable) {
            this.variables.add(atomDVariable);
        }
    }

    private static class VisitingCollector
    extends DefaultAtomObjectVisitor {
        private Collection<AtomVariable> variables = new HashSet<AtomVariable>();

        public Collection<AtomVariable> getVariables() {
            return this.variables;
        }

        @Override
        public void visit(AtomDVariable atomDVariable) {
            this.variables.add(atomDVariable);
        }

        @Override
        public void visit(AtomIVariable atomIVariable) {
            this.variables.add(atomIVariable);
        }
    }
}

