/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.io;

import com.clarkparsia.owlapiv3.OWL;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.MultiValueMap;
import org.semanticweb.owlapi.io.OWLXMLOntologyFormat;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;

public class ModuleExtractorPersistence {
    public static final Logger log = Logger.getLogger(ModuleExtractorPersistence.class.getName());
    private static final String MODULE_BEGIN_KEYWORD = "MODULE";
    private static final String MODULE_END_KEYWORD = "END";
    private static final String CLASS_KEYWORD = "class";
    private static final String DATA_TYPE_KEYWORD = "datatype";
    private static final String INDIVIDUAL_KEYWORD = "individual";
    private static final String DATA_PROPERTY_KEYWORD = "dataproperty";
    private static final String OBJECT_PROPERTY_KEYWORD = "objectproperty";

    public static void saveAxioms(Collection<OWLAxiom> collection, OutputStream outputStream) throws IOException {
        try {
            OWLOntology oWLOntology = OWL.Ontology(collection);
            OWL.manager.saveOntology(oWLOntology, (OWLOntologyFormat)new OWLXMLOntologyFormat(), outputStream);
            outputStream.flush();
            OWL.manager.removeOntology(oWLOntology);
        }
        catch (OWLException oWLException) {
            log.log(Level.SEVERE, "A problem occurred during creation or saving the ontology with axioms for the ModuleExtractor", oWLException);
            throw new IOException("A problem occurred during creation or saving the ontology with axioms for the ModuleExtractor");
        }
    }

    private static String getTypeKeywordForEntity(OWLEntity oWLEntity) throws IllegalArgumentException {
        if (oWLEntity.isOWLClass()) {
            return CLASS_KEYWORD;
        }
        if (oWLEntity.isOWLDatatype()) {
            return DATA_TYPE_KEYWORD;
        }
        if (oWLEntity.isOWLNamedIndividual()) {
            return INDIVIDUAL_KEYWORD;
        }
        if (oWLEntity.isOWLDataProperty()) {
            return DATA_PROPERTY_KEYWORD;
        }
        if (oWLEntity.isOWLObjectProperty()) {
            return OBJECT_PROPERTY_KEYWORD;
        }
        throw new IllegalArgumentException("Unrecognized type of OWLEntity: " + oWLEntity.getClass());
    }

    private static String getModuleBegin(OWLEntity oWLEntity) {
        StringBuffer stringBuffer = new StringBuffer(MODULE_BEGIN_KEYWORD);
        stringBuffer.append(" ");
        stringBuffer.append(ModuleExtractorPersistence.getTypeKeywordForEntity(oWLEntity));
        stringBuffer.append(" ");
        stringBuffer.append((CharSequence)oWLEntity.getIRI());
        return stringBuffer.toString();
    }

    private static String getModuleMember(OWLEntity oWLEntity) {
        return ModuleExtractorPersistence.getTypeKeywordForEntity(oWLEntity) + " " + oWLEntity.getIRI();
    }

    private static String getModuleEnd() {
        return MODULE_END_KEYWORD;
    }

    public static void saveModules(MultiValueMap<OWLEntity, OWLEntity> multiValueMap, OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(outputStream);
        for (Map.Entry entry : multiValueMap.entrySet()) {
            OWLEntity oWLEntity = (OWLEntity)entry.getKey();
            Set set = (Set)entry.getValue();
            printWriter.println(ModuleExtractorPersistence.getModuleBegin(oWLEntity));
            for (OWLEntity oWLEntity2 : set) {
                printWriter.println(ModuleExtractorPersistence.getModuleMember(oWLEntity2));
            }
            printWriter.println(ModuleExtractorPersistence.getModuleEnd());
        }
        printWriter.flush();
    }

    public static OWLOntology loadAxiomOntology(InputStream inputStream) throws IOException {
        try {
            return OWL.manager.loadOntologyFromOntologyDocument(inputStream);
        }
        catch (OWLOntologyCreationException oWLOntologyCreationException) {
            log.log(Level.SEVERE, "Unable to create an ontology", oWLOntologyCreationException);
            throw new IOException("Unable to create an ontology");
        }
    }

    public static Collection<OWLAxiom> loadAxioms(InputStream inputStream) throws IOException {
        return ModuleExtractorPersistence.loadAxiomOntology(inputStream).getAxioms();
    }

    private static OWLEntity createEntity(String string, String string2) {
        if (CLASS_KEYWORD.equals(string)) {
            return OWL.Class(string2);
        }
        if (DATA_TYPE_KEYWORD.equals(string)) {
            return OWL.Datatype(string2);
        }
        if (INDIVIDUAL_KEYWORD.equals(string)) {
            return OWL.Individual(string2);
        }
        if (DATA_PROPERTY_KEYWORD.equals(string)) {
            return OWL.DataProperty(string2);
        }
        if (OBJECT_PROPERTY_KEYWORD.equals(string)) {
            return OWL.ObjectProperty(string2);
        }
        throw new IllegalArgumentException("Unrecognized type of OWLEntity in module " + string);
    }

    private static OWLEntity readModuleInformation(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreElements()) {
            throw new IOException("Premature end of line; module MODULE expected: " + string);
        }
        stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreElements()) {
            throw new IOException("Premature end of line; entity type information expected: " + string);
        }
        String string2 = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreElements()) {
            throw new IOException("Premature end of line; module URI expected: " + string);
        }
        String string3 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreElements()) {
            throw new IOException("Trailing tokens on the line: " + string);
        }
        return ModuleExtractorPersistence.createEntity(string2, string3);
    }

    private static OWLEntity readModuleMember(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreElements()) {
            throw new IOException("Premature end of line; entity type information expected: " + string);
        }
        String string2 = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreElements()) {
            throw new IOException("Premature end of line; module member URI expected: " + string);
        }
        String string3 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreElements()) {
            throw new IOException("Trailing tokens on the line: " + string);
        }
        return ModuleExtractorPersistence.createEntity(string2, string3);
    }

    private static boolean readModule(LineNumberReader lineNumberReader, MultiValueMap<OWLEntity, OWLEntity> multiValueMap) throws IOException {
        String string = null;
        string = lineNumberReader.readLine();
        if (string == null) {
            return false;
        }
        if (!string.startsWith(MODULE_BEGIN_KEYWORD)) {
            throw new IOException("Invalid information in the module file (line " + lineNumberReader.getLineNumber() + "). " + MODULE_BEGIN_KEYWORD + " expected.");
        }
        OWLEntity oWLEntity = ModuleExtractorPersistence.readModuleInformation(string.trim());
        boolean bl = false;
        HashSet<OWLEntity> hashSet = new HashSet<OWLEntity>();
        while ((string = lineNumberReader.readLine()) != null) {
            if (string.startsWith(MODULE_END_KEYWORD)) {
                bl = true;
                break;
            }
            hashSet.add(ModuleExtractorPersistence.readModuleMember(string.trim()));
        }
        if (!bl) {
            throw new IOException("Premature end of file; module information not terminated.");
        }
        multiValueMap.put(oWLEntity, hashSet);
        return true;
    }

    public static MultiValueMap<OWLEntity, OWLEntity> loadModules(InputStream inputStream) throws IOException {
        MultiValueMap<OWLEntity, OWLEntity> multiValueMap = new MultiValueMap<OWLEntity, OWLEntity>();
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
        while (ModuleExtractorPersistence.readModule(lineNumberReader, multiValueMap)) {
        }
        return multiValueMap;
    }
}

