/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import arq.cmdline.CmdARQ;
import arq.cmdline.ModVersion;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.base.file.FileFactory;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.objectfile.StringFile;
import com.hp.hpl.jena.tdb.solver.stats.Stats;
import com.hp.hpl.jena.tdb.solver.stats.StatsCollector;
import com.hp.hpl.jena.tdb.store.DatasetPrefixesTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.sys.DatasetControlNone;
import com.hp.hpl.jena.tdb.sys.SetupTDB;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.io.IndentedWriter;
import tdb.cmdline.CmdSub;
import tdb.cmdline.CmdTDB;
import tdb.cmdline.CmdTDBGraph;

public class tdbconfig
extends CmdSub {
    static final String CMD_CLEAN = "clean";
    static final String CMD_HELP = "help";
    static final String CMD_STATS = "stats";
    static final String CMD_NODES = "nodes";
    static final String CMD_INFO = "info";
    static final String CMD_PREFIXES = "prefixes";

    public static void main(String ... argv) {
        CmdTDB.init();
        new tdbconfig(argv).exec();
    }

    protected tdbconfig(String[] argv) {
        super(argv);
        super.addSubCommand(CMD_HELP, new CmdSub.Exec(){

            @Override
            public void exec(String[] argv) {
                new SubHelp(argv).mainRun();
            }
        });
        super.addSubCommand(CMD_STATS, new CmdSub.Exec(){

            @Override
            public void exec(String[] argv) {
                new SubStats(argv).mainRun();
            }
        });
        super.addSubCommand(CMD_NODES, new CmdSub.Exec(){

            @Override
            public void exec(String[] argv) {
                new SubNodes(argv).mainRun();
            }
        });
        super.addSubCommand(CMD_INFO, new CmdSub.Exec(){

            @Override
            public void exec(String[] argv) {
                new SubInfo(argv).mainRun();
            }
        });
        super.addSubCommand(CMD_PREFIXES, new CmdSub.Exec(){

            @Override
            public void exec(String[] argv) {
                new SubPrefixes(argv).mainRun();
            }
        });
    }

    static class SubInfo
    extends CmdTDB {
        public SubInfo(String ... argv) {
            super(argv);
        }

        protected String getSummary() {
            return "tdbconfig info";
        }

        protected void exec() {
            System.out.println("-- " + Utils.nowAsString() + " --");
            ModVersion v = new ModVersion(true);
            v.addClass(TDB.class);
            v.printVersionAndExit();
        }

        @Override
        protected String getCommandName() {
            return "tdbconfig info";
        }
    }

    static class SubNodes
    extends CmdTDB {
        public SubNodes(String ... argv) {
            super(argv);
        }

        protected String getSummary() {
            return "tdbconfig nodes";
        }

        protected void exec() {
            List args = this.positionals;
            for (String x : args) {
                System.out.println("**** Object File: " + x);
                StringFile objs = FileFactory.createStringFileDisk(x);
                objs.dump();
            }
        }

        @Override
        protected String getCommandName() {
            return "tdbconfig nodes";
        }
    }

    static class SubStats
    extends CmdTDBGraph {
        public SubStats(String ... argv) {
            super(argv);
        }

        protected String getSummary() {
            return "tdbconfig stats";
        }

        protected void exec() {
            GraphTDB graph = this.getGraph();
            StatsCollector stats = Stats.gatherTDB(graph);
            Stats.write(System.out, stats);
        }

        @Override
        protected String getCommandName() {
            return "tdbconfig stats";
        }
    }

    class SubHelp
    extends CmdARQ {
        public SubHelp(String ... argv) {
            super(argv);
        }

        protected String getSummary() {
            return null;
        }

        protected void exec() {
            IndentedWriter out = IndentedWriter.stdout;
            out.println((Object)"Sub-commands:");
            out.incIndent();
            for (String name : tdbconfig.this.subCommandNames()) {
                out.println((Object)name);
            }
            out.decIndent();
            out.flush();
        }

        protected String getCommandName() {
            return "tdbconfig help";
        }
    }

    static class SubPrefixes
    extends CmdTDB {
        public SubPrefixes(String ... argv) {
            super(argv);
        }

        protected String getSummary() {
            return "tdbconfig prefixes";
        }

        protected void exec() {
            Location location = this.getLocation();
            DatasetPrefixesTDB prefixes = SetupTDB.makePrefixes(location, new DatasetControlNone());
            for (String gn : prefixes.graphNames()) {
                System.out.println("Graph: " + gn);
                PrefixMapping pmap = prefixes.getPrefixMapping(gn);
                Map x = pmap.getNsPrefixMap();
                for (String k : x.keySet()) {
                    System.out.printf("  %-10s %s\n", k + ":", x.get(k));
                }
            }
        }
    }
}

