/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class NumberUtils {
    public static final int BYTE = 0;
    public static final int SHORT = 1;
    public static final int INT = 2;
    public static final int LONG = 3;
    public static final int INTEGER = 4;
    public static final int DECIMAL = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    private static final int TYPES = 8;
    public static final Byte BYTE_ZERO = 0;
    public static final Short SHORT_ZERO = 0;
    public static final Integer INT_ZERO = 0;
    public static final Long LONG_ZERO = 0L;
    public static final BigInteger INTEGER_ZERO = BigInteger.valueOf(0L);
    public static final BigDecimal DECIMAL_ZERO = BigDecimal.valueOf(0L);
    public static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    public static final Double DOUBLE_ZERO = 0.0;
    private static final List classes = Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, BigInteger.class, BigDecimal.class, Float.class, Double.class);
    private static final List names = Arrays.asList("Byte", "Short", "Integer", "Long", "BigInteger", "BigDecimal", "Float", "Double");
    private static final List zeros = Arrays.asList(BYTE_ZERO, SHORT_ZERO, INT_ZERO, LONG_ZERO, INTEGER_ZERO, DECIMAL_ZERO, FLOAT_ZERO, DOUBLE_ZERO);

    public static Number parseByte(String string) throws NumberFormatException {
        return NumberUtils.parse(string, 0);
    }

    public static Number parseShort(String string) throws NumberFormatException {
        return NumberUtils.parse(string, 1);
    }

    public static Number parseInt(String string) throws NumberFormatException {
        return NumberUtils.parse(string, 2);
    }

    public static Number parseLong(String string) throws NumberFormatException {
        return NumberUtils.parse(string, 3);
    }

    public static Number parseInteger(String string) throws NumberFormatException {
        return NumberUtils.parse(string, 4);
    }

    public static Number parseDecimal(String string) throws NumberFormatException {
        return NumberUtils.parse(string, 5);
    }

    public static Float parseFloat(String string) throws NumberFormatException {
        return (Float)NumberUtils.parse(string, 6);
    }

    public static Double parseDouble(String string) throws NumberFormatException {
        return (Double)NumberUtils.parse(string, 7);
    }

    public static Number parse(String string, int n) throws NumberFormatException {
        char c;
        if (0 > n || n >= 8) {
            throw new UnsupportedOperationException("Unknown numeric type " + n);
        }
        if (n == 6) {
            return Float.valueOf(string);
        }
        if (n == 7) {
            return Double.valueOf(string);
        }
        int n2 = 0;
        int n3 = string.length();
        if (n3 == 0) {
            throw new NumberFormatException("Empty string");
        }
        boolean bl = false;
        int n4 = 0;
        switch (string.charAt(n2)) {
            case '+': {
                n4 = 1;
                ++n2;
                break;
            }
            case '-': {
                bl = true;
                ++n2;
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                break;
            }
            default: {
                throw new NumberFormatException("Invalid char '" + string.charAt(n2) + "' in " + string);
            }
        }
        if (n2 == n3) {
            throw new NumberFormatException("Invalid number that has only sign " + (bl ? (char)'-' : '+'));
        }
        while (n2 < n3 && string.charAt(n2) == '0') {
            ++n2;
        }
        if (n2 == n3) {
            return BYTE_ZERO;
        }
        Object object = null;
        long l = 0L;
        long l2 = 0L;
        while (n2 < n3) {
            if ('0' <= (c = string.charAt(n2++)) && c <= '9') {
                l2 = bl ? 10L * l2 + (long)(48 - c) : 10L * l2 + (long)(c - 48);
                if (l2 < l != bl) {
                    int n5 = string.indexOf(46);
                    if (n5 == -1) {
                        object = new BigInteger(string.substring(n4));
                        break;
                    }
                    int n6 = n3;
                    while (n6 >= n5 && string.charAt(--n6) == '0') {
                    }
                    if (n6 <= n5) {
                        object = new BigInteger(string.substring(n4, n5));
                        break;
                    }
                    if (n6 != n3) {
                        object = new BigDecimal(string.substring(n4, n6));
                        break;
                    }
                    object = new BigDecimal(string.substring(n4));
                    break;
                }
                l = l2;
                continue;
            }
            if (c == '.') {
                int n7 = n3;
                int n8 = n2 - 1;
                while (n7 >= n8 && string.charAt(--n7) == '0') {
                }
                if (n7 <= n8) {
                    object = new BigInteger(string.substring(n4, n8));
                    break;
                }
                if (n7 != n3 - 1) {
                    string = string.substring(0, n7 + 1);
                    object = new BigDecimal(string.substring(n4));
                    break;
                }
                object = new BigDecimal(string.substring(n4));
                break;
            }
            throw new NumberFormatException("Invalid char '" + c + "' in " + string);
        }
        if (object == null) {
            object = -128L <= l2 && l2 <= 127L ? (Number)((byte)l2) : (Number)(-32768L <= l2 && l2 <= 32767L ? (Number)((short)l2) : (Number)(Integer.MIN_VALUE <= l2 && l2 <= Integer.MAX_VALUE ? (Number)((int)l2) : (Number)l2));
        }
        if (n < (c = classes.indexOf(object.getClass()))) {
            throw new NumberFormatException(string + " is not a valid " + names.get(n));
        }
        return object;
    }

    public static Number add(Number number, int n) {
        int n2 = classes.indexOf(number.getClass());
        switch (n2) {
            case 0: {
                return ((Byte)number).intValue() + n;
            }
            case 1: {
                return ((Short)number).intValue() + n;
            }
            case 2: {
                return (Integer)number + n;
            }
            case 3: {
                return (Long)number + (long)n;
            }
            case 4: {
                return ((BigInteger)number).add(BigInteger.valueOf(n));
            }
            case 5: {
                return ((BigDecimal)number).add(BigDecimal.valueOf(n));
            }
            case 6: {
                return Float.valueOf(((Float)number).floatValue() + (float)n * Float.MIN_VALUE);
            }
            case 7: {
                return (Double)number + (double)n * Double.MIN_VALUE;
            }
        }
        throw new IllegalArgumentException("Unknown number class " + number.getClass());
    }

    public static int getType(Number number) {
        return classes.indexOf(number.getClass());
    }

    public static String getTypeName(Number number) {
        if (number == null) {
            return "null";
        }
        return names.get(classes.indexOf(number.getClass())).toString();
    }

    private static BigDecimal convertToDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return new BigDecimal(number.toString());
    }

    public static int sign(Number number) {
        int n = classes.indexOf(number.getClass());
        Number number2 = (Number)zeros.get(n);
        return ((Comparable)((Object)number)).compareTo(number2);
    }

    public static int compare(Number number, Number number2) {
        int n;
        int n2 = classes.indexOf(number.getClass());
        if (n2 != (n = classes.indexOf(number2.getClass()))) {
            if (n2 > 5 || n > 5) {
                throw new IllegalArgumentException("Trying to compare incompatible values " + number + " " + number2);
            }
            if (n2 == 5 || n == 5) {
                return NumberUtils.convertToDecimal(number).compareTo(NumberUtils.convertToDecimal(number2));
            }
            if (n2 < n) {
                return -NumberUtils.sign(number2);
            }
            return NumberUtils.sign(number);
        }
        switch (n2) {
            case 0: {
                return ((Byte)number).compareTo((Byte)number2);
            }
            case 1: {
                return ((Short)number).compareTo((Short)number2);
            }
            case 2: {
                return ((Integer)number).compareTo((Integer)number2);
            }
            case 3: {
                return ((Long)number).compareTo((Long)number2);
            }
            case 4: {
                return ((BigInteger)number).compareTo((BigInteger)number2);
            }
            case 5: {
                return ((BigDecimal)number).compareTo((BigDecimal)number2);
            }
            case 6: {
                return ((Float)number).compareTo((Float)number2);
            }
            case 7: {
                return ((Double)number).compareTo((Double)number2);
            }
        }
        throw new IllegalArgumentException("Unknown number class " + number.getClass());
    }

    public static int getTotalDigits(Number number) {
        int n = NumberUtils.getType(number);
        String string = number.toString();
        int n2 = string.length();
        if (n >= 5 && string.indexOf(46) != -1) {
            --n2;
        }
        return n2;
    }

    public static int getFractionDigits(Number number) {
        int n = NumberUtils.getType(number);
        int n2 = 0;
        if (n >= 5) {
            String string = number.toString();
            n2 = string.length() - string.indexOf(".");
        }
        return n2;
    }

    public static void test(String string, int n, Number number) {
        Number number2 = null;
        try {
            number2 = NumberUtils.parse(string, n);
            if (number2.equals(number) && number2.getClass().equals(number.getClass())) {
                System.out.println(string + " -> " + number2 + " (" + NumberUtils.getTypeName(number2) + ") = " + number + " (" + NumberUtils.getTypeName(number) + ")");
            } else {
                System.err.println(string + " -> " + number2 + " (" + NumberUtils.getTypeName(number2) + ") != " + number + " (" + NumberUtils.getTypeName(number) + ")");
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println(string + " -> " + number2 + " (" + NumberUtils.getTypeName(number2) + ") != " + number + " (" + NumberUtils.getTypeName(number) + ")");
            runtimeException.printStackTrace();
        }
    }

    public static void test(String string, int n, String string2, int n2, int n3) {
        try {
            Number number = NumberUtils.parse(string, n);
            Number number2 = NumberUtils.parse(string2, n2);
            int n4 = NumberUtils.compare(number, number2);
            if (n4 != n3) {
                throw new RuntimeException(string + " " + string2 + " " + n4 + " " + n3);
            }
            String string3 = n4 < 0 ? "<" : (n4 == 0 ? "=" : ">");
            System.out.println(number + " (" + NumberUtils.getTypeName(number) + ") " + string3 + " " + number2 + " (" + NumberUtils.getTypeName(number2) + ")");
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        BigInteger bigInteger = new BigInteger("9223372036854775807");
        bigInteger = bigInteger.add(BigInteger.ONE);
        BigInteger bigInteger2 = new BigInteger("10");
        bigInteger = bigInteger.add(bigInteger2);
        bigInteger = bigInteger.add(bigInteger);
        NumberUtils.test("+" + bigInteger.toString(), 5, bigInteger);
        BigDecimal bigDecimal = new BigDecimal(bigInteger);
        bigDecimal = bigDecimal.divide(new BigDecimal("2346365"), 7, 2);
        NumberUtils.test(bigDecimal.toString(), 5, bigDecimal);
        NumberUtils.test("10", 4, "10.1", 5, -1);
        NumberUtils.test("120", 4, "130", 4, -1);
        NumberUtils.test("10.1", 5, "130", 5, -1);
    }
}

