/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public abstract class DiscreteInterval<T extends Number, U extends DiscreteInterval<T, U>> {
    protected static final NullSemantics GREATEST;
    protected static final NullSemantics LEAST;
    protected static final NullSemantics NA;
    private static final Logger log;
    private final T lower;
    private final T upper;

    public DiscreteInterval(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        this.lower = t;
        this.upper = t;
    }

    public DiscreteInterval(T t, T t2) {
        if (!this.valid(t)) {
            throw new IllegalArgumentException();
        }
        if (!this.valid(t2)) {
            throw new IllegalArgumentException();
        }
        int n = this.compare(t, LEAST, t2, GREATEST);
        if (n > 0) {
            String string = String.format("Lower bound of interval (%s) should not be greater than upper bound of interval (%s)", t, t2);
            log.severe(string);
            throw new IllegalArgumentException(string);
        }
        this.lower = t;
        this.upper = t2;
    }

    public boolean canUnionWith(U u) {
        int n = this.compare(this.getLower(), LEAST, ((DiscreteInterval)u).getLower(), LEAST);
        int n2 = this.compare(this.getUpper(), GREATEST, ((DiscreteInterval)u).getUpper(), GREATEST);
        if (n <= 0) {
            if (n2 < 0) {
                if (this.compare(this.getUpper(), GREATEST, ((DiscreteInterval)u).getLower(), LEAST) < 0) {
                    return this.equal(this.increment(this.getUpper()), ((DiscreteInterval)u).getLower());
                }
                return true;
            }
            return true;
        }
        if (n2 > 0) {
            if (this.compare(this.getLower(), LEAST, ((DiscreteInterval)u).getUpper(), GREATEST) > 0) {
                return this.equal(this.increment(((DiscreteInterval)u).getUpper()), this.getLower());
            }
            return true;
        }
        return true;
    }

    protected abstract U cast(DiscreteInterval<T, U> var1);

    protected abstract int compare(T var1, NullSemantics var2, T var3, NullSemantics var4);

    public boolean contains(T t) {
        if (!this.valid(t)) {
            throw new IllegalArgumentException();
        }
        int n = this.compare(this.getLower(), LEAST, t, NA);
        if (n > 0) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        int n2 = this.compare(this.getUpper(), GREATEST, t, NA);
        return n2 >= 0;
    }

    protected abstract U create(T var1, T var2);

    protected abstract T decrement(T var1);

    protected abstract boolean equal(T var1, T var2);

    public abstract boolean equals(Object var1);

    public T getLower() {
        return this.lower;
    }

    public T getUpper() {
        return this.upper;
    }

    public U greater(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (!this.valid(t)) {
            throw new IllegalArgumentException();
        }
        if (this.compare(this.getLower(), LEAST, t, NA) > 0) {
            return this.cast(this);
        }
        if (this.compare(this.getUpper(), GREATEST, t, NA) <= 0) {
            return null;
        }
        return this.create(this.increment(t), this.getUpper());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getLower() == null ? 0 : this.getLower().hashCode());
        n = 31 * n + (this.getUpper() == null ? 0 : this.getUpper().hashCode());
        return n;
    }

    protected abstract T increment(T var1);

    public U intersection(U u) {
        int n = this.compare(this.getLower(), LEAST, ((DiscreteInterval)u).getLower(), LEAST);
        int n2 = this.compare(this.getUpper(), GREATEST, ((DiscreteInterval)u).getUpper(), GREATEST);
        if (n <= 0) {
            if (n2 < 0) {
                if (this.compare(this.getUpper(), GREATEST, ((DiscreteInterval)u).getLower(), LEAST) < 0) {
                    return null;
                }
                return this.create(((DiscreteInterval)u).getLower(), this.getUpper());
            }
            return u;
        }
        if (n2 > 0) {
            if (this.compare(this.getLower(), LEAST, ((DiscreteInterval)u).getUpper(), GREATEST) > 0) {
                return null;
            }
            return this.create(this.getLower(), ((DiscreteInterval)u).getUpper());
        }
        return this.cast(this);
    }

    public boolean isFinite() {
        return this.getLower() != null && this.getUpper() != null;
    }

    public U less(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (!this.valid(t)) {
            throw new IllegalArgumentException();
        }
        if (this.compare(this.getUpper(), GREATEST, t, NA) < 0) {
            return this.cast(this);
        }
        if (this.compare(this.getLower(), LEAST, t, NA) >= 0) {
            return null;
        }
        return this.create(this.getLower(), this.decrement(t));
    }

    public List<U> remove(U u) {
        Object var3_7;
        Object t;
        int n = this.compare(this.getLower(), LEAST, ((DiscreteInterval)u).getLower(), LEAST);
        int n2 = this.compare(this.getLower(), LEAST, ((DiscreteInterval)u).getUpper(), GREATEST);
        int n3 = this.compare(this.getUpper(), GREATEST, ((DiscreteInterval)u).getLower(), LEAST);
        int n4 = this.compare(this.getUpper(), GREATEST, ((DiscreteInterval)u).getUpper(), GREATEST);
        if (n < 0) {
            if (n3 < 0) {
                t = this.cast(this);
                var3_7 = null;
            } else {
                t = this.create(this.getLower(), this.decrement(((DiscreteInterval)u).getLower()));
                var3_7 = n4 <= 0 ? null : this.create(this.increment(((DiscreteInterval)u).getUpper()), this.getUpper());
            }
        } else if (n2 > 0) {
            t = null;
            var3_7 = this.cast(this);
        } else if (n4 <= 0) {
            t = null;
            var3_7 = null;
        } else {
            t = null;
            var3_7 = this.create(this.increment(((DiscreteInterval)u).getUpper()), this.getUpper());
        }
        if (t == null) {
            if (var3_7 == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(var3_7);
        }
        if (var3_7 == null) {
            return Collections.singletonList(t);
        }
        List<DiscreteInterval> list = Arrays.asList(t, var3_7);
        return list;
    }

    public abstract Number size();

    public List<U> union(U u) {
        Object t;
        U u2;
        int n = this.compare(this.getLower(), LEAST, ((DiscreteInterval)u).getLower(), LEAST);
        int n2 = this.compare(this.getLower(), LEAST, ((DiscreteInterval)u).getUpper(), GREATEST);
        int n3 = this.compare(this.getUpper(), GREATEST, ((DiscreteInterval)u).getLower(), LEAST);
        int n4 = this.compare(this.getUpper(), GREATEST, ((DiscreteInterval)u).getUpper(), GREATEST);
        if (n < 0) {
            if (n3 < 0) {
                u2 = this.cast(this);
                t = u;
            } else {
                t = null;
                u2 = n4 < 0 ? this.create(this.getLower(), ((DiscreteInterval)u).getUpper()) : this.cast(this);
            }
        } else if (n2 > 0) {
            u2 = u;
            t = this.cast(this);
        } else {
            t = null;
            u2 = n4 <= 0 ? u : this.create(((DiscreteInterval)u).getLower(), this.getUpper());
        }
        if (u2 == null) {
            if (t == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(t);
        }
        if (t == null) {
            return Collections.singletonList(u2);
        }
        List<DiscreteInterval> list = Arrays.asList(u2, t);
        return list;
    }

    protected abstract boolean valid(T var1);

    public Iterator<T> valueIterator() {
        if (this.getLower() == null) {
            if (this.getUpper() == null) {
                throw new IllegalStateException();
            }
            return new ValueIterator(this, this.getUpper(), this.getLower(), false);
        }
        return new ValueIterator(this, this.getLower(), this.getUpper(), true);
    }

    public String toString() {
        return String.format("[%s,%s]", this.getLower() != null ? this.getLower() : "-Inf", this.getUpper() != null ? this.getUpper() : "+Inf");
    }

    static {
        log = Logger.getLogger(DiscreteInterval.class.getCanonicalName());
        GREATEST = NullSemantics.GREATEST;
        LEAST = NullSemantics.LEAST;
        NA = NullSemantics.NA;
    }

    public class ValueIterator
    implements Iterator<T> {
        private final T last;
        private T next;
        private final boolean increment;
        final /* synthetic */ DiscreteInterval this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public ValueIterator(T t, T t2, boolean bl) {
            this.this$0 = (DiscreteInterval)n;
            if (t == null) {
                throw new NullPointerException();
            }
            this.next = t;
            this.last = t2;
            this.increment = bl;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            Object t = this.next;
            this.next = this.this$0.getUpper() != null && this.this$0.equal(this.next, this.last) ? null : (this.increment ? this.this$0.increment(this.next) : this.this$0.decrement(this.next));
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static enum NullSemantics {
        GREATEST,
        LEAST,
        NA;

    }
}

