/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.jena;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.resultset.XMLInput;
import com.hp.hpl.jena.util.FileManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public class JenaIOUtils {
    public static ResultSet parseResultSet(String string) throws IOException {
        if (string.endsWith("srx")) {
            return ResultSetFactory.fromXML((InputStream)URI.create(string).toURL().openStream());
        }
        if (string.endsWith("ttl")) {
            return ResultSetFactory.fromRDF((Model)FileManager.get().loadModel(string));
        }
        if (string.endsWith("rdf")) {
            return ResultSetFactory.fromRDF((Model)FileManager.get().loadModel(string));
        }
        throw new RuntimeException("Unknown format.");
    }

    public static boolean parseAskResult(String string) throws FileNotFoundException {
        if (string.endsWith("srx")) {
            return XMLInput.booleanFromXML((InputStream)new FileInputStream(string.substring(5)));
        }
        if (string.endsWith("ttl") || string.endsWith("rdf")) {
            return FileManager.get().loadModel(string.substring(5)).getProperty(null, ResourceFactory.createProperty((String)"http://www.w3.org/2001/sw/DataAccess/tests/result-set#boolean")).getBoolean();
        }
        throw new RuntimeException("Unknown format.");
    }

    public static RDFFormatType fileType(String string) {
        if (string.endsWith(".n3")) {
            return RDFFormatType.N3;
        }
        if (string.endsWith(".ttl")) {
            return RDFFormatType.TURTLE;
        }
        return RDFFormatType.RDFXML;
    }

    public static enum RDFFormatType {
        N3("N3"),
        RDFXML("RDF/XML"),
        TURTLE("TURTLE"),
        NTRIPLE("N-TRIPLE");

        private String jenaName;

        private RDFFormatType(String string2) {
            this.jenaName = string2;
        }

        public String jenaName() {
            return this.jenaName;
        }
    }
}

