/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.DNF;
import com.clarkparsia.pellet.datatypes.DataRange;
import com.clarkparsia.pellet.datatypes.DataValueEnumeration;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.EmptyDataRange;
import com.clarkparsia.pellet.datatypes.InfiniteNamedDatatype;
import com.clarkparsia.pellet.datatypes.NamedDataRangeExpander;
import com.clarkparsia.pellet.datatypes.NamedDatatype;
import com.clarkparsia.pellet.datatypes.NegatedDataRange;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.UnionDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.datatypes.types.bool.XSDBoolean;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDate;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDateTime;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDDateTimeStamp;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGDay;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGMonth;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGMonthDay;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGYear;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDGYearMonth;
import com.clarkparsia.pellet.datatypes.types.datetime.XSDTime;
import com.clarkparsia.pellet.datatypes.types.duration.XSDDuration;
import com.clarkparsia.pellet.datatypes.types.floating.XSDDouble;
import com.clarkparsia.pellet.datatypes.types.floating.XSDFloat;
import com.clarkparsia.pellet.datatypes.types.real.OWLRational;
import com.clarkparsia.pellet.datatypes.types.real.OWLReal;
import com.clarkparsia.pellet.datatypes.types.real.XSDByte;
import com.clarkparsia.pellet.datatypes.types.real.XSDDecimal;
import com.clarkparsia.pellet.datatypes.types.real.XSDInt;
import com.clarkparsia.pellet.datatypes.types.real.XSDInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDLong;
import com.clarkparsia.pellet.datatypes.types.real.XSDNegativeInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDNonNegativeInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDNonPositiveInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDPositiveInteger;
import com.clarkparsia.pellet.datatypes.types.real.XSDShort;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedByte;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedInt;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedLong;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedShort;
import com.clarkparsia.pellet.datatypes.types.text.RDFPlainLiteral;
import com.clarkparsia.pellet.datatypes.types.text.XSDLanguage;
import com.clarkparsia.pellet.datatypes.types.text.XSDNCName;
import com.clarkparsia.pellet.datatypes.types.text.XSDNMToken;
import com.clarkparsia.pellet.datatypes.types.text.XSDName;
import com.clarkparsia.pellet.datatypes.types.text.XSDNormalizedString;
import com.clarkparsia.pellet.datatypes.types.text.XSDString;
import com.clarkparsia.pellet.datatypes.types.text.XSDToken;
import com.clarkparsia.pellet.datatypes.types.uri.XSDAnyURI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.utils.ATermUtils;

public class DatatypeReasonerImpl
implements DatatypeReasoner {
    private static final Map<ATermAppl, Datatype<?>> coreDatatypes;
    private static final DataRange<?> EMPTY_RANGE;
    private static final Logger log;
    private static final DataRange<?> TRIVIALLY_SATISFIABLE;
    private final Set<ATermAppl> declaredUndefined = new HashSet<ATermAppl>();
    private final NamedDataRangeExpander expander = new NamedDataRangeExpander();
    private final Map<ATermAppl, ATermAppl> namedDataRanges = new HashMap<ATermAppl, ATermAppl>();

    private static <T> DataValueEnumeration<? extends T> findSmallestEnumeration(Collection<DataValueEnumeration<? extends T>> collection) {
        DataValueEnumeration<T> dataValueEnumeration = null;
        int n = Integer.MAX_VALUE;
        for (DataValueEnumeration<T> dataValueEnumeration2 : collection) {
            DataValueEnumeration<T> dataValueEnumeration3 = dataValueEnumeration2;
            int n2 = dataValueEnumeration3.size();
            if (n2 >= n) continue;
            dataValueEnumeration = dataValueEnumeration3;
            n = n2;
        }
        return dataValueEnumeration;
    }

    private static final ATermAppl getDatatypeName(ATermAppl aTermAppl) {
        if (!ATermUtils.isLiteral(aTermAppl)) {
            log.severe("Method expected an ATermAppl literal as an argument");
            throw new IllegalArgumentException("Method expected an ATermAppl literal as an argument");
        }
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(2);
        if (ATermUtils.EMPTY.equals(aTermAppl2)) {
            log.severe("Untyped literals not supported by this datatype reasoner");
            throw new IllegalArgumentException("Untyped literals not supported by this datatype reasoner");
        }
        return aTermAppl2;
    }

    private static int inequalityCount(Set<Integer>[] setArray, int n) {
        Set<Integer> set = setArray[n];
        return set == null ? 0 : set.size();
    }

    private static <T> void partitionDConjunction(Collection<DataRange<? extends T>> collection, Set<DataValueEnumeration<? extends T>> set, Set<DataValueEnumeration<? extends T>> set2, Set<RestrictedDatatype<? extends T>> set3, Set<RestrictedDatatype<? extends T>> set4) {
        for (DataRange<T> dataRange : collection) {
            if (dataRange instanceof DataValueEnumeration) {
                set.add((DataValueEnumeration)dataRange);
                continue;
            }
            if (dataRange instanceof RestrictedDatatype) {
                set3.add((RestrictedDatatype)dataRange);
                continue;
            }
            if (dataRange instanceof NegatedDataRange) {
                DataRange dataRange2 = ((NegatedDataRange)dataRange).getDataRange();
                if (dataRange2 instanceof DataValueEnumeration) {
                    set2.add((DataValueEnumeration)dataRange2);
                    continue;
                }
                if (dataRange2 instanceof RestrictedDatatype) {
                    set4.add((RestrictedDatatype)dataRange2);
                    continue;
                }
                if (dataRange == TRIVIALLY_SATISFIABLE) continue;
                log.warning("Unknown datatype: " + dataRange);
                continue;
            }
            if (dataRange == TRIVIALLY_SATISFIABLE) continue;
            log.warning("Unknown datatype: " + dataRange);
        }
    }

    private static boolean removeInequalities(Set<Integer>[] setArray, int n) {
        Set<Integer> set = setArray[n];
        if (set == null) {
            return false;
        }
        for (Integer n2 : set) {
            Set<Integer> set2 = setArray[n2];
            if (set2 == null) {
                throw new IllegalStateException();
            }
            if (set2.remove(n)) continue;
            throw new IllegalStateException();
        }
        return true;
    }

    private boolean containedIn(Object object, ATermAppl aTermAppl) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        if (ATermUtils.isAnd(aTermAppl)) {
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            while (!aTermList.isEmpty()) {
                if (!this.getDataRange((ATermAppl)aTermList.getFirst()).contains(object)) {
                    return false;
                }
                aTermList = aTermList.getNext();
            }
            return true;
        }
        return this.getDataRange(aTermAppl).contains(object);
    }

    @Override
    public boolean containsAtLeast(int n, Collection<ATermAppl> collection) throws UnrecognizedDatatypeException, InvalidConstrainingFacetException, InvalidLiteralException {
        ATermAppl aTermAppl = ATermUtils.makeAnd(ATermUtils.makeList(collection));
        ATermAppl aTermAppl2 = DNF.dnf(this.expander.expand(aTermAppl, this.namedDataRanges));
        if (ATermUtils.isOr(aTermAppl2)) {
            ArrayList arrayList = new ArrayList();
            Object object = (ATermList)aTermAppl2.getArgument(0);
            while (!object.isEmpty()) {
                DataRange<?> dataRange = this.normalizeVarRanges((ATermAppl)object.getFirst());
                if (!dataRange.isEmpty()) {
                    arrayList.add(dataRange);
                }
                object = object.getNext();
            }
            object = this.getDisjunction(arrayList);
            return object.containsAtLeast(n);
        }
        DataRange<?> dataRange = this.normalizeVarRanges(aTermAppl2);
        return dataRange.containsAtLeast(n);
    }

    @Override
    public boolean declare(ATermAppl aTermAppl) {
        if (this.isDeclared(aTermAppl)) {
            return false;
        }
        this.declaredUndefined.add(aTermAppl);
        return true;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl aTermAppl2 = DatatypeReasonerImpl.getDatatypeName(aTermAppl);
        Datatype<?> datatype = this.getDatatype(aTermAppl2);
        if (datatype == null) {
            switch (PelletOptions.UNDEFINED_DATATYPE_HANDLING) {
                case INFINITE_STRING: {
                    return aTermAppl;
                }
                case EMPTY: {
                    throw new InvalidLiteralException(aTermAppl2, ATermUtils.getLiteralValue(aTermAppl));
                }
                case EXCEPTION: {
                    throw new UnrecognizedDatatypeException(aTermAppl2);
                }
            }
            throw new IllegalStateException();
        }
        return datatype.getCanonicalRepresentation(aTermAppl);
    }

    private DataRange<?> getDataRange(ATermAppl aTermAppl) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        if (aTermAppl.equals(ATermUtils.TOP_LIT)) {
            return TRIVIALLY_SATISFIABLE;
        }
        if (aTermAppl.equals(ATermUtils.BOTTOM_LIT)) {
            return EMPTY_RANGE;
        }
        if (ATermUtils.isPrimitive(aTermAppl)) {
            InfiniteNamedDatatype infiniteNamedDatatype = this.getDatatype(aTermAppl);
            if (infiniteNamedDatatype == null) {
                switch (PelletOptions.UNDEFINED_DATATYPE_HANDLING) {
                    case INFINITE_STRING: {
                        infiniteNamedDatatype = InfiniteNamedDatatype.get(aTermAppl);
                        break;
                    }
                    case EMPTY: {
                        return EMPTY_RANGE;
                    }
                    case EXCEPTION: {
                        throw new UnrecognizedDatatypeException(aTermAppl);
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            return infiniteNamedDatatype.asDataRange();
        }
        if (ATermUtils.isRestrictedDatatype(aTermAppl)) {
            ATermList aTermList;
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            DataRange<?> dataRange = this.getDataRange(aTermAppl2);
            if (!(dataRange instanceof RestrictedDatatype)) {
                throw new InvalidConstrainingFacetException(aTermAppl2, dataRange);
            }
            RestrictedDatatype restrictedDatatype = (RestrictedDatatype)dataRange;
            ATermList aTermList2 = aTermList = (ATermList)aTermAppl.getArgument(1);
            while (!aTermList2.isEmpty()) {
                Object object;
                ATermAppl aTermAppl3 = (ATermAppl)aTermList2.getFirst();
                ATermAppl aTermAppl4 = (ATermAppl)aTermAppl3.getArgument(0);
                ATermAppl aTermAppl5 = (ATermAppl)aTermAppl3.getArgument(1);
                try {
                    object = this.getValue(aTermAppl5);
                }
                catch (InvalidLiteralException invalidLiteralException) {
                    throw new InvalidConstrainingFacetException(aTermAppl4, (Object)aTermAppl5, invalidLiteralException);
                }
                restrictedDatatype = restrictedDatatype.applyConstrainingFacet(aTermAppl4, object);
                aTermList2 = aTermList2.getNext();
            }
            return restrictedDatatype;
        }
        if (ATermUtils.isNot(aTermAppl)) {
            ATermAppl aTermAppl6 = (ATermAppl)aTermAppl.getArgument(0);
            DataRange<?> dataRange = this.getDataRange(aTermAppl6);
            NegatedDataRange negatedDataRange = new NegatedDataRange(dataRange);
            return negatedDataRange;
        }
        if (ATermUtils.isNominal(aTermAppl)) {
            ATermAppl aTermAppl7 = (ATermAppl)aTermAppl.getArgument(0);
            DataValueEnumeration<Object> dataValueEnumeration = new DataValueEnumeration<Object>(Collections.singleton(this.getValue(aTermAppl7)));
            return dataValueEnumeration;
        }
        String string = String.format("Unrecognized input term (%s) for datarange conversion", aTermAppl);
        log.severe(string);
        throw new IllegalArgumentException(string);
    }

    @Override
    public Datatype<?> getDatatype(ATermAppl aTermAppl) {
        try {
            ATermAppl aTermAppl2;
            Datatype<?> datatype = coreDatatypes.get(aTermAppl);
            if (datatype == null && (aTermAppl2 = this.namedDataRanges.get(aTermAppl)) != null && ATermUtils.isRestrictedDatatype(aTermAppl2)) {
                RestrictedDatatype restrictedDatatype = (RestrictedDatatype)this.getDataRange(aTermAppl2);
                NamedDatatype namedDatatype = new NamedDatatype(aTermAppl, restrictedDatatype);
                datatype = namedDatatype;
            }
            return datatype;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private DataRange<?> getDisjunction(Collection<DataRange<?>> collection) {
        Object object;
        Object object2;
        Object object32;
        DataRange<?> dataRange22;
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        for (DataRange<?> dataRange22 : collection) {
            if (dataRange22 != TRIVIALLY_SATISFIABLE) continue;
            return dataRange22;
        }
        HashSet<Object> hashSet = Collections.emptySet();
        dataRange22 = new HashMap();
        for (DataRange<?> object42 : collection) {
            if (object42 instanceof RestrictedDatatype) {
                object32 = (RestrictedDatatype)object42;
                object2 = object32.getDatatype().getPrimitiveDatatype();
                object = (Set)dataRange22.get(object2);
                if (object == null) {
                    object = new HashSet();
                    dataRange22.put(object2, object);
                }
                object.add(object32);
                continue;
            }
            if (!(object42 instanceof DataValueEnumeration)) continue;
            object32 = (DataValueEnumeration)object42;
            if (hashSet.isEmpty()) {
                hashSet = new HashSet<Object>();
            }
            object2 = ((DataValueEnumeration)object32).valueIterator();
            while (object2.hasNext()) {
                hashSet.add(object2.next());
            }
        }
        HashSet hashSet2 = new HashSet();
        for (Object object32 : dataRange22.values()) {
            object2 = object32.iterator();
            object = (RestrictedDatatype)object2.next();
            while (object2.hasNext()) {
                object = object.union((RestrictedDatatype)object2.next());
            }
            hashSet2.add(object);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object32 = iterator.next();
            object2 = hashSet2.iterator();
            while (object2.hasNext()) {
                object = (RestrictedDatatype)object2.next();
                if (!object.contains(object32)) continue;
                iterator.remove();
            }
        }
        return new UnionDataRange(hashSet2, hashSet);
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        for (Datatype<?> datatype : coreDatatypes.values()) {
            if (!datatype.isPrimitive() || !datatype.asDataRange().contains(object)) continue;
            return datatype.getLiteral(object);
        }
        String string = "Value is not in the value space of any recognized datatypes: " + object.toString();
        log.severe(string);
        throw new IllegalArgumentException(string);
    }

    @Override
    public Object getValue(ATermAppl aTermAppl) throws InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl aTermAppl2 = DatatypeReasonerImpl.getDatatypeName(aTermAppl);
        Datatype<?> datatype = this.getDatatype(aTermAppl2);
        if (datatype == null) {
            switch (PelletOptions.UNDEFINED_DATATYPE_HANDLING) {
                case INFINITE_STRING: {
                    return aTermAppl;
                }
                case EMPTY: {
                    throw new InvalidLiteralException(aTermAppl2, ATermUtils.getLiteralValue(aTermAppl));
                }
                case EXCEPTION: {
                    throw new UnrecognizedDatatypeException(aTermAppl2);
                }
            }
            throw new IllegalStateException();
        }
        return datatype.getValue(aTermAppl);
    }

    @Override
    public boolean isDeclared(ATermAppl aTermAppl) {
        return ATermUtils.TOP_LIT.equals(aTermAppl) || coreDatatypes.containsKey(aTermAppl) || this.namedDataRanges.containsKey(aTermAppl) || this.declaredUndefined.contains(aTermAppl);
    }

    @Override
    public boolean isDefined(ATermAppl aTermAppl) {
        if (ATermUtils.TOP_LIT.equals(aTermAppl)) {
            return true;
        }
        if (coreDatatypes.containsKey(aTermAppl)) {
            return true;
        }
        return this.namedDataRanges.containsKey(aTermAppl);
    }

    @Override
    public ATermAppl getDefinition(ATermAppl aTermAppl) {
        return this.namedDataRanges.get(aTermAppl);
    }

    @Override
    public boolean isSatisfiable(Collection<ATermAppl> collection) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        return this.isSatisfiable(collection, null);
    }

    @Override
    public boolean isSatisfiable(Collection<ATermAppl> collection, Object object) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Collection[] collectionArray;
        ATermList aTermList;
        Collection[] collectionArray2;
        Set<Integer> set;
        HashSet<Integer> hashSet;
        if (object == null) {
            hashSet = new HashSet();
            set = new HashSet<Integer>(Collections.singleton(0));
        } else {
            hashSet = Collections.singleton(0);
            set = Collections.emptySet();
        }
        ATermAppl aTermAppl = ATermUtils.makeAnd(ATermUtils.makeList(collection));
        ATermAppl aTermAppl2 = DNF.dnf(this.expander.expand(aTermAppl, this.namedDataRanges));
        if (ATermUtils.isOr(aTermAppl2)) {
            collectionArray2 = new ArrayList();
            aTermList = (ATermList)aTermAppl2.getArgument(0);
            while (!aTermList.isEmpty()) {
                collectionArray2.add((ATermAppl)aTermList.getFirst());
                aTermList = aTermList.getNext();
            }
            collectionArray = collectionArray2;
        } else {
            collectionArray = Collections.singleton(aTermAppl2);
        }
        collectionArray2 = new Collection[]{collectionArray};
        aTermList = new ATermList[]{Collections.emptySet()};
        return this.isSatisfiable((Set<Integer>)hashSet, set, collectionArray2, new Object[]{object}, (Set<Integer>[])aTermList);
    }

    private boolean isSatisfiable(Set<Integer> set, Set<Integer> set2, Collection<ATermAppl>[] collectionArray, Object[] objectArray, Set<Integer>[] setArray) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        HashSet<Integer> hashSet;
        Object object2;
        int n = collectionArray.length;
        for (int i = 0; i < n; ++i) {
            Collection<ATermAppl> collection = collectionArray[i];
            Iterator<ATermAppl> iterator = collection.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (!ATermUtils.BOTTOM_LIT.equals(object2)) continue;
                iterator.remove();
            }
            if (!collection.isEmpty()) continue;
            return false;
        }
        DataRange[] dataRangeArray = new DataRange[n];
        for (int i = 0; i < n; ++i) {
            if (set.contains(i)) {
                boolean bl = false;
                for (ATermAppl aTermAppl : collectionArray[i]) {
                    if (!this.containedIn(objectArray[i], aTermAppl)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    dataRangeArray[i] = TRIVIALLY_SATISFIABLE;
                    continue;
                }
                return false;
            }
            List<DataRange<?>> list = new ArrayList();
            for (ATermAppl aTermAppl : collectionArray[i]) {
                DataRange<?> dataRange = this.normalizeVarRanges(aTermAppl);
                if (dataRange == TRIVIALLY_SATISFIABLE) {
                    list = Collections.singletonList(TRIVIALLY_SATISFIABLE);
                    break;
                }
                if (dataRange.isEmpty()) continue;
                list.add(dataRange);
            }
            if (list.isEmpty()) {
                return false;
            }
            dataRangeArray[i] = this.getDisjunction(list);
        }
        Object object4 = set2.iterator();
        while (object4.hasNext()) {
            Integer n2 = object4.next();
            object2 = dataRangeArray[n2];
            if (TRIVIALLY_SATISFIABLE == object2) {
                object4.remove();
                DatatypeReasonerImpl.removeInequalities(setArray, n2);
                continue;
            }
            if (object2.isEmpty()) {
                return false;
            }
            if (object2.containsAtLeast(DatatypeReasonerImpl.inequalityCount(setArray, n2) + 1)) {
                object4.remove();
                DatatypeReasonerImpl.removeInequalities(setArray, n2);
                continue;
            }
            if (!object2.isFinite() || !object2.isEnumerable() || object2.containsAtLeast(2)) continue;
            Object t = object2.valueIterator().next();
            object4.remove();
            set.add(n2);
            objectArray[n2.intValue()] = t;
            dataRangeArray[n2.intValue()] = TRIVIALLY_SATISFIABLE;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("After variable data range normalization %d variables and %d constants", set2.size(), set.size()));
        }
        for (Integer n3 : set) {
            object2 = setArray[n3];
            if (object2 == null) continue;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                if (!set.contains(n2)) continue;
                if (objectArray[n3].equals(objectArray[n2])) {
                    return false;
                }
                iterator.remove();
                setArray[n2].remove(n3);
            }
        }
        object4 = set2.iterator();
        while (object4.hasNext()) {
            Set<Integer> set3;
            int n3;
            int n6 = object4.next();
            object2 = dataRangeArray[n6];
            if (!object2.containsAtLeast(n3 = (set3 = setArray[n6]) == null ? 1 : set3.size() + 1)) continue;
            object4.remove();
            for (int n4 : set3) {
                if (setArray[n4] == null) continue;
                setArray[n4].remove(n6);
            }
            setArray[n6] = null;
            set2.remove(n6);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("After size check on variable data ranges %d variables", set2.size()));
        }
        if (set2.isEmpty()) {
            return true;
        }
        object4 = new HashSet<Integer>(set2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (!object4.isEmpty()) {
            object2 = new HashSet();
            Iterator iterator = object4.iterator();
            int n5 = (Integer)iterator.next();
            iterator.remove();
            object2.add(n5);
            if (setArray[n5] != null) {
                hashSet = new HashSet<Integer>();
                hashSet.addAll(setArray[n5]);
                while (!hashSet.isEmpty()) {
                    Iterator iterator2 = hashSet.iterator();
                    int n6 = (Integer)iterator2.next();
                    iterator2.remove();
                    if (!object4.contains(n6)) continue;
                    object2.add(n6);
                    object4.remove(n6);
                    if (setArray[n6] == null) continue;
                    hashSet.addAll(setArray[n6]);
                }
            }
            arrayList.add(object2);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Enumerating to find solutions for %d partitions", arrayList.size()));
        }
        for (Set set4 : arrayList) {
            int n7 = set4.size();
            hashSet = (HashSet<Integer>)new int[n7];
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            DataRange[] dataRangeArray2 = new DataRange[n7];
            int n8 = 0;
            Iterator[] iteratorArray = set4.iterator();
            while (iteratorArray.hasNext()) {
                int n9 = (Integer)iteratorArray.next();
                dataRangeArray2[n8] = dataRangeArray[n9];
                hashSet[n8] = (HashSet)n9;
                hashMap.put(n9, n8);
                ++n8;
            }
            iteratorArray = new Iterator[n7];
            for (n8 = 0; n8 < n7; ++n8) {
                iteratorArray[n8] = dataRangeArray2[n8].valueIterator();
            }
            Object[] objectArray2 = new Object[n7];
            for (n8 = 0; n8 < n7; ++n8) {
                objectArray2[n8] = iteratorArray[n8].next();
            }
            boolean bl = false;
            while (!bl) {
                bl = true;
                block17: for (n8 = 0; n8 < n7 && bl; ++n8) {
                    Set<Integer> set5 = setArray[hashSet[n8]];
                    if (set5 == null) continue;
                    Object object = objectArray2[n8];
                    for (int n10 : set5) {
                        Object object3 = set4.contains(n10) ? objectArray2[(Integer)hashMap.get(n10)] : objectArray[n10];
                        if (!object.equals(object3)) continue;
                        bl = false;
                        continue block17;
                    }
                }
                if (bl) continue;
                n8 = n7 - 1;
                while (!iteratorArray[n8].hasNext()) {
                    if (n8 == 0) {
                        return false;
                    }
                    iteratorArray[n8] = dataRangeArray2[n8].valueIterator();
                    objectArray2[n8] = iteratorArray[n8].next();
                    --n8;
                }
                objectArray2[n8] = iteratorArray[n8].next();
            }
        }
        return true;
    }

    @Override
    public boolean isSatisfiable(Set<Literal> set, Map<Literal, Set<Literal>> map) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Literal[] literalArray = set.toArray(new Literal[0]);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        Object[] objectArray = new Object[literalArray.length];
        HashMap<Literal, Integer> hashMap = new HashMap<Literal, Integer>();
        for (int i = 0; i < literalArray.length; ++i) {
            hashMap.put(literalArray[i], i);
            if (literalArray[i].isNominal()) {
                hashSet2.add(i);
                objectArray[i] = literalArray[i].getValue();
                continue;
            }
            hashSet.add(i);
        }
        Set[] setArray = new Set[literalArray.length];
        for (Map.Entry<Literal, Set<Literal>> entry : map.entrySet()) {
            int n = (Integer)hashMap.get(entry.getKey());
            setArray[n] = new HashSet();
            for (Literal object : entry.getValue()) {
                setArray[n].add(hashMap.get(object));
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Checking satisfiability for %d variables and %d constants", hashSet.size(), hashSet2.size()));
        }
        Collection[] collectionArray = new Collection[literalArray.length];
        for (int i = 0; i < literalArray.length; ++i) {
            ATermAppl aTermAppl = ATermUtils.makeAnd(ATermUtils.makeList(literalArray[i].getTypes()));
            ATermAppl aTermAppl2 = DNF.dnf(this.expander.expand(aTermAppl, this.namedDataRanges));
            if (ATermUtils.isOr(aTermAppl2)) {
                ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
                ATermList aTermList = (ATermList)aTermAppl2.getArgument(0);
                while (!aTermList.isEmpty()) {
                    arrayList.add((ATermAppl)aTermList.getFirst());
                    aTermList = aTermList.getNext();
                }
                collectionArray[i] = arrayList;
                continue;
            }
            collectionArray[i] = Collections.singleton(aTermAppl2);
        }
        return this.isSatisfiable(hashSet2, hashSet, collectionArray, objectArray, setArray);
    }

    @Override
    public boolean define(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        if (aTermAppl.equals(aTermAppl2)) {
            throw new IllegalArgumentException();
        }
        if (this.namedDataRanges.containsKey(aTermAppl)) {
            return false;
        }
        this.namedDataRanges.put(aTermAppl, aTermAppl2);
        this.declaredUndefined.remove(aTermAppl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private DataRange<?> normalizeVarRanges(ATermAppl aTermAppl) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        DataRange<?> dataRange;
        if (ATermUtils.isAnd(aTermAppl)) {
            void var10_19;
            void var10_16;
            Object object;
            HashSet hashSet;
            DataRange<?> dataRange2;
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            Object object2 = (ATermList)aTermAppl.getArgument(0);
            while (!object2.isEmpty()) {
                dataRange2 = this.getDataRange((ATermAppl)object2.getFirst());
                if (dataRange2.isEmpty()) {
                    return EMPTY_RANGE;
                }
                linkedHashSet.add(dataRange2);
                object2 = object2.getNext();
            }
            object2 = new HashSet();
            dataRange2 = new HashSet();
            HashSet hashSet2 = new HashSet();
            HashSet hashSet3 = new HashSet();
            DatatypeReasonerImpl.partitionDConjunction(linkedHashSet, object2, dataRange2, hashSet2, hashSet3);
            if (!object2.isEmpty()) {
                DataValueEnumeration dataValueEnumeration = DatatypeReasonerImpl.findSmallestEnumeration(object2);
                HashSet hashSet4 = new HashSet();
                Iterator iterator = dataValueEnumeration.valueIterator();
                boolean bl = true;
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    boolean bl2 = true;
                    for (DataRange dataRange3 : linkedHashSet) {
                        if (dataRange3 == dataValueEnumeration || dataRange3.contains(t)) continue;
                        bl2 = false;
                        bl = false;
                        break;
                    }
                    if (!bl2) continue;
                    hashSet4.add(t);
                }
                if (bl) {
                    return dataValueEnumeration;
                }
                if (hashSet4.isEmpty()) {
                    return EMPTY_RANGE;
                }
                return new DataValueEnumeration(hashSet4);
            }
            if (hashSet2.isEmpty()) {
                return TRIVIALLY_SATISFIABLE;
            }
            Datatype<?> datatype = null;
            for (RestrictedDatatype restrictedDatatype2 : hashSet2) {
                hashSet = restrictedDatatype2.getDatatype().getPrimitiveDatatype();
                if (datatype == null) {
                    datatype = hashSet;
                    continue;
                }
                if (datatype.equals(hashSet)) continue;
                return EMPTY_RANGE;
            }
            Iterator iterator = hashSet2.iterator();
            RestrictedDatatype restrictedDatatype = (RestrictedDatatype)iterator.next();
            while (iterator.hasNext()) {
                void var10_14;
                hashSet = (RestrictedDatatype)iterator.next();
                RestrictedDatatype restrictedDatatype2 = var10_14.intersect((RestrictedDatatype<?>)((Object)hashSet), false);
            }
            for (RestrictedDatatype restrictedDatatype3 : hashSet3) {
                if (restrictedDatatype3.isEmpty() || !datatype.equals(object = restrictedDatatype3.getDatatype().getPrimitiveDatatype())) continue;
                RestrictedDatatype restrictedDatatype4 = var10_16.intersect(restrictedDatatype3, true);
            }
            if (!dataRange2.isEmpty()) {
                hashSet = new HashSet();
                Iterator iterator2 = dataRange2.iterator();
                while (iterator2.hasNext()) {
                    object = (DataValueEnumeration)iterator2.next();
                    Iterator iterator3 = ((DataValueEnumeration)object).valueIterator();
                    while (iterator3.hasNext()) {
                        hashSet.add(iterator3.next());
                    }
                }
                RestrictedDatatype restrictedDatatype5 = var10_16.exclude(hashSet);
            }
            dataRange = var10_19;
        } else {
            dataRange = this.getDataRange(aTermAppl);
        }
        if (!dataRange.isFinite()) {
            return TRIVIALLY_SATISFIABLE;
        }
        return dataRange;
    }

    @Override
    public Collection<ATermAppl> listDataRanges() {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>(coreDatatypes.keySet());
        hashSet.addAll(this.declaredUndefined);
        hashSet.addAll(this.namedDataRanges.keySet());
        return hashSet;
    }

    @Override
    public boolean validLiteral(ATermAppl aTermAppl) throws UnrecognizedDatatypeException {
        if (!ATermUtils.isLiteral(aTermAppl)) {
            throw new IllegalArgumentException();
        }
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(2);
        if (aTermAppl2 == null) {
            throw new IllegalArgumentException();
        }
        Datatype<?> datatype = this.getDatatype(aTermAppl2);
        if (datatype == null) {
            throw new UnrecognizedDatatypeException(aTermAppl2);
        }
        try {
            datatype.getValue(aTermAppl);
        }
        catch (InvalidLiteralException invalidLiteralException) {
            return false;
        }
        return true;
    }

    @Override
    public Iterator<?> valueIterator(Collection<ATermAppl> collection) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl aTermAppl = ATermUtils.makeAnd(ATermUtils.makeList(collection));
        ATermAppl aTermAppl2 = DNF.dnf(this.expander.expand(aTermAppl, this.namedDataRanges));
        if (ATermUtils.isOr(aTermAppl2)) {
            ArrayList arrayList = new ArrayList();
            Object object = (ATermList)aTermAppl2.getArgument(0);
            while (!object.isEmpty()) {
                DataRange<?> dataRange = this.normalizeVarRanges((ATermAppl)object.getFirst());
                arrayList.add(dataRange);
                object = object.getNext();
            }
            object = this.getDisjunction(arrayList);
            if (!object.isEnumerable()) {
                throw new IllegalArgumentException();
            }
            return object.valueIterator();
        }
        DataRange<?> dataRange = this.normalizeVarRanges(aTermAppl2);
        if (!dataRange.isEnumerable()) {
            throw new IllegalArgumentException();
        }
        return dataRange.valueIterator();
    }

    static {
        log = Logger.getLogger(DatatypeReasonerImpl.class.getCanonicalName());
        coreDatatypes = new HashMap();
        coreDatatypes.put(RDFPlainLiteral.getInstance().getName(), RDFPlainLiteral.getInstance());
        coreDatatypes.put(XSDString.getInstance().getName(), XSDString.getInstance());
        coreDatatypes.put(XSDNormalizedString.getInstance().getName(), XSDNormalizedString.getInstance());
        coreDatatypes.put(XSDToken.getInstance().getName(), XSDToken.getInstance());
        coreDatatypes.put(XSDLanguage.getInstance().getName(), XSDLanguage.getInstance());
        coreDatatypes.put(XSDNMToken.getInstance().getName(), XSDNMToken.getInstance());
        coreDatatypes.put(XSDName.getInstance().getName(), XSDName.getInstance());
        coreDatatypes.put(XSDNCName.getInstance().getName(), XSDNCName.getInstance());
        coreDatatypes.put(XSDBoolean.getInstance().getName(), XSDBoolean.getInstance());
        coreDatatypes.put(OWLReal.getInstance().getName(), OWLReal.getInstance());
        coreDatatypes.put(OWLRational.getInstance().getName(), OWLRational.getInstance());
        coreDatatypes.put(XSDDecimal.getInstance().getName(), XSDDecimal.getInstance());
        coreDatatypes.put(XSDInteger.getInstance().getName(), XSDInteger.getInstance());
        coreDatatypes.put(XSDLong.getInstance().getName(), XSDLong.getInstance());
        coreDatatypes.put(XSDInt.getInstance().getName(), XSDInt.getInstance());
        coreDatatypes.put(XSDShort.getInstance().getName(), XSDShort.getInstance());
        coreDatatypes.put(XSDByte.getInstance().getName(), XSDByte.getInstance());
        coreDatatypes.put(XSDNonNegativeInteger.getInstance().getName(), XSDNonNegativeInteger.getInstance());
        coreDatatypes.put(XSDNonPositiveInteger.getInstance().getName(), XSDNonPositiveInteger.getInstance());
        coreDatatypes.put(XSDNegativeInteger.getInstance().getName(), XSDNegativeInteger.getInstance());
        coreDatatypes.put(XSDPositiveInteger.getInstance().getName(), XSDPositiveInteger.getInstance());
        coreDatatypes.put(XSDUnsignedLong.getInstance().getName(), XSDUnsignedLong.getInstance());
        coreDatatypes.put(XSDUnsignedInt.getInstance().getName(), XSDUnsignedInt.getInstance());
        coreDatatypes.put(XSDUnsignedShort.getInstance().getName(), XSDUnsignedShort.getInstance());
        coreDatatypes.put(XSDUnsignedByte.getInstance().getName(), XSDUnsignedByte.getInstance());
        coreDatatypes.put(XSDDouble.getInstance().getName(), XSDDouble.getInstance());
        coreDatatypes.put(XSDFloat.getInstance().getName(), XSDFloat.getInstance());
        coreDatatypes.put(XSDDateTime.getInstance().getName(), XSDDateTime.getInstance());
        coreDatatypes.put(XSDDateTimeStamp.getInstance().getName(), XSDDateTimeStamp.getInstance());
        coreDatatypes.put(XSDDate.getInstance().getName(), XSDDate.getInstance());
        coreDatatypes.put(XSDGYearMonth.getInstance().getName(), XSDGYearMonth.getInstance());
        coreDatatypes.put(XSDGMonthDay.getInstance().getName(), XSDGMonthDay.getInstance());
        coreDatatypes.put(XSDGYear.getInstance().getName(), XSDGYear.getInstance());
        coreDatatypes.put(XSDGMonth.getInstance().getName(), XSDGMonth.getInstance());
        coreDatatypes.put(XSDGDay.getInstance().getName(), XSDGDay.getInstance());
        coreDatatypes.put(XSDTime.getInstance().getName(), XSDTime.getInstance());
        coreDatatypes.put(XSDDuration.getInstance().getName(), XSDDuration.getInstance());
        coreDatatypes.put(XSDAnyURI.getInstance().getName(), XSDAnyURI.getInstance());
        EMPTY_RANGE = new EmptyDataRange();
        TRIVIALLY_SATISFIABLE = new DataRange<Object>(){

            @Override
            public boolean contains(Object object) {
                return true;
            }

            @Override
            public boolean containsAtLeast(int n) {
                return true;
            }

            public boolean equals(Object object) {
                return this == object;
            }

            @Override
            public Object getValue(int n) {
                throw new UnsupportedOperationException();
            }

            public int hashCode() {
                return super.hashCode();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean isEnumerable() {
                return false;
            }

            @Override
            public boolean isFinite() {
                return false;
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Object> valueIterator() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

