/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.io.manchester;

import com.clarkparsia.owlapi.explanation.io.ExplanationRenderer;
import com.clarkparsia.owlapi.explanation.io.manchester.BlockWriter;
import com.clarkparsia.owlapi.explanation.io.manchester.ManchesterSyntaxObjectRenderer;
import com.clarkparsia.owlapi.explanation.io.manchester.TextBlockWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObjectVisitor;

public class ManchesterSyntaxExplanationRenderer
implements ExplanationRenderer {
    protected ManchesterSyntaxObjectRenderer renderer;
    protected BlockWriter writer;
    protected OWLAxiom currentAxiom;
    private boolean wrapLines = true;
    private boolean smartIndent = true;
    private int index;

    public void endRendering() {
        this.writer.flush();
    }

    protected OWLAxiom getCurrentAxiom() {
        return this.currentAxiom;
    }

    public boolean isSmartIndent() {
        return this.smartIndent;
    }

    public boolean isWrapLines() {
        return this.wrapLines;
    }

    public void render(Set<Set<OWLAxiom>> set) throws OWLException, IOException, UnsupportedOperationException {
        this.render(null, set);
    }

    public void render(OWLAxiom oWLAxiom, Set<Set<OWLAxiom>> set) throws OWLException, IOException {
        this.setCurrentAxiom(oWLAxiom);
        if (this.index == 1) {
            if (oWLAxiom != null) {
                this.writer.print("Axiom: ");
                oWLAxiom.accept((OWLObjectVisitor)this.renderer);
                this.writer.println();
                this.writer.println();
            }
            if (set.isEmpty()) {
                this.writer.println("Explanation: AXIOM IS NOT ENTAILED!");
                return;
            }
            this.writer.println("Explanation(s): ");
        }
        String string = this.index++ + ")";
        this.writer.print(string);
        this.renderSingleExplanation(set.iterator().next());
        this.writer.println();
    }

    protected void renderSingleExplanation(Set<OWLAxiom> set) throws OWLException, IOException {
        this.writer.printSpace();
        this.writer.printSpace();
        this.writer.printSpace();
        this.writer.startBlock();
        for (OWLAxiom oWLAxiom : set) {
            oWLAxiom.accept((OWLObjectVisitor)this.renderer);
            this.writer.println();
        }
        this.writer.endBlock();
        this.writer.println();
    }

    protected void setCurrentAxiom(OWLAxiom oWLAxiom) {
        this.currentAxiom = oWLAxiom;
    }

    public void setSmartIndent(boolean bl) {
        this.smartIndent = bl;
    }

    public void setWrapLines(boolean bl) {
        this.wrapLines = bl;
    }

    public void startRendering(Writer writer) {
        this.writer = new TextBlockWriter(writer);
        this.renderer = new ManchesterSyntaxObjectRenderer(this.writer);
        this.renderer.setWrapLines(this.isWrapLines());
        this.renderer.setSmartIndent(this.isSmartIndent());
        this.index = 1;
    }
}

