/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.io.Serializable;
import org.semanticweb.owlapi.change.OWLOntologyChangeData;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;

public final class OWLOntologyChangeRecord
implements Serializable {
    private static final long serialVersionUID = 30402L;
    private final OWLOntologyID ontologyID;
    private final OWLOntologyChangeData data;

    private OWLOntologyChangeRecord() {
        this.ontologyID = null;
        this.data = null;
    }

    public OWLOntologyChangeRecord(OWLOntologyID ontologyID, OWLOntologyChangeData data) {
        if (ontologyID == null) {
            throw new NullPointerException("ontologyID must not be null");
        }
        if (data == null) {
            throw new NullPointerException("data must not be null");
        }
        this.ontologyID = ontologyID;
        this.data = data;
    }

    public static OWLOntologyChangeRecord createFromOWLOntologyChange(OWLOntologyChange change) {
        if (change == null) {
            throw new NullPointerException("change must not be null");
        }
        OWLOntologyID ontologyId = change.getOntology().getOntologyID();
        OWLOntologyChangeData data = change.getChangeData();
        return new OWLOntologyChangeRecord(ontologyId, data);
    }

    public OWLOntologyID getOntologyID() {
        return this.ontologyID;
    }

    public OWLOntologyChangeData getData() {
        return this.data;
    }

    public OWLOntologyChange createOntologyChange(OWLOntologyManager manager) throws UnknownOWLOntologyException {
        if (manager == null) {
            throw new NullPointerException("manager must not be null");
        }
        OWLOntology ontology = manager.getOntology(this.ontologyID);
        if (ontology == null) {
            throw new UnknownOWLOntologyException(this.ontologyID);
        }
        return this.data.createOntologyChange(ontology);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLOntologyChangeRecord)) {
            return false;
        }
        OWLOntologyChangeRecord other = (OWLOntologyChangeRecord)obj;
        return this.ontologyID.equals(other.ontologyID) && this.data.equals(other.data);
    }

    public int hashCode() {
        return "OWLOntologyChangeRecord".hashCode() + this.ontologyID.hashCode() + this.data.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OWLOntologyChangeRecord(");
        sb.append(this.ontologyID);
        sb.append(" ");
        sb.append(this.data);
        sb.append(")");
        return sb.toString();
    }
}

