/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.system.MapWithScope;

public class NodeToLabel
extends MapWithScope<Node, String, Node> {
    private static final NodeToLabel _internal = NodeToLabel.createBNodeByLabelEncoded();

    public static NodeToLabel createScopeByDocument() {
        return new NodeToLabel(new SingleScopePolicy(), new AllocatorIncLabel());
    }

    public static NodeToLabel createBNodeByLabelEncoded() {
        return new NodeToLabel(new SingleScopePolicy(), new AllocatorInternalSafe());
    }

    public static NodeToLabel createBNodeByLabelAsGiven() {
        return new NodeToLabel(new SingleScopePolicy(), new AllocatorInternalRaw());
    }

    public static NodeToLabel createBNodeByIRI() {
        return new NodeToLabel(new SingleScopePolicy(), new AllocatorBNodeAsIRI());
    }

    public static NodeToLabel labelByInternal() {
        return _internal;
    }

    private NodeToLabel(MapWithScope.ScopePolicy<Node, String, Node> scopePolicy, MapWithScope.Allocator<Node, String> allocator) {
        super(scopePolicy, allocator);
    }

    private static class AllocatorBNodeAsIRI
    extends AllocatorBase {
        private AllocatorBNodeAsIRI() {
        }

        @Override
        protected String labelForBlank(Node node) {
            String str2 = node.getBlankNodeLabel();
            return "<_:" + str2 + ">";
        }
    }

    private static class AllocatorIncLabel
    extends AllocatorBase {
        private int X = 0;

        AllocatorIncLabel() {
        }

        @Override
        protected String labelForBlank(Node node) {
            return "_:b" + Integer.toString(this.X++);
        }
    }

    private static class AllocatorInternalSafe
    extends AllocatorBase {
        private AllocatorInternalSafe() {
        }

        @Override
        protected String labelForBlank(Node node) {
            return "_:" + NodeFmtLib.encodeBNodeLabel(node.getBlankNodeLabel());
        }
    }

    private static class AllocatorInternalRaw
    extends AllocatorBase {
        private AllocatorInternalRaw() {
        }

        @Override
        protected String labelForBlank(Node node) {
            return "_:" + node.getBlankNodeLabel();
        }
    }

    private static abstract class AllocatorBase
    implements MapWithScope.Allocator<Node, String> {
        private long counter = 0L;

        private AllocatorBase() {
        }

        @Override
        public final String create(Node node) {
            if (node.isURI()) {
                return this.labelForURI(node);
            }
            if (node.isLiteral()) {
                return this.labelForLiteral(node);
            }
            if (node.isBlank()) {
                return this.labelForBlank(node);
            }
            if (node.isVariable()) {
                return this.labelForVar(node);
            }
            return Long.toString(this.counter++);
        }

        protected String labelForURI(Node node) {
            return "<" + node.getURI() + ">";
        }

        protected abstract String labelForBlank(Node var1);

        protected String labelForLiteral(Node node) {
            return FmtUtils.stringForLiteral((Node_Literal)node, null);
        }

        protected String labelForVar(Node node) {
            return "?" + node.getName();
        }

        @Override
        public void reset() {
        }
    }

    private static class GraphScopePolicy
    implements MapWithScope.ScopePolicy<Node, String, Node> {
        private Map<Node, String> dftMap = new HashMap<Node, String>();
        private Map<Node, Map<Node, String>> map = new HashMap<Node, Map<Node, String>>();

        private GraphScopePolicy() {
        }

        @Override
        public Map<Node, String> getScope(Node scope) {
            if (scope == null) {
                return this.dftMap;
            }
            Map<Node, String> x = this.map.get(scope);
            if (x == null) {
                x = new HashMap<Node, String>();
                this.map.put(scope, x);
            }
            return x;
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }

    private static class SingleScopePolicy
    implements MapWithScope.ScopePolicy<Node, String, Node> {
        private Map<Node, String> map = new HashMap<Node, String>();

        private SingleScopePolicy() {
        }

        @Override
        public Map<Node, String> getScope(Node scope) {
            return this.map;
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }
}

