/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.intset;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.mindswap.pellet.utils.intset.AbstractIntSet;
import org.mindswap.pellet.utils.intset.IntIterator;
import org.mindswap.pellet.utils.intset.IntSet;

public class TreeIntSet
extends AbstractIntSet
implements IntSet {
    private TreeSet<Integer> ints;

    public TreeIntSet() {
        this.ints = new TreeSet();
    }

    public TreeIntSet(TreeIntSet treeIntSet) {
        this.ints = new TreeSet<Integer>((SortedSet<Integer>)treeIntSet.ints);
    }

    @Override
    public void add(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ints.add(n);
    }

    @Override
    public void addAll(IntSet intSet) {
        if (intSet instanceof TreeIntSet) {
            this.ints.addAll(((TreeIntSet)intSet).ints);
        } else {
            super.addAll(intSet);
        }
    }

    @Override
    public boolean contains(int n) {
        return this.ints.contains(n);
    }

    @Override
    public IntSet copy() {
        return new TreeIntSet(this);
    }

    @Override
    public boolean isEmpty() {
        return this.ints.isEmpty();
    }

    @Override
    public IntIterator iterator() {
        return new IntIterator(){
            private Iterator<Integer> base;
            {
                this.base = TreeIntSet.this.ints.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.base.hasNext();
            }

            @Override
            public int next() {
                return this.base.next();
            }
        };
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.ints.last();
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.ints.first();
    }

    @Override
    public void remove(int n) {
        this.ints.remove(n);
    }

    @Override
    public int size() {
        return this.ints.size();
    }
}

