/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.rdfxml;

import com.clarkparsia.pellint.util.CollectionUtil;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RDFLints {
    private Map<String, List<String>> m_Report = new LinkedHashMap<String, List<String>>();
    private List<Statement> m_MissingStatements = CollectionUtil.makeList();

    public void add(String string, List<String> list) {
        if (!list.isEmpty()) {
            this.m_Report.put(string, list);
        }
    }

    public void addMissingStatements(List<Statement> list) {
        this.m_MissingStatements.addAll(list);
    }

    public List<Statement> getMissingStatements() {
        return this.m_MissingStatements;
    }

    public boolean isEmpty() {
        return this.m_Report.isEmpty();
    }

    public String toString() {
        if (this.m_Report.isEmpty()) {
            return "No RDF lints found.";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.m_Report.entrySet()) {
            String string = entry.getKey();
            List<String> list = entry.getValue();
            if (list.isEmpty()) continue;
            stringBuilder.append("[").append(string).append("]\n");
            for (String string2 : list) {
                stringBuilder.append("- ").append(string2).append("\n");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

