/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DisjointSet<T> {
    private Map<T, Node<T>> elements = new HashMap<T, Node<T>>();

    public void add(T t) {
        if (this.elements.containsKey(t)) {
            return;
        }
        this.elements.put(t, new Node<T>(t));
    }

    public boolean contains(T t) {
        return this.elements.containsKey(t);
    }

    public Collection<T> elements() {
        return Collections.unmodifiableSet(this.elements.keySet());
    }

    public T find(T t) {
        return (T)this.findRoot(t).object;
    }

    private Node<T> findRoot(T t) {
        Node<Object> node = this.elements.get(t);
        while (node.parent.parent != node.parent) {
            node.parent = node.parent.parent;
            node = node.parent;
        }
        return node.parent;
    }

    public Collection<Set<T>> getEquivalanceSets() {
        HashMap<T, HashSet<T>> hashMap = new HashMap<T, HashSet<T>>();
        for (T t : this.elements.keySet()) {
            T t2 = this.find(t);
            HashSet<T> hashSet = (HashSet<T>)hashMap.get(t2);
            if (hashSet == null) {
                hashSet = new HashSet<T>();
                hashMap.put(t2, hashSet);
            }
            hashSet.add(t);
        }
        return hashMap.values();
    }

    public boolean isSame(T t, T t2) {
        return this.find(t).equals(this.find(t2));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        Iterator<Node<T>> iterator = this.elements.values().iterator();
        while (iterator.hasNext()) {
            Node<T> node = iterator.next();
            stringBuffer.append(node.object);
            stringBuffer.append(" -> ");
            stringBuffer.append(node.parent.object);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Node<T> union(T t, T t2) {
        Node<T> node = this.findRoot(t);
        Node<T> node2 = this.findRoot(t2);
        if (node.rank > node2.rank) {
            Node<T> node3 = node;
            node = node2;
            node2 = node3;
        } else if (node.rank == node2.rank) {
            ++node2.rank;
        }
        node.parent = node2;
        return node2;
    }

    private class Node<U> {
        U object;
        Node<U> parent = this;
        int rank = 0;

        Node(U u) {
            this.object = u;
        }
    }
}

