/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.floating;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.floating.IEEEDoubleType;
import com.clarkparsia.pellet.datatypes.types.floating.RestrictedFloatingPointDatatype;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDDouble
extends AbstractBaseDatatype<Double> {
    private static final XSDDouble instance = new XSDDouble();
    private final RestrictedFloatingPointDatatype<Double> dataRange = new RestrictedFloatingPointDatatype<Double>(this, IEEEDoubleType.getInstance());

    public static XSDDouble getInstance() {
        return instance;
    }

    private XSDDouble() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#double"));
    }

    @Override
    public RestrictedDatatype<Double> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        Double d = this.getValue(aTermAppl);
        String string = DatatypeConverter.printDouble(d);
        if (string.equals(ATermUtils.getLiteralValue(aTermAppl))) {
            return aTermAppl;
        }
        return ATermUtils.makeTypedLiteral(string, this.getName());
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        if (object instanceof Double) {
            return ATermUtils.makeTypedLiteral(DatatypeConverter.printDouble((Double)object), this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Double getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        String string = this.getLexicalForm(aTermAppl);
        try {
            return DatatypeConverter.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

