/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TaxonomyNode<T> {
    private Map<Object, Object> dataMap = new HashMap<Object, Object>();
    private Set<T> equivalents;
    private boolean hidden;
    protected Boolean mark;
    private T name;
    protected short depth = 0;
    private Set<TaxonomyNode<T>> subs = new HashSet<TaxonomyNode<T>>(2);
    private Set<TaxonomyNode<T>> supers = new HashSet<TaxonomyNode<T>>();

    public TaxonomyNode(T t, boolean bl) {
        this.name = t;
        this.hidden = bl;
        this.equivalents = t == null ? Collections.emptySet() : Collections.singleton(t);
    }

    public TaxonomyNode(Collection<T> collection, boolean bl) {
        if (collection == null || collection.isEmpty()) {
            this.name = null;
            this.equivalents = Collections.emptySet();
        } else {
            this.name = collection.iterator().next();
            this.equivalents = new HashSet<T>(collection);
        }
        this.hidden = bl;
    }

    public void addEquivalent(T t) {
        if (this.equivalents.size() < 2) {
            this.equivalents = new HashSet<T>(this.equivalents);
        }
        this.equivalents.add(t);
    }

    public void addSub(TaxonomyNode<T> taxonomyNode) {
        if (this.equals(taxonomyNode) || this.subs.contains(taxonomyNode)) {
            return;
        }
        this.subs.add(taxonomyNode);
        if (!this.hidden) {
            taxonomyNode.supers.add(this);
        }
    }

    public void addSubs(Collection<TaxonomyNode<T>> collection) {
        for (TaxonomyNode<T> taxonomyNode : collection) {
            this.addSub(taxonomyNode);
        }
    }

    public void addSupers(Collection<TaxonomyNode<T>> collection) {
        this.supers.addAll(collection);
        if (!this.hidden) {
            for (TaxonomyNode<T> taxonomyNode : collection) {
                taxonomyNode.subs.add(this);
            }
        }
    }

    public void clearData() {
        this.dataMap.clear();
    }

    public boolean contains(T t) {
        return this.equivalents.contains(t);
    }

    public void disconnect() {
        TaxonomyNode<T> taxonomyNode;
        Iterator<TaxonomyNode<T>> iterator = this.subs.iterator();
        while (iterator.hasNext()) {
            taxonomyNode = iterator.next();
            iterator.remove();
            taxonomyNode.supers.remove(this);
        }
        iterator = this.supers.iterator();
        while (iterator.hasNext()) {
            taxonomyNode = iterator.next();
            iterator.remove();
            taxonomyNode.subs.remove(this);
        }
    }

    public Object getDatum(Object object) {
        return this.dataMap.get(object);
    }

    public Set<T> getEquivalents() {
        return this.equivalents;
    }

    public T getName() {
        return this.name;
    }

    public Collection<TaxonomyNode<T>> getSubs() {
        return this.subs;
    }

    public Collection<TaxonomyNode<T>> getSupers() {
        return this.supers;
    }

    public boolean isBottom() {
        return this.subs.isEmpty();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isLeaf() {
        return this.subs.size() == 1 && this.subs.iterator().next().isBottom();
    }

    public boolean isTop() {
        return this.supers.isEmpty();
    }

    public void print() {
        this.print("");
    }

    public void print(String string) {
        if (this.subs.isEmpty()) {
            return;
        }
        System.out.print(string);
        Iterator<T> iterator = this.equivalents.iterator();
        while (iterator.hasNext()) {
            System.out.print(iterator.next());
            if (!iterator.hasNext()) continue;
            System.out.print(" = ");
        }
        System.out.println();
        string = string + "  ";
        for (TaxonomyNode<T> taxonomyNode : this.subs) {
            taxonomyNode.print(string);
        }
    }

    public Object putDatum(Object object, Object object2) {
        return this.dataMap.put(object, object2);
    }

    public Object removeDatum(Object object) {
        return this.dataMap.remove(object);
    }

    public void removeMultiplePaths() {
        if (!this.hidden) {
            for (TaxonomyNode<T> taxonomyNode : this.supers) {
                for (TaxonomyNode<T> taxonomyNode2 : this.subs) {
                    taxonomyNode.removeSub(taxonomyNode2);
                }
            }
        }
    }

    public void removeEquivalent(T t) {
        this.equivalents.remove(t);
        if (this.name != null && this.name.equals(t)) {
            this.name = this.equivalents.iterator().next();
        }
    }

    public void removeSub(TaxonomyNode<T> taxonomyNode) {
        this.subs.remove(taxonomyNode);
        taxonomyNode.supers.remove(this);
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    @Deprecated
    public void setSubs(Set<TaxonomyNode<T>> set) {
        this.subs = set;
    }

    @Deprecated
    public void setSupers(Set<TaxonomyNode<T>> set) {
        this.supers = set;
    }

    public String toString() {
        return this.name.toString();
    }
}

