/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.expressivity;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.el.ELExpressivityChecker;
import com.clarkparsia.pellet.expressivity.DLExpressivityChecker;
import com.clarkparsia.pellet.expressivity.Expressivity;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.ATermUtils;

public class ExpressivityChecker {
    private KnowledgeBase m_KB;
    private ELExpressivityChecker m_ELChecker;
    private DLExpressivityChecker m_DLChecker;
    private Expressivity m_Expressivity;

    public ExpressivityChecker(KnowledgeBase knowledgeBase) {
        this(knowledgeBase, new Expressivity());
    }

    public ExpressivityChecker(KnowledgeBase knowledgeBase, Expressivity expressivity) {
        this.m_KB = knowledgeBase;
        this.m_ELChecker = new ELExpressivityChecker(this.m_KB);
        this.m_DLChecker = new DLExpressivityChecker(this.m_KB);
        this.m_Expressivity = expressivity;
    }

    public void prepare() {
        this.m_Expressivity = new Expressivity();
        if (this.m_ELChecker.compute(this.m_Expressivity)) {
            return;
        }
        this.m_Expressivity = new Expressivity();
        this.m_Expressivity.setHasAllValues(true);
        this.m_DLChecker.compute(this.m_Expressivity);
    }

    public Expressivity getExpressivity() {
        return this.m_Expressivity;
    }

    public Expressivity getExpressivityWith(ATermAppl aTermAppl) {
        if (aTermAppl == null) {
            return this.m_Expressivity;
        }
        Expressivity expressivity = new Expressivity(this.m_Expressivity);
        this.m_DLChecker.updateWith(expressivity, aTermAppl);
        return expressivity;
    }

    public void updateWithIndividual(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        ATermAppl aTermAppl3 = ATermUtils.makeValue((ATerm)aTermAppl);
        if (aTermAppl2.equals(aTermAppl3)) {
            return;
        }
        this.m_DLChecker.updateWith(this.m_Expressivity, aTermAppl2);
    }
}

