/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.PartialOrderComparator;

public class PartialOrderBuilder<T> {
    private static final boolean CHILDREN_SEARCH = false;
    private static final boolean PARENTS_SEARCH = true;
    private PartialOrderComparator<T> comparator;
    private Taxonomy<T> taxonomy;

    public static <T> Taxonomy<T> build(Collection<? extends T> collection, PartialOrderComparator<T> partialOrderComparator) {
        return PartialOrderBuilder.build(collection, partialOrderComparator, null, null);
    }

    public static <T> Taxonomy<T> build(Collection<? extends T> collection, PartialOrderComparator<T> partialOrderComparator, T t, T t2) {
        Taxonomy<T> taxonomy = new Taxonomy<T>(null, t, t2);
        PartialOrderBuilder<? extends T> partialOrderBuilder = new PartialOrderBuilder<T>(taxonomy, partialOrderComparator);
        partialOrderBuilder.addAll(collection);
        return taxonomy;
    }

    public PartialOrderBuilder(Taxonomy<T> taxonomy, PartialOrderComparator<T> partialOrderComparator) {
        this.taxonomy = taxonomy;
        this.comparator = partialOrderComparator;
    }

    public void add(T t) {
        this.add(t, false);
    }

    public void add(T t, boolean bl) {
        Set<T> set = this.taxonomy.getClasses();
        int n = set.size();
        if (n == 0) {
            Set set2 = Collections.emptySet();
            this.taxonomy.addNode(Collections.singleton(t), set2, set2, false);
        } else {
            Set<Set<Object>> set2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (TaxonomyNode<T> object2 : this.taxonomy.getTop().getSubs()) {
                arrayList.add(object2.getName());
            }
            Collection<T> collection = this.search(this.taxonomy, t, arrayList, this.comparator, true);
            if (collection == null) {
                return;
            }
            arrayList = new ArrayList();
            HashSet hashSet = new HashSet();
            LinkedList<Set<Object>> linkedList = new LinkedList<Set<Object>>();
            if (collection.isEmpty()) {
                for (TaxonomyNode taxonomyNode : this.taxonomy.getBottom().getSupers()) {
                    arrayList.add(taxonomyNode.getName());
                }
            } else {
                for (Object object : collection) {
                    set2 = this.taxonomy.getSubs(object, true);
                    if (set2.isEmpty()) continue;
                    linkedList.addAll(set2);
                }
            }
            Set<Set<T>> set3 = Collections.singleton(this.taxonomy.getBottom().getEquivalents());
            while (!linkedList.isEmpty()) {
                Set set4 = (Set)linkedList.remove();
                assert (!set4.isEmpty());
                set2 = set4.iterator().next();
                if (hashSet.contains(set2)) continue;
                hashSet.addAll(set4);
                Set<Set<Set<Set<Object>>>> set5 = this.taxonomy.getSubs(set2, true);
                if (set5.equals(set3)) {
                    arrayList.add(set2);
                    continue;
                }
                linkedList.addAll(set5);
            }
            Collection<T> collection2 = this.search(this.taxonomy, t, arrayList, this.comparator, false);
            if (collection2 == null) {
                return;
            }
            this.taxonomy.addNode(Collections.singleton(t), collection, collection2, bl);
        }
    }

    public void addAll(Collection<? extends T> collection) {
        for (T t : collection) {
            this.add(t);
        }
    }

    public PartialOrderComparator<T> getComparator() {
        return this.comparator;
    }

    public Taxonomy<T> getTaxonomy() {
        return this.taxonomy;
    }

    private Collection<T> search(Taxonomy<T> taxonomy, T t, Collection<T> collection, PartialOrderComparator<T> partialOrderComparator, boolean bl) {
        ArrayList arrayList = new ArrayList();
        LinkedList<Map<Object, Collection<Object>>> linkedList = new LinkedList<Map<Object, Collection<Object>>>();
        linkedList.add(Collections.singletonMap(null, collection));
        HashSet<T> hashSet = new HashSet<T>();
        while (!linkedList.isEmpty()) {
            Map.Entry entry = ((Map)linkedList.remove()).entrySet().iterator().next();
            Object k = entry.getKey();
            if (k != null) {
                if (hashSet.contains(k)) continue;
                hashSet.addAll(taxonomy.getAllEquivalents(k));
            }
            boolean bl2 = false;
            Collection collection2 = (Collection)entry.getValue();
            for (Object e : collection2) {
                switch (partialOrderComparator.compare(t, e)) {
                    case LESS: {
                        if (!bl) break;
                        Set<Set<T>> set = taxonomy.getSubs(e, true);
                        ArrayList<T> arrayList2 = new ArrayList(set.size());
                        for (Set<T> set2 : set) {
                            arrayList2.add(set2.iterator().next());
                        }
                        linkedList.add(Collections.singletonMap(e, arrayList2));
                        bl2 = true;
                        break;
                    }
                    case EQUAL: {
                        taxonomy.addEquivalents(e, Collections.singleton(t));
                        return null;
                    }
                    case GREATER: {
                        if (bl) break;
                        Set<Set<T>> set = taxonomy.getSupers(e, true);
                        ArrayList<T> arrayList2 = new ArrayList<T>(set.size());
                        for (Set<T> set2 : set) {
                            arrayList2.add(set2.iterator().next());
                        }
                        linkedList.add(Collections.singletonMap(e, arrayList2));
                        bl2 = true;
                        break;
                    }
                }
            }
            if (bl2 || k == null) continue;
            arrayList.add(k);
        }
        return arrayList;
    }

    public void setComparator(PartialOrderComparator<T> partialOrderComparator) {
        this.comparator = partialOrderComparator;
    }

    public void setTaxonomy(Taxonomy<T> taxonomy) {
        this.taxonomy = taxonomy;
    }
}

