/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.List;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.branch.ChooseBranch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.ATermUtils;

public class ChooseRule
extends AbstractTableauRule {
    public ChooseRule(CompletionStrategy completionStrategy) {
        super(completionStrategy, NodeSelector.CHOOSE, AbstractTableauRule.BlockingType.INDIRECT);
    }

    @Override
    public void apply(Individual individual) {
        if (!individual.canApply(5)) {
            return;
        }
        List<ATermAppl> list = individual.getTypes(5);
        for (ATermAppl aTermAppl : list) {
            this.apply(individual, aTermAppl);
        }
    }

    protected void apply(Individual individual, ATermAppl aTermAppl) {
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        Role role = this.strategy.getABox().getRole(aTermAppl2.getArgument(0));
        ATermAppl aTermAppl3 = (ATermAppl)aTermAppl2.getArgument(2);
        if (ATermUtils.isTop(aTermAppl3)) {
            return;
        }
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && individual.getDepends((ATerm)aTermAppl) == null) {
            return;
        }
        EdgeList edgeList = individual.getRNeighborEdges(role);
        for (Edge edge : edgeList) {
            Node node = edge.getNeighbor(individual);
            if (node.hasType((ATerm)aTermAppl3) || node.hasType((ATerm)ATermUtils.negate(aTermAppl3))) continue;
            ChooseBranch chooseBranch = new ChooseBranch(this.strategy.getABox(), this.strategy, node, aTermAppl3, individual.getDepends((ATerm)aTermAppl));
            this.strategy.addBranch(chooseBranch);
            chooseBranch.tryNext();
            if (!this.strategy.getABox().isClosed()) continue;
            return;
        }
    }
}

