/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.PropertyType;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.fsm.TransitionGraph;

public class Role {
    @Deprecated
    public static final String[] TYPES = new String[]{"Untyped", "Object", "Datatype", "Annotation", "Ontology"};
    @Deprecated
    public static final int UNTYPED = 0;
    @Deprecated
    public static final int OBJECT = 1;
    @Deprecated
    public static final int DATATYPE = 2;
    @Deprecated
    public static final int ANNOTATION = 3;
    @Deprecated
    public static final int ONTOLOGY = 4;
    private ATermAppl name;
    private PropertyType type = PropertyType.UNTYPED;
    private Role inverse = null;
    private Set<Role> subRoles = SetUtils.emptySet();
    private Set<Role> superRoles = SetUtils.emptySet();
    private Map<Role, DependencySet> disjointRoles = Collections.emptyMap();
    private Set<ATermList> subRoleChains = SetUtils.emptySet();
    private Set<Role> functionalSupers = SetUtils.emptySet();
    private Set<Role> transitiveSubRoles = SetUtils.emptySet();
    private TransitionGraph<Role> tg;
    public static int TRANSITIVE = 1;
    public static int FUNCTIONAL = 2;
    public static int INV_FUNCTIONAL = 4;
    public static int REFLEXIVE = 8;
    public static int IRREFLEXIVE = 16;
    public static int ASYM;
    public static int ANTI_SYM;
    public static int SIMPLE;
    public static int COMPLEX_SUB;
    public static int FORCE_SIMPLE;
    private int flags = SIMPLE;
    private DependencySet explainAsymmetric = DependencySet.INDEPENDENT;
    private DependencySet explainFunctional = DependencySet.INDEPENDENT;
    private DependencySet explainIrreflexive = DependencySet.INDEPENDENT;
    private DependencySet explainReflexive = DependencySet.INDEPENDENT;
    private DependencySet explainSymmetric = DependencySet.INDEPENDENT;
    private DependencySet explainTransitive = DependencySet.INDEPENDENT;
    private DependencySet explainInverseFunctional = DependencySet.INDEPENDENT;
    private Map<ATerm, DependencySet> explainSub = new HashMap<ATerm, DependencySet>();
    private Map<ATerm, DependencySet> explainSup = new HashMap<ATerm, DependencySet>();
    private Map<ATermAppl, DependencySet> domains = Collections.emptyMap();
    private Map<ATermAppl, DependencySet> ranges = Collections.emptyMap();

    public Role(ATermAppl aTermAppl) {
        this(aTermAppl, PropertyType.UNTYPED);
    }

    public Role(ATermAppl aTermAppl, PropertyType propertyType) {
        this.name = aTermAppl;
        this.type = propertyType;
        this.addSubRole(this, DependencySet.INDEPENDENT);
        this.addSuperRole(this, DependencySet.INDEPENDENT);
    }

    public boolean equals(Object object) {
        if (object instanceof Role) {
            return this.name.equals(((Role)object).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return ATermUtils.toString(this.name);
    }

    public String debugString() {
        String string = "(" + (Object)((Object)this.type) + "Role " + this.name;
        if (this.isTransitive()) {
            string = string + " Transitive";
        }
        if (this.isReflexive()) {
            string = string + " Reflexive";
        }
        if (this.isIrreflexive()) {
            string = string + " Irreflexive";
        }
        if (this.isSymmetric()) {
            string = string + " Symmetric";
        }
        if (this.isAsymmetric()) {
            string = string + " Asymmetric";
        }
        if (this.isFunctional()) {
            string = string + " Functional";
        }
        if (this.isInverseFunctional()) {
            string = string + " InverseFunctional";
        }
        if (this.hasComplexSubRole()) {
            string = string + " ComplexSubRole";
        }
        if (this.isSimple()) {
            string = string + " Simple";
        }
        if (this.type == PropertyType.OBJECT || this.type == PropertyType.DATATYPE) {
            string = string + " domain=" + this.domains;
            string = string + " range=" + this.ranges;
            string = string + " superPropertyOf=" + this.subRoles;
            string = string + " subPropertyOf=" + this.superRoles;
            string = string + " hasSubPropertyChain=" + this.subRoleChains;
            string = string + " disjointWith=" + this.disjointRoles;
        }
        string = string + ")";
        return string;
    }

    public void addSubRoleChain(ATermList aTermList) {
        this.addSubRoleChain(aTermList, DependencySet.INDEPENDENT);
    }

    public void addSubRoleChain(ATermList aTermList, DependencySet dependencySet) {
        if (aTermList.isEmpty()) {
            throw new InternalReasonerException("Adding a subproperty chain that is empty!");
        }
        if (aTermList.getLength() == 1) {
            throw new InternalReasonerException("Adding a subproperty chain that has a single element!");
        }
        this.subRoleChains = SetUtils.add(aTermList, this.subRoleChains);
        this.explainSub.put((ATerm)aTermList, dependencySet);
        this.setSimple(false);
        if (ATermUtils.isTransitiveChain(aTermList, (ATerm)this.name) && !this.isTransitive()) {
            this.setTransitive(true, dependencySet);
        }
    }

    public void removeSubRoleChain(ATermList aTermList) {
        this.subRoleChains = SetUtils.remove(aTermList, this.subRoleChains);
        this.explainSub.remove(aTermList);
        if (this.isTransitive() && ATermUtils.isTransitiveChain(aTermList, (ATerm)this.name)) {
            this.setTransitive(false, null);
        }
    }

    public void removeSubRoleChains() {
        this.subRoleChains = Collections.emptySet();
        if (this.isTransitive()) {
            this.setTransitive(false, null);
        }
    }

    public void addSubRole(Role role) {
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSubProp((ATerm)role.getName(), (ATerm)this.getName())) : DependencySet.INDEPENDENT;
        this.addSubRole(role, dependencySet);
    }

    public void addSubRole(Role role, DependencySet dependencySet) {
        if (PelletOptions.USE_TRACING && this.explainSub.get(role.getName()) == null) {
            this.explainSub.put((ATerm)role.getName(), dependencySet);
        }
        this.subRoles = SetUtils.add(role, this.subRoles);
        this.explainSub.put((ATerm)role.getName(), dependencySet);
    }

    public boolean removeDomain(ATermAppl aTermAppl, DependencySet dependencySet) {
        DependencySet dependencySet2 = this.domains.get(aTermAppl);
        if (dependencySet2 != null && dependencySet.getExplain().equals(dependencySet2.getExplain())) {
            this.domains.remove(aTermAppl);
            return true;
        }
        return false;
    }

    public boolean removeRange(ATermAppl aTermAppl, DependencySet dependencySet) {
        DependencySet dependencySet2 = this.ranges.get(aTermAppl);
        if (dependencySet2 != null && dependencySet.getExplain().equals(dependencySet2.getExplain())) {
            this.ranges.remove(aTermAppl);
            return true;
        }
        return false;
    }

    void resetDomainRange() {
        this.domains = Collections.emptyMap();
        this.ranges = Collections.emptyMap();
    }

    public void removeSubRole(Role role) {
        this.subRoles = SetUtils.remove(role, this.subRoles);
    }

    public void addSuperRole(Role role) {
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSubProp((ATerm)this.name, (ATerm)role.getName())) : DependencySet.INDEPENDENT;
        this.addSuperRole(role, dependencySet);
    }

    public void addSuperRole(Role role, DependencySet dependencySet) {
        this.superRoles = SetUtils.add(role, this.superRoles);
        this.explainSup.put((ATerm)role.getName(), dependencySet);
    }

    public void addDisjointRole(Role role, DependencySet dependencySet) {
        if (this.disjointRoles.isEmpty()) {
            this.disjointRoles = new HashMap<Role, DependencySet>();
        }
        this.disjointRoles.put(role, dependencySet);
    }

    public boolean addDomain(ATermAppl aTermAppl, DependencySet dependencySet) {
        DependencySet dependencySet2;
        if (this.domains.isEmpty()) {
            this.domains = CollectionUtils.makeMap();
        }
        return (dependencySet2 = this.domains.put(aTermAppl, dependencySet)) == null || !dependencySet2.getExplain().equals(dependencySet.getExplain());
    }

    public boolean addRange(ATermAppl aTermAppl, DependencySet dependencySet) {
        DependencySet dependencySet2;
        if (this.ranges.isEmpty()) {
            this.ranges = CollectionUtils.makeMap();
        }
        return (dependencySet2 = this.ranges.put(aTermAppl, dependencySet)) == null || !dependencySet2.getExplain().equals(dependencySet.getExplain());
    }

    public boolean isObjectRole() {
        return this.type == PropertyType.OBJECT;
    }

    public boolean isDatatypeRole() {
        return this.type == PropertyType.DATATYPE;
    }

    @Deprecated
    public boolean isOntologyRole() {
        return false;
    }

    public boolean isAnnotationRole() {
        return this.type == PropertyType.ANNOTATION;
    }

    public boolean isUntypedRole() {
        return this.type == PropertyType.UNTYPED;
    }

    public Role getInverse() {
        return this.inverse;
    }

    public boolean hasNamedInverse() {
        return this.inverse != null && !this.inverse.isAnon();
    }

    public boolean hasComplexSubRole() {
        return (this.flags & COMPLEX_SUB) != 0;
    }

    public boolean isFunctional() {
        return (this.flags & FUNCTIONAL) != 0;
    }

    public boolean isInverseFunctional() {
        return (this.flags & INV_FUNCTIONAL) != 0;
    }

    public boolean isSymmetric() {
        return this.inverse != null && this.isEquivalent(this.inverse);
    }

    public boolean isAntisymmetric() {
        return (this.flags & ASYM) != 0;
    }

    public boolean isAsymmetric() {
        return (this.flags & ASYM) != 0;
    }

    public boolean isTransitive() {
        return (this.flags & TRANSITIVE) != 0;
    }

    public boolean isReflexive() {
        return (this.flags & REFLEXIVE) != 0;
    }

    public boolean isIrreflexive() {
        return (this.flags & IRREFLEXIVE) != 0;
    }

    public boolean isAnon() {
        return this.name.getArity() != 0;
    }

    public ATermAppl getName() {
        return this.name;
    }

    public Set<ATermAppl> getDomains() {
        return this.domains.keySet();
    }

    public Set<ATermAppl> getRanges() {
        return this.ranges.keySet();
    }

    public Set<Role> getSubRoles() {
        return Collections.unmodifiableSet(this.subRoles);
    }

    public Set<Role> getEquivalentProperties() {
        return SetUtils.intersection(this.subRoles, this.superRoles);
    }

    public boolean isEquivalent(Role role) {
        return this.subRoles.contains(role) && this.superRoles.contains(role);
    }

    public Set<Role> getProperSubRoles() {
        return SetUtils.difference(this.subRoles, this.superRoles);
    }

    public Set<ATermList> getSubRoleChains() {
        return this.subRoleChains;
    }

    public Set<Role> getSuperRoles() {
        return Collections.unmodifiableSet(this.superRoles);
    }

    public Set<Role> getDisjointRoles() {
        return Collections.unmodifiableSet(this.disjointRoles.keySet());
    }

    public DependencySet getExplainDisjointRole(Role role) {
        return this.disjointRoles.get(role);
    }

    public PropertyType getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.type.toString();
    }

    public boolean isSubRoleOf(Role role) {
        return this.superRoles.contains(role);
    }

    public boolean isSuperRoleOf(Role role) {
        return this.subRoles.contains(role);
    }

    public void setInverse(Role role) {
        this.inverse = role;
    }

    public void setFunctional(boolean bl) {
        DependencySet dependencySet = DependencySet.INDEPENDENT;
        this.setFunctional(bl, dependencySet);
    }

    public void setFunctional(boolean bl, DependencySet dependencySet) {
        if (bl) {
            this.flags |= FUNCTIONAL;
            this.explainFunctional = dependencySet;
        } else {
            this.flags &= ~FUNCTIONAL;
            this.explainFunctional = DependencySet.INDEPENDENT;
        }
    }

    public void setInverseFunctional(boolean bl) {
        this.setInverseFunctional(bl, DependencySet.INDEPENDENT);
    }

    public void setInverseFunctional(boolean bl, DependencySet dependencySet) {
        if (bl) {
            this.flags |= INV_FUNCTIONAL;
            this.explainInverseFunctional = dependencySet;
        } else {
            this.flags &= ~INV_FUNCTIONAL;
            this.explainInverseFunctional = DependencySet.INDEPENDENT;
        }
    }

    public void setTransitive(boolean bl) {
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeTransitive((ATerm)this.name)) : DependencySet.INDEPENDENT;
        this.setTransitive(bl, dependencySet);
    }

    public void setTransitive(boolean bl, DependencySet dependencySet) {
        ATermList aTermList = ATermUtils.makeList(new ATerm[]{this.name, this.name});
        if (bl) {
            this.flags |= TRANSITIVE;
            this.explainTransitive = dependencySet;
            this.addSubRoleChain(aTermList, dependencySet);
        } else {
            this.flags &= ~TRANSITIVE;
            this.explainTransitive = dependencySet;
            this.removeSubRoleChain(aTermList);
        }
    }

    public void setReflexive(boolean bl) {
        this.setReflexive(bl, DependencySet.INDEPENDENT);
    }

    public void setReflexive(boolean bl, DependencySet dependencySet) {
        this.flags = bl ? (this.flags |= REFLEXIVE) : (this.flags &= ~REFLEXIVE);
        this.explainReflexive = dependencySet;
    }

    public void setIrreflexive(boolean bl) {
        this.setIrreflexive(bl, DependencySet.INDEPENDENT);
    }

    public void setIrreflexive(boolean bl, DependencySet dependencySet) {
        this.flags = bl ? (this.flags |= IRREFLEXIVE) : (this.flags &= ~IRREFLEXIVE);
        this.explainIrreflexive = dependencySet;
    }

    public void setAntisymmetric(boolean bl) {
        this.setAsymmetric(bl, DependencySet.INDEPENDENT);
    }

    public void setAsymmetric(boolean bl) {
        this.setAsymmetric(bl, DependencySet.INDEPENDENT);
    }

    public void setAntisymmetric(boolean bl, DependencySet dependencySet) {
        this.setAsymmetric(bl, dependencySet);
    }

    public void setAsymmetric(boolean bl, DependencySet dependencySet) {
        this.flags = bl ? (this.flags |= ANTI_SYM) : (this.flags &= ~ANTI_SYM);
        this.explainAsymmetric = dependencySet;
    }

    public void setHasComplexSubRole(boolean bl) {
        if (bl == this.hasComplexSubRole()) {
            return;
        }
        this.flags = bl ? (this.flags |= COMPLEX_SUB) : (this.flags &= ~COMPLEX_SUB);
        if (this.inverse != null) {
            this.inverse.setHasComplexSubRole(bl);
        }
        if (bl) {
            this.setSimple(false);
        }
    }

    public void setType(PropertyType propertyType) {
        this.type = propertyType;
    }

    public void setSubRolesAndChains(Set<Role> set, Set<ATermList> set2, Map<ATerm, DependencySet> map) {
        this.subRoles = set;
        this.subRoleChains = set2;
        this.explainSub = map;
    }

    public void setSuperRoles(Set<Role> set) {
        this.superRoles = set;
    }

    public Set<Role> getFunctionalSupers() {
        return this.functionalSupers;
    }

    public void addFunctionalSuper(Role role) {
        for (Role role2 : this.functionalSupers) {
            if (role2.isSubRoleOf(role)) {
                this.functionalSupers = SetUtils.remove(role2, this.functionalSupers);
                break;
            }
            if (!role.isSubRoleOf(role2)) continue;
            return;
        }
        this.functionalSupers = SetUtils.add(role, this.functionalSupers);
    }

    public void setForceSimple(boolean bl) {
        if (bl == this.isForceSimple()) {
            return;
        }
        this.flags = bl ? (this.flags |= FORCE_SIMPLE) : (this.flags &= ~FORCE_SIMPLE);
        if (this.inverse != null) {
            this.inverse.setForceSimple(bl);
        }
    }

    public boolean isForceSimple() {
        return (this.flags & FORCE_SIMPLE) != 0;
    }

    public boolean isSimple() {
        return (this.flags & SIMPLE) != 0;
    }

    void setSimple(boolean bl) {
        if (bl == this.isSimple()) {
            return;
        }
        this.flags = bl ? (this.flags |= SIMPLE) : (this.flags &= ~SIMPLE);
        if (this.inverse != null) {
            this.inverse.setSimple(bl);
        }
    }

    public Set<Role> getTransitiveSubRoles() {
        return this.transitiveSubRoles;
    }

    public void addTransitiveSubRole(Role role) {
        this.setSimple(false);
        if (this.transitiveSubRoles.isEmpty()) {
            this.transitiveSubRoles = SetUtils.singleton(role);
        } else if (this.transitiveSubRoles.size() == 1) {
            Role role2 = this.transitiveSubRoles.iterator().next();
            if (role2.isSubRoleOf(role)) {
                this.transitiveSubRoles = SetUtils.singleton(role);
            } else if (!role.isSubRoleOf(role2)) {
                this.transitiveSubRoles = new HashSet<Role>(2);
                this.transitiveSubRoles.add(role2);
                this.transitiveSubRoles.add(role);
            }
        } else {
            for (Role role3 : this.transitiveSubRoles) {
                if (role3.isSubRoleOf(role)) {
                    this.transitiveSubRoles.remove(role3);
                    this.transitiveSubRoles.add(role);
                    return;
                }
                if (!role.isSubRoleOf(role3)) continue;
                return;
            }
            this.transitiveSubRoles.add(role);
        }
    }

    public void setFSM(TransitionGraph<Role> transitionGraph) {
        this.tg = transitionGraph;
    }

    public TransitionGraph<Role> getFSM() {
        return this.tg;
    }

    public DependencySet getExplainAsymmetric() {
        return this.explainAsymmetric;
    }

    public DependencySet getExplainDomain(ATermAppl aTermAppl) {
        return this.domains.get(aTermAppl);
    }

    public DependencySet getExplainFunctional() {
        return this.explainFunctional;
    }

    public DependencySet getExplainInverseFunctional() {
        return this.explainInverseFunctional;
    }

    public DependencySet getExplainIrreflexive() {
        return this.explainIrreflexive;
    }

    public DependencySet getExplainRange(ATermAppl aTermAppl) {
        return this.ranges.get(aTermAppl);
    }

    public DependencySet getExplainReflexive() {
        return this.explainReflexive;
    }

    public DependencySet getExplainSub(ATerm aTerm) {
        DependencySet dependencySet = this.explainSub.get(aTerm);
        if (dependencySet == null) {
            return DependencySet.INDEPENDENT;
        }
        return dependencySet;
    }

    public DependencySet getExplainSubOrInv(Role role) {
        DependencySet dependencySet = this.explainSub.get(role.getName());
        if (dependencySet == null) {
            return this.inverse.getExplainSub((ATerm)role.getName());
        }
        return dependencySet;
    }

    public DependencySet getExplainSuper(ATerm aTerm) {
        DependencySet dependencySet = this.explainSup.get(aTerm);
        if (dependencySet == null) {
            return DependencySet.INDEPENDENT;
        }
        return dependencySet;
    }

    public DependencySet getExplainSymmetric() {
        return this.explainSymmetric;
    }

    public DependencySet getExplainTransitive() {
        return this.explainTransitive;
    }

    public boolean isTop() {
        return this.name.equals(TermFactory.TOP_OBJECT_PROPERTY) || this.name.equals(TermFactory.TOP_DATA_PROPERTY);
    }

    public boolean isBottom() {
        return this.name.equals(TermFactory.BOTTOM_OBJECT_PROPERTY) || this.name.equals(TermFactory.BOTTOM_DATA_PROPERTY);
    }

    public boolean isBuiltin() {
        return this.isTop() || this.isBottom() || this.inverse != null && (this.inverse.isTop() || this.inverse.isBottom());
    }

    static {
        ANTI_SYM = ASYM = 32;
        SIMPLE = 64;
        COMPLEX_SUB = 128;
        FORCE_SIMPLE = 256;
    }
}

