/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.tableau.completion.incremental.DependencyIndex;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.intset.IntSet;
import org.mindswap.pellet.utils.intset.IntSetFactory;

public class DependencySet {
    public static final Logger log = Logger.getLogger(DependencySet.class.getName());
    public static final int NO_BRANCH = -1;
    public static final DependencySet EMPTY;
    public static final DependencySet INDEPENDENT;
    public static final IntSet ZERO;
    public static final DependencySet DUMMY;
    private IntSet depends;
    private int branch = NO_BRANCH;
    private Set<ATermAppl> explain;

    private DependencySet() {
        this.depends = IntSetFactory.create();
        this.setExplain(SetUtils.emptySet());
    }

    public DependencySet(int n) {
        this.depends = IntSetFactory.create();
        this.depends.add(n);
        this.setExplain(SetUtils.emptySet());
    }

    private DependencySet(int n, IntSet intSet, Set<ATermAppl> set) {
        this.branch = n;
        this.depends = intSet;
        this.setExplain(set);
    }

    public DependencySet(ATermAppl aTermAppl) {
        this.depends = ZERO;
        this.setExplain(SetUtils.singleton(aTermAppl));
    }

    public DependencySet(Set<ATermAppl> set) {
        this.depends = ZERO;
        this.setExplain(set);
    }

    public DependencySet copy(int n) {
        return new DependencySet(n, this.depends, this.explain);
    }

    public boolean contains(int n) {
        return this.depends.contains(n);
    }

    public void add(int n) {
        this.depends.add(n);
    }

    public void remove(int n) {
        this.depends.remove(n);
    }

    public boolean isIndependent() {
        return this.max() <= 0;
    }

    public int getBranch() {
        return this.branch;
    }

    public int size() {
        return this.depends.size();
    }

    public int max() {
        return this.depends.isEmpty() ? -1 : this.depends.max();
    }

    public DependencySet union(IntSet intSet) {
        return new DependencySet(this.branch, this.depends.union(intSet), this.explain);
    }

    public DependencySet union(DependencySet dependencySet, boolean bl) {
        IntSet intSet = this.depends.union(dependencySet.depends);
        Set<Object> set = bl ? SetUtils.union(this.explain, dependencySet.explain) : SetUtils.emptySet();
        return new DependencySet(this.branch, intSet, set);
    }

    public DependencySet union(Set<ATermAppl> set, boolean bl) {
        if (!bl || set.isEmpty()) {
            return this;
        }
        return new DependencySet(this.branch, this.depends.copy(), SetUtils.union(this.explain, set));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.branch);
        stringBuilder.append("-");
        stringBuilder.append(this.depends);
        if (log.isLoggable(Level.FINE)) {
            stringBuilder.append(" ");
            stringBuilder.append(this.explain);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void removeExplain(ATermAppl aTermAppl) {
        if (this.getExplain().contains(aTermAppl)) {
            this.setExplain(new HashSet<ATermAppl>());
            if (DependencyIndex.log.isLoggable(Level.FINE)) {
                DependencyIndex.log.fine("             Explain: removed ");
            }
        }
    }

    public void setDepends(IntSet intSet) {
        this.depends = intSet;
    }

    public IntSet getDepends() {
        return this.depends;
    }

    public void setExplain(Set<ATermAppl> set) {
        this.explain = set;
    }

    public Set<ATermAppl> getExplain() {
        return this.explain;
    }

    public DependencySet cache() {
        if (this.isIndependent()) {
            return INDEPENDENT;
        }
        return DUMMY;
    }

    static {
        ZERO = IntSetFactory.create();
        ZERO.add(0);
        EMPTY = new DependencySet();
        INDEPENDENT = new DependencySet(0);
        DUMMY = new DependencySet(1);
    }
}

