/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.model;

import com.clarkparsia.pellet.sparqldl.model.Filter;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;

public class MultiFilterWrapper
implements Filter {
    private FilterType type;
    private Filter[] filters;

    private MultiFilterWrapper(FilterType filterType, Filter ... filterArray) {
        this.type = filterType;
        this.filters = filterArray;
    }

    @Override
    public boolean accept(ResultBinding resultBinding) {
        switch (this.type) {
            case AND: {
                for (Filter filter : this.filters) {
                    if (filter.accept(resultBinding)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (Filter filter : this.filters) {
                    if (!filter.accept(resultBinding)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("Filter type not supported : " + (Object)((Object)this.type));
    }

    public static Filter and(Filter ... filterArray) {
        return new MultiFilterWrapper(FilterType.AND, filterArray);
    }

    public static Filter or(Filter ... filterArray) {
        return new MultiFilterWrapper(FilterType.OR, filterArray);
    }

    private static enum FilterType {
        AND,
        OR;

    }
}

