/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.utils.TermFactory;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.utils.ATermUtils;

public class RuleAtomAsserter
implements RuleAtomVisitor {
    private ABox abox;
    private CompletionStrategy strategy;
    private VariableBinding binding;
    private DependencySet ds;
    private boolean negated;
    private boolean asserted;

    public boolean assertAtom(RuleAtom ruleAtom, VariableBinding variableBinding, DependencySet dependencySet, boolean bl, ABox aBox, CompletionStrategy completionStrategy) {
        this.asserted = true;
        this.binding = variableBinding;
        this.ds = dependencySet;
        this.negated = bl;
        this.strategy = completionStrategy;
        this.abox = aBox;
        ruleAtom.accept(this);
        return this.asserted;
    }

    @Override
    public void visit(BuiltInAtom builtInAtom) {
        this.asserted = false;
    }

    @Override
    public void visit(ClassAtom classAtom) {
        ATermAppl aTermAppl = (ATermAppl)classAtom.getPredicate();
        ATermAppl aTermAppl2 = this.binding.get((AtomIObject)classAtom.getArgument()).getName();
        this.addType(aTermAppl2, aTermAppl);
    }

    private void addType(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Individual individual = this.abox.getIndividual((ATerm)aTermAppl).getSame();
        if (this.negated) {
            aTermAppl2 = ATermUtils.negate(aTermAppl2);
        }
        this.strategy.addType(individual, aTermAppl2, this.ds);
    }

    private void addEdge(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        Individual individual = this.abox.getIndividual((ATerm)aTermAppl2).getSame();
        if (this.negated) {
            ATermAppl aTermAppl4 = TermFactory.all(aTermAppl, TermFactory.not(TermFactory.value(aTermAppl3)));
            this.strategy.addType(individual, aTermAppl4, this.ds);
        } else {
            Node node = this.abox.getNode((ATerm)aTermAppl3).getSame();
            this.strategy.addEdge(individual, this.abox.getRole((ATerm)aTermAppl), node, this.ds);
        }
    }

    @Override
    public void visit(DataRangeAtom dataRangeAtom) {
        this.asserted = false;
    }

    @Override
    public void visit(DatavaluedPropertyAtom datavaluedPropertyAtom) {
        ATermAppl aTermAppl = (ATermAppl)datavaluedPropertyAtom.getPredicate();
        ATermAppl aTermAppl2 = this.binding.get((AtomIObject)datavaluedPropertyAtom.getArgument1()).getName();
        ATermAppl aTermAppl3 = this.binding.get((AtomDObject)datavaluedPropertyAtom.getArgument2()).getName();
        this.addEdge(aTermAppl, aTermAppl2, aTermAppl3);
    }

    @Override
    public void visit(DifferentIndividualsAtom differentIndividualsAtom) {
        ATermAppl aTermAppl = this.binding.get((AtomIObject)differentIndividualsAtom.getArgument1()).getName();
        ATermAppl aTermAppl2 = this.binding.get((AtomIObject)differentIndividualsAtom.getArgument2()).getName();
        ATermAppl aTermAppl3 = TermFactory.not(TermFactory.value(aTermAppl2));
        this.addType(aTermAppl, aTermAppl3);
    }

    @Override
    public void visit(IndividualPropertyAtom individualPropertyAtom) {
        ATermAppl aTermAppl = (ATermAppl)individualPropertyAtom.getPredicate();
        ATermAppl aTermAppl2 = this.binding.get((AtomIObject)individualPropertyAtom.getArgument1()).getName();
        ATermAppl aTermAppl3 = this.binding.get((AtomIObject)individualPropertyAtom.getArgument2()).getName();
        this.addEdge(aTermAppl, aTermAppl2, aTermAppl3);
    }

    @Override
    public void visit(SameIndividualAtom sameIndividualAtom) {
        ATermAppl aTermAppl = this.binding.get((AtomIObject)sameIndividualAtom.getArgument1()).getName();
        ATermAppl aTermAppl2 = this.binding.get((AtomIObject)sameIndividualAtom.getArgument2()).getName();
        ATermAppl aTermAppl3 = TermFactory.value(aTermAppl2);
        this.addType(aTermAppl, aTermAppl3);
    }
}

