/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.bool;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.EmptyIterator;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class RestrictedBooleanDatatype
implements RestrictedDatatype<Boolean> {
    private final Datatype<Boolean> dt;
    private final boolean permitFalse;
    private final boolean permitTrue;

    public RestrictedBooleanDatatype(Datatype<Boolean> datatype) {
        this.dt = datatype;
        this.permitTrue = true;
        this.permitFalse = true;
    }

    private RestrictedBooleanDatatype(RestrictedBooleanDatatype restrictedBooleanDatatype, boolean bl, boolean bl2) {
        this.dt = restrictedBooleanDatatype.dt;
        this.permitFalse = bl2;
        this.permitTrue = bl;
    }

    @Override
    public RestrictedDatatype<Boolean> applyConstrainingFacet(ATermAppl aTermAppl, Object object) throws InvalidConstrainingFacetException {
        throw new InvalidConstrainingFacetException(aTermAppl, object);
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            if (bl.booleanValue()) {
                return this.permitTrue;
            }
            return this.permitFalse;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        if (n <= 0) {
            return true;
        }
        if (n == 1) {
            return this.permitTrue || this.permitFalse;
        }
        if (n == 2) {
            return this.permitTrue && this.permitFalse;
        }
        return false;
    }

    @Override
    public RestrictedDatatype<Boolean> exclude(Collection<?> collection) {
        boolean bl = this.permitTrue;
        boolean bl2 = this.permitFalse;
        for (Object obj : collection) {
            if (!(obj instanceof Boolean)) continue;
            Boolean bl3 = (Boolean)obj;
            if (bl3.booleanValue()) {
                bl = false;
                continue;
            }
            bl2 = false;
        }
        if (bl == this.permitTrue && bl2 == this.permitFalse) {
            return this;
        }
        return new RestrictedBooleanDatatype(this, bl, bl2);
    }

    @Override
    public Datatype<? extends Boolean> getDatatype() {
        return this.dt;
    }

    @Override
    public Boolean getValue(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RestrictedDatatype<Boolean> intersect(RestrictedDatatype<?> restrictedDatatype, boolean bl) {
        if (restrictedDatatype instanceof RestrictedBooleanDatatype) {
            boolean bl2;
            RestrictedBooleanDatatype restrictedBooleanDatatype = (RestrictedBooleanDatatype)restrictedDatatype;
            boolean bl3 = this.permitTrue && restrictedBooleanDatatype.permitTrue;
            boolean bl4 = bl2 = this.permitFalse && restrictedBooleanDatatype.permitFalse;
            if (bl3 == this.permitTrue && bl2 == this.permitFalse) {
                return this;
            }
            if (bl3 == restrictedBooleanDatatype.permitTrue && bl2 == restrictedBooleanDatatype.permitFalse) {
                return restrictedBooleanDatatype;
            }
            return new RestrictedBooleanDatatype(this, bl3, bl2);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return !this.permitTrue && !this.permitFalse;
    }

    @Override
    public boolean isEnumerable() {
        return true;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public int size() {
        return (this.permitTrue ? 1 : 0) + (this.permitFalse ? 1 : 0);
    }

    @Override
    public RestrictedDatatype<Boolean> union(RestrictedDatatype<?> restrictedDatatype) {
        if (restrictedDatatype instanceof RestrictedBooleanDatatype) {
            boolean bl;
            RestrictedBooleanDatatype restrictedBooleanDatatype = (RestrictedBooleanDatatype)restrictedDatatype;
            boolean bl2 = this.permitTrue || restrictedBooleanDatatype.permitTrue;
            boolean bl3 = bl = this.permitFalse || restrictedBooleanDatatype.permitFalse;
            if (bl2 == this.permitTrue && bl == this.permitFalse) {
                return this;
            }
            if (bl2 == restrictedBooleanDatatype.permitTrue && bl == restrictedBooleanDatatype.permitFalse) {
                return restrictedBooleanDatatype;
            }
            return new RestrictedBooleanDatatype(this, bl2, bl);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<Boolean> valueIterator() {
        if (this.permitTrue) {
            if (this.permitFalse) {
                return Arrays.asList(Boolean.TRUE, Boolean.FALSE).iterator();
            }
            return Arrays.asList(Boolean.TRUE).iterator();
        }
        if (this.permitFalse) {
            return Arrays.asList(Boolean.FALSE).iterator();
        }
        return new EmptyIterator<Boolean>();
    }
}

