/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapiv3;

import com.clarkparsia.owlapiv3.OWL;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLEntityCollector;

public class OntologyUtils {
    private static OWLOntologyManager manager = OWL.manager;

    public static void addAxioms(OWLOntology oWLOntology, Collection<? extends OWLAxiom> collection) {
        OntologyUtils.updateOntology(oWLOntology, collection, true);
    }

    public static void addAxioms(OWLOntology oWLOntology, OWLAxiom ... oWLAxiomArray) {
        OntologyUtils.addAxioms(oWLOntology, Arrays.asList(oWLAxiomArray));
    }

    public static boolean containsClass(Set<Set<OWLClass>> set, OWLClass oWLClass) {
        for (Set<OWLClass> set2 : set) {
            if (!set2.contains(oWLClass)) continue;
            return true;
        }
        return false;
    }

    public static Set<OWLEntity> getSignature(OWLAxiom oWLAxiom) {
        HashSet<OWLEntity> hashSet = new HashSet<OWLEntity>();
        OWLEntityCollector oWLEntityCollector = new OWLEntityCollector(hashSet);
        oWLEntityCollector.setCollectDatatypes(false);
        oWLAxiom.accept((OWLObjectVisitor)oWLEntityCollector);
        return hashSet;
    }

    public static OWLOntology getOntologyFromAxioms(Collection<OWLAxiom> collection) {
        return OWL.Ontology(collection);
    }

    public static OWLOntology getOntologyFromAxioms(Collection<OWLAxiom> collection, IRI iRI) {
        return OWL.Ontology(collection, iRI);
    }

    public static OWLOntology getOntologyFromAxioms(OWLAxiom ... oWLAxiomArray) {
        return OWL.Ontology(Arrays.asList(oWLAxiomArray));
    }

    public static OWLOntologyManager getOWLOntologyManager() {
        return manager;
    }

    public static void clearOWLOntologyManager() {
        for (OWLOntology oWLOntology : manager.getOntologies()) {
            manager.removeOntology(oWLOntology);
        }
    }

    public static OWLOntology loadOntology(String string) {
        try {
            return manager.loadOntology(IRI.create((String)string));
        }
        catch (OWLOntologyCreationException oWLOntologyCreationException) {
            throw new OWLRuntimeException((Throwable)oWLOntologyCreationException);
        }
    }

    public static OWLOntology loadOntology(String string, boolean bl) {
        OWLOntology oWLOntology = OntologyUtils.loadOntology(string);
        if (!bl) {
            OntologyUtils.removeAllAnnotations(oWLOntology, manager);
        }
        return oWLOntology;
    }

    public static void printAxioms(Collection<? extends OWLAxiom> collection) {
        for (OWLAxiom oWLAxiom : collection) {
            System.out.println(oWLAxiom);
        }
    }

    public static void printOntology(OWLOntology oWLOntology) {
        OntologyUtils.printAxioms(oWLOntology.getAxioms());
    }

    public static void removeAxioms(OWLOntology oWLOntology, Collection<? extends OWLAxiom> collection) {
        OntologyUtils.updateOntology(oWLOntology, collection, false);
    }

    public static void removeAxioms(OWLOntology oWLOntology, OWLAxiom ... oWLAxiomArray) {
        OntologyUtils.removeAxioms(oWLOntology, Arrays.asList(oWLAxiomArray));
    }

    public static void save(OWLOntology oWLOntology, String string) throws OWLOntologyStorageException {
        manager.saveOntology(oWLOntology, IRI.create((URI)new File(string).toURI()));
    }

    public static void updateOntology(OWLOntology oWLOntology, Collection<? extends OWLAxiom> collection, boolean bl) {
        ArrayList<AddAxiom> arrayList = new ArrayList<AddAxiom>();
        for (OWLAxiom oWLAxiom : collection) {
            AddAxiom addAxiom = bl ? new AddAxiom(oWLOntology, oWLAxiom) : new RemoveAxiom(oWLOntology, oWLAxiom);
            arrayList.add(addAxiom);
        }
        manager.applyChanges(arrayList);
    }

    public static boolean containsUnreferencedEntity(OWLOntology oWLOntology, OWLClassExpression oWLClassExpression) {
        for (OWLEntity oWLEntity : oWLClassExpression.getSignature()) {
            if (oWLOntology.containsEntityInSignature(oWLEntity) || oWLEntity instanceof OWLClass && (((OWLClass)oWLEntity).isOWLThing() || ((OWLClass)oWLEntity).isOWLNothing())) continue;
            return true;
        }
        return false;
    }

    public static Set<OWLOntology> removeAxiom(OWLAxiom oWLAxiom, Set<OWLOntology> set, OWLOntologyManager oWLOntologyManager) {
        HashSet<OWLOntology> hashSet = new HashSet<OWLOntology>();
        for (OWLOntology oWLOntology : set) {
            if (!oWLOntology.getAxioms().contains(oWLAxiom)) continue;
            hashSet.add(oWLOntology);
            oWLOntologyManager.applyChange((OWLOntologyChange)new RemoveAxiom(oWLOntology, oWLAxiom));
        }
        return hashSet;
    }

    public static void addAxiom(OWLAxiom oWLAxiom, Set<OWLOntology> set, OWLOntologyManager oWLOntologyManager) {
        for (OWLOntology oWLOntology : set) {
            oWLOntologyManager.applyChange((OWLOntologyChange)new AddAxiom(oWLOntology, oWLAxiom));
        }
    }

    public static void removeAllAnnotations(OWLOntology oWLOntology, OWLOntologyManager oWLOntologyManager) {
        try {
            HashSet hashSet = new HashSet();
            hashSet.addAll(oWLOntology.getClassesInSignature());
            hashSet.addAll(oWLOntology.getObjectPropertiesInSignature());
            hashSet.addAll(oWLOntology.getDataPropertiesInSignature());
            hashSet.addAll(oWLOntology.getIndividualsInSignature());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (OWLAxiom oWLAxiom : oWLOntology.getAxioms()) {
                if (oWLAxiom.isLogicalAxiom()) continue;
                arrayList.add(new RemoveAxiom(oWLOntology, oWLAxiom));
            }
            oWLOntologyManager.applyChanges(arrayList);
            arrayList = new ArrayList();
            for (OWLAxiom oWLAxiom : hashSet) {
                if (oWLOntology.containsEntityInSignature((OWLEntity)oWLAxiom)) continue;
                OWLDeclarationAxiom oWLDeclarationAxiom = oWLOntologyManager.getOWLDataFactory().getOWLDeclarationAxiom((OWLEntity)oWLAxiom);
                arrayList.add(new AddAxiom(oWLOntology, (OWLAxiom)oWLDeclarationAxiom));
            }
            oWLOntologyManager.applyChanges(arrayList);
        }
        catch (OWLOntologyChangeException oWLOntologyChangeException) {
            throw new OWLRuntimeException((Throwable)oWLOntologyChangeException);
        }
    }

    public static OWLEntity findEntity(String string, Set<OWLOntology> set) {
        OWLOntology oWLOntology;
        OWLEntity oWLEntity = null;
        Iterator<OWLOntology> iterator = set.iterator();
        while (iterator.hasNext() && (oWLEntity = OntologyUtils.findEntity(string, oWLOntology = iterator.next())) == null) {
        }
        return oWLEntity;
    }

    public static OWLEntity findEntity(String string, OWLOntology oWLOntology) {
        OWLClass oWLClass = null;
        if (string.equals("owl:Thing")) {
            oWLClass = OWL.Thing;
        } else if (string.equals("owl:Nothing")) {
            oWLClass = OWL.Nothing;
        } else {
            IRI iRI;
            IRI iRI2 = IRI.create((String)string);
            if (iRI2 == null) {
                throw new RuntimeException("Invalid IRI: " + iRI2);
            }
            if (!iRI2.isAbsolute() && (iRI = oWLOntology.getOntologyID().getOntologyIRI()) != null) {
                iRI2 = iRI.resolve("#" + iRI2);
            }
            if (oWLOntology.containsClassInSignature(iRI2)) {
                oWLClass = OWL.Class(iRI2);
            } else if (oWLOntology.containsObjectPropertyInSignature(iRI2)) {
                oWLClass = OWL.ObjectProperty(iRI2);
            } else if (oWLOntology.containsDataPropertyInSignature(iRI2)) {
                oWLClass = OWL.DataProperty(iRI2);
            } else if (oWLOntology.containsIndividualInSignature(iRI2)) {
                oWLClass = OWL.Individual(iRI2).asOWLNamedIndividual();
            }
        }
        return oWLClass;
    }
}

