/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.owl.owlapi.tutorialowled2011;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.debugging.BlackBoxOWLDebugger;
import org.semanticweb.owlapi.debugging.OWLDebugger;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import uk.ac.manchester.owl.owlapi.tutorialowled2011.OWLTutorialSyntaxObjectRenderer;

public class Debugger {
    private final OWLOntology ontology;
    private final OWLDebugger debugger;
    private final OWLReasoner checker;
    private final OWLClass bottom;

    public Debugger(OWLOntologyManager manager, OWLOntology ontology, OWLReasonerFactory reasonerFactory) {
        this.ontology = ontology;
        this.checker = reasonerFactory.createNonBufferingReasoner(ontology);
        this.debugger = new BlackBoxOWLDebugger(manager, ontology, reasonerFactory);
        this.bottom = manager.getOWLDataFactory().getOWLNothing();
    }

    public void report(PrintWriter writer) throws OWLException {
        OWLTutorialSyntaxObjectRenderer renderer = new OWLTutorialSyntaxObjectRenderer(this.ontology, writer);
        renderer.header();
        HashSet<OWLClass> unsatisfiables = new HashSet<OWLClass>();
        for (OWLClass clazz : this.ontology.getClassesInSignature()) {
            if (this.checker.isSatisfiable(clazz) || clazz.equals(this.bottom)) continue;
            unsatisfiables.add(clazz);
        }
        writer.println("<h1>Ontology Debugging Report</h1>");
        writer.println("<p>Ontology: " + this.ontology.getOntologyID() + "</p>");
        if (unsatisfiables.isEmpty()) {
            writer.println("<p>No Unsatisfiable Classes found</p>");
        } else {
            for (OWLClass unsatisfiable : unsatisfiables) {
                writer.println("<div class='box'>\n");
                writer.println("<h2 class='cl'>");
                unsatisfiable.accept(renderer);
                writer.println("</h2>");
                writer.println("<p>Axioms causing inconsistency:</p>");
                writer.println("<ul>");
                Set<OWLAxiom> sos = this.debugger.getSOSForIncosistentClass(unsatisfiable);
                for (OWLAxiom axiom : sos) {
                    writer.println("<li>");
                    axiom.accept(renderer);
                    writer.println("</li>");
                }
                writer.println("</ul>");
                writer.println("</div>\n");
            }
        }
        renderer.footer();
    }
}

